/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.builder;

import com.googlecode.pngtastic.core.PngChunk;
import com.googlecode.pngtastic.core.PngImage;
import com.googlecode.pngtastic.core.PngOptimizer;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.tizen.common.builder.BuildResult;
import org.tizen.common.builder.core.AbstractBuilder;
import org.tizen.common.builder.exception.BuildException;
import org.tizen.common.file.FileHandler;
import org.tizen.common.file.IResource;
import org.tizen.common.util.FileUtil;
import org.tizen.sdblib.util.IOUtil;

public class PNGOptimizeBuilder
extends AbstractBuilder {
    public PNGOptimizeBuilder(FileHandler outputFh) {
        super(outputFh);
    }

    public PNGOptimizeBuilder(String outputPath) {
        super(outputPath);
    }

    public boolean canBuild(IResource resource) {
        String extension = FileUtil.getFileExtension((String)resource.getPath());
        if (!"png".equalsIgnoreCase(extension)) {
            return false;
        }
        return super.canBuild(resource);
    }

    protected BuildResult doBuild(IResource resource) throws BuildException {
        BuildResult buildResult;
        PngOptimizer po = new PngOptimizer();
        InputStream contents = null;
        InputStream compContents = null;
        BuildResult br = new BuildResult(BuildResult.Status.UNKNOWN);
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            contents = resource.getContents();
            PngImage pi = new PngImage(contents);
            PngImage outputPi = po.optimize(pi, Integer.valueOf(9));
            this.writeDataOutputStream(outputPi, baos);
            compContents = resource.getContents();
            byte[] inputs = IOUtil.getBytes((InputStream)compContents);
            byte[] outputs = baos.toByteArray();
            if (inputs.length > outputs.length) {
                this.addOutputResource(br, resource, resource.getPath(), outputs);
            }
            br.setResult(BuildResult.Status.SUCCESS);
            buildResult = br;
        }
        catch (IOException e) {
            try {
                throw new BuildException("Could not optimize " + resource.getPath(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{contents, compContents, baos});
                throw throwable;
            }
        }
        IOUtil.tryClose((Object[])new Object[]{contents, compContents, baos});
        return buildResult;
    }

    DataOutputStream writeDataOutputStream(PngImage pi, OutputStream os) throws IOException {
        DataOutputStream dos = null;
        try {
            dos = new DataOutputStream(os);
            dos.writeLong(-8552249625308161526L);
            for (PngChunk chunk : pi.getChunks()) {
                byte[] data;
                dos.writeInt(chunk.getLength());
                byte[] type = chunk.getType();
                if (type != null) {
                    dos.write(type);
                }
                if ((data = chunk.getData()) != null) {
                    dos.write(data);
                }
                int i = (int)chunk.getCRC();
                dos.writeInt(i);
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose(dos);
            throw throwable;
        }
        IOUtil.tryClose((Closeable)dos);
        return dos;
    }
}

