/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.pngtastic.core;

import com.googlecode.pngtastic.core.Logger;
import com.googlecode.pngtastic.core.PngChunk;
import com.googlecode.pngtastic.core.PngException;
import com.googlecode.pngtastic.core.PngFilterType;
import com.googlecode.pngtastic.core.PngImage;
import com.googlecode.pngtastic.core.PngImageType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PngOptimizer {
    private final Logger log;
    private static final List<Integer> compressionStrategies = Arrays.asList(0, 1, 2);
    private final List<Stats> stats = new ArrayList<Stats>();

    public List<Stats> getStats() {
        return this.stats;
    }

    public PngOptimizer() {
        this("NONE");
    }

    public PngOptimizer(String logLevel) {
        this.log = new Logger(logLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimize(PngImage image, String outputFileName, Integer compressionLevel) throws FileNotFoundException, IOException {
        this.log.debug("=== OPTIMIZING ===", new Object[0]);
        long start = System.currentTimeMillis();
        PngImage optimized = this.optimize(image, compressionLevel);
        ByteArrayOutputStream optimizedBytes = new ByteArrayOutputStream();
        DataOutputStream output = optimized.writeDataOutputStream(optimizedBytes);
        File originalFile = new File(image.getFileName());
        long originalFileSize = originalFile.length();
        File exported = null;
        if ((long)output.size() < originalFileSize) {
            exported = optimized.export(outputFileName, optimizedBytes.toByteArray());
        } else {
            ByteBuffer buffer = ByteBuffer.allocate((int)originalFileSize);
            FileInputStream ins = null;
            try {
                ins = new FileInputStream(originalFile);
                ins.getChannel().read(buffer);
            }
            finally {
                if (ins != null) {
                    ins.close();
                }
            }
            exported = new File(outputFileName);
            optimized.writeFileOutputStream(exported, buffer.array());
        }
        long optimizedFileSize = exported.length();
        long time = System.currentTimeMillis() - start;
        this.log.debug("Optimized in %d milliseconds", time);
        this.log.debug("Original length in bytes: %d (%s)", originalFileSize, image.getFileName());
        this.log.debug("Final length in bytes: %d (%s)", optimizedFileSize, outputFileName);
        if (optimizedFileSize <= originalFileSize) {
            this.log.info("%5.2f%% :%6dB ->%6dB (%5dB saved) - %s", Float.valueOf((float)(originalFileSize - optimizedFileSize) / Float.valueOf(originalFileSize).floatValue() * 100.0f), originalFileSize, optimizedFileSize, originalFileSize - optimizedFileSize, outputFileName);
        } else {
            this.log.info("%5.2f%% :%6dB ->%6dB (%5dB saved) - %s", Float.valueOf((float)(-(optimizedFileSize - originalFileSize)) / Float.valueOf(originalFileSize).floatValue() * 100.0f), originalFileSize, optimizedFileSize, -(optimizedFileSize - originalFileSize), outputFileName);
        }
        this.stats.add(new Stats(originalFileSize, optimizedFileSize));
    }

    public PngImage optimize(PngImage image, Integer compressionLevel) throws IOException {
        if (image.getInterlace() == 1) {
            return image;
        }
        PngImage result = new PngImage(this.log);
        Iterator<PngChunk> itChunks = image.getChunks().iterator();
        PngChunk chunk = null;
        while (itChunks.hasNext() && !"IDAT".equals((chunk = itChunks.next()).getTypeString())) {
            if (!chunk.isRequired()) continue;
            ByteArrayOutputStream bytes = new ByteArrayOutputStream(chunk.getLength());
            DataOutputStream data = new DataOutputStream(bytes);
            data.write(chunk.getData());
            data.close();
            PngChunk newChunk = new PngChunk(chunk.getType(), bytes.toByteArray());
            result.addChunk(newChunk);
        }
        ByteArrayOutputStream imageBytes = new ByteArrayOutputStream(chunk.getLength());
        DataOutputStream imageData = new DataOutputStream(imageBytes);
        while (chunk != null && "IDAT".equals(chunk.getTypeString())) {
            imageData.write(chunk.getData());
            chunk = itChunks.hasNext() ? itChunks.next() : null;
        }
        imageData.close();
        byte[] inflatedImageData = this.inflateImageData(imageBytes);
        int scanlineLength = Double.valueOf(Math.ceil((float)Long.valueOf(image.getWidth() * (long)image.getSampleBitCount()).longValue() / 8.0f)).intValue() + 1;
        List<byte[]> originalScanlines = this.getScanlines(inflatedImageData, image.getSampleBitCount(), scanlineLength, image.getHeight());
        HashMap<PngFilterType, List<byte[]>> filteredScanlines = new HashMap<PngFilterType, List<byte[]>>();
        for (PngFilterType filterType : PngFilterType.standardValues()) {
            this.log.debug("Applying filter: %s", new Object[]{filterType});
            List<byte[]> scanlines = this.copyScanlines(originalScanlines);
            this.applyFiltering(filterType, scanlines, image.getSampleBitCount());
            filteredScanlines.put(filterType, scanlines);
        }
        PngFilterType bestFilterType = null;
        byte[] deflatedImageData = null;
        for (Map.Entry entry : filteredScanlines.entrySet()) {
            byte[] imageResult = this.deflateImageData(this.serialize((List)entry.getValue()), compressionLevel);
            if (deflatedImageData != null && imageResult.length >= deflatedImageData.length) continue;
            deflatedImageData = imageResult;
            bestFilterType = (PngFilterType)((Object)entry.getKey());
        }
        List<byte[]> scanlines = this.copyScanlines(originalScanlines);
        this.applyAdaptiveFiltering(inflatedImageData, scanlines, filteredScanlines, image.getSampleBitCount());
        byte[] adaptiveImageData = this.deflateImageData(inflatedImageData, compressionLevel);
        if (deflatedImageData == null || adaptiveImageData.length < deflatedImageData.length) {
            deflatedImageData = adaptiveImageData;
            bestFilterType = PngFilterType.ADAPTIVE;
            this.log.debug("Adaptive=%d, Other=%d", adaptiveImageData.length, deflatedImageData.length);
        }
        this.log.debug("Best filter type: %s", new Object[]{bestFilterType});
        PngChunk imageChunk = new PngChunk("IDAT".getBytes(), deflatedImageData);
        result.addChunk(imageChunk);
        while (chunk != null) {
            if (chunk.isCritical()) {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream(chunk.getLength());
                DataOutputStream data = new DataOutputStream(bytes);
                data.write(chunk.getData());
                data.close();
                PngChunk newChunk = new PngChunk(chunk.getType(), bytes.toByteArray());
                result.addChunk(newChunk);
            }
            chunk = itChunks.hasNext() ? itChunks.next() : null;
        }
        return result;
    }

    private List<byte[]> getScanlines(byte[] inflatedImageData, int sampleBitCount, int rowLength, long height) {
        ArrayList<byte[]> rows = new ArrayList<byte[]>(Math.max((int)height, 0));
        byte[] previousRow = new byte[rowLength];
        int i = 0;
        while ((long)i < height) {
            int offset = i * rowLength;
            byte[] row = new byte[rowLength];
            System.arraycopy(inflatedImageData, offset, row, 0, rowLength);
            try {
                this.deFilter(row, previousRow, sampleBitCount);
                rows.add(row);
                previousRow = (byte[])row.clone();
            }
            catch (PngException e) {
                this.log.error("Error: %s", e.getMessage());
            }
            ++i;
        }
        return rows;
    }

    private List<byte[]> copyScanlines(List<byte[]> original) {
        ArrayList<byte[]> copy = new ArrayList<byte[]>(original.size());
        for (byte[] scanline : original) {
            copy.add((byte[])scanline.clone());
        }
        return copy;
    }

    private void applyFiltering(PngFilterType filterType, List<byte[]> scanlines, int sampleBitCount) {
        int i = 0;
        int scanlineLength = scanlines.get(0).length;
        byte[] previousRow = new byte[scanlineLength];
        for (byte[] scanline : scanlines) {
            if (filterType != null) {
                scanline[0] = filterType.getValue();
            }
            byte[] previous = (byte[])scanline.clone();
            try {
                this.filter(scanline, previousRow, sampleBitCount);
            }
            catch (PngException e) {
                this.log.error("Error during filtering: %s", e.getMessage());
            }
            previousRow = previous;
            ++i;
        }
    }

    private void applyAdaptiveFiltering(byte[] inflatedImageData, List<byte[]> scanlines, Map<PngFilterType, List<byte[]>> filteredScanLines, int sampleSize) throws IOException {
        for (int s = 0; s < scanlines.size(); ++s) {
            long bestSum = Long.MAX_VALUE;
            PngFilterType bestFilterType = null;
            for (Map.Entry<PngFilterType, List<byte[]>> entry : filteredScanLines.entrySet()) {
                long sum = 0L;
                byte[] scanline = entry.getValue().get(s);
                for (int i = 1; i < scanline.length; ++i) {
                    sum += (long)Math.abs(scanline[i]);
                }
                if (sum >= bestSum) continue;
                bestFilterType = entry.getKey();
                bestSum = sum;
            }
            scanlines.get((int)s)[0] = bestFilterType.getValue();
        }
        this.applyFiltering(null, scanlines, sampleSize);
    }

    private byte[] serialize(List<byte[]> scanlines) {
        int scanlineLength = scanlines.get(0).length;
        byte[] imageData = new byte[scanlineLength * scanlines.size()];
        for (int i = 0; i < scanlines.size(); ++i) {
            int offset = i * scanlineLength;
            byte[] scanline = scanlines.get(i);
            System.arraycopy(scanline, 0, imageData, offset, scanlineLength);
        }
        return imageData;
    }

    private void filter(byte[] line, byte[] previousLine, int sampleBitCount) throws PngException {
        PngFilterType filterType = PngFilterType.forValue(line[0]);
        line[0] = 0;
        PngFilterType previousFilterType = PngFilterType.forValue(previousLine[0]);
        previousLine[0] = 0;
        switch (filterType) {
            case NONE: {
                break;
            }
            case SUB: {
                byte[] original = (byte[])line.clone();
                int previous = -(Math.max(1, sampleBitCount / 8) - 1);
                int x = 1;
                int a = previous;
                while (x < line.length) {
                    line[x] = (byte)(original[x] - (a < 0 ? (byte)0 : original[a]));
                    ++x;
                    ++a;
                }
                break;
            }
            case UP: {
                for (int x = 1; x < line.length; ++x) {
                    line[x] = (byte)(line[x] - previousLine[x]);
                }
                break;
            }
            case AVERAGE: {
                byte[] original = (byte[])line.clone();
                int previous = -(Math.max(1, sampleBitCount / 8) - 1);
                int x = 1;
                int a = previous;
                while (x < line.length) {
                    line[x] = (byte)(original[x] - ((0xFF & original[a < 0 ? 0 : a]) + (0xFF & previousLine[x])) / 2);
                    ++x;
                    ++a;
                }
                break;
            }
            case PAETH: {
                byte[] original = (byte[])line.clone();
                int previous = -(Math.max(1, sampleBitCount / 8) - 1);
                int x = 1;
                int a = previous;
                while (x < line.length) {
                    int result = this.paethPredictor(original, previousLine, x, a);
                    line[x] = (byte)(original[x] - result);
                    ++x;
                    ++a;
                }
                break;
            }
            default: {
                throw new PngException("Unrecognized filter type " + (Object)((Object)filterType));
            }
        }
        line[0] = filterType.getValue();
        previousLine[0] = previousFilterType.getValue();
    }

    private void deFilter(byte[] line, byte[] previousLine, int sampleBitCount) throws PngException {
        PngFilterType filterType = PngFilterType.forValue(line[0]);
        line[0] = 0;
        PngFilterType previousFilterType = PngFilterType.forValue(previousLine[0]);
        previousLine[0] = 0;
        switch (filterType) {
            case SUB: {
                int previous = -(Math.max(1, sampleBitCount / 8) - 1);
                int x = 1;
                int a = previous;
                while (x < line.length) {
                    line[x] = (byte)(line[x] + (a < 0 ? (byte)0 : line[a]));
                    ++x;
                    ++a;
                }
                break;
            }
            case UP: {
                for (int x = 1; x < line.length; ++x) {
                    line[x] = (byte)(line[x] + previousLine[x]);
                }
                break;
            }
            case AVERAGE: {
                int previous = -(Math.max(1, sampleBitCount / 8) - 1);
                int x = 1;
                int a = previous;
                while (x < line.length) {
                    line[x] = (byte)(line[x] + ((0xFF & (a < 0 ? 0 : line[a])) + (0xFF & previousLine[x])) / 2);
                    ++x;
                    ++a;
                }
                break;
            }
            case PAETH: {
                int previous = -(Math.max(1, sampleBitCount / 8) - 1);
                int x = 1;
                int xp = previous;
                while (x < line.length) {
                    int result = this.paethPredictor(line, previousLine, x, xp);
                    line[x] = (byte)(line[x] + result);
                    ++x;
                    ++xp;
                }
                break;
            }
        }
        line[0] = filterType.getValue();
        previousLine[0] = previousFilterType.getValue();
    }

    private int paethPredictor(byte[] line, byte[] previousLine, int x, int xp) {
        int pc;
        int a = 0xFF & (xp < 0 ? 0 : line[xp]);
        int b = 0xFF & previousLine[x];
        int c = 0xFF & (xp < 0 ? 0 : previousLine[xp]);
        int p = a + b - c;
        int pa = p >= a ? p - a : -(p - a);
        int pb = p >= b ? p - b : -(p - b);
        int n = pc = p >= c ? p - c : -(p - c);
        if (pa <= pb && pa <= pc) {
            return a;
        }
        return pb <= pc ? b : c;
    }

    private byte[] deflateImageData(byte[] inflatedImageData, Integer compressionLevel) throws IOException {
        List<byte[]> results = this.deflateImageDataConcurrently(inflatedImageData, compressionLevel);
        byte[] result = null;
        for (int i = 0; i < results.size(); ++i) {
            byte[] data = results.get(i);
            if (result != null && data.length >= result.length) continue;
            result = data;
        }
        this.log.debug("Image bytes=%d", result.length);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<byte[]> deflateImageDataConcurrently(final byte[] inflatedImageData, final Integer compressionLevel) {
        final ConcurrentLinkedQueue results = new ConcurrentLinkedQueue();
        ArrayList<Callable<Object>> tasks = new ArrayList<Callable<Object>>();
        for (final int strategy : compressionStrategies) {
            tasks.add(Executors.callable(new Runnable(){

                public void run() {
                    try {
                        results.add(PngOptimizer.this.deflateImageData(inflatedImageData, strategy, compressionLevel));
                    }
                    catch (Throwable e) {
                        PngOptimizer.this.log.error("Uncaught Exception: %s", e.getMessage());
                    }
                }
            }));
        }
        ExecutorService compressionThreadPool = Executors.newFixedThreadPool(compressionStrategies.size());
        try {
            compressionThreadPool.invokeAll(tasks);
        }
        catch (InterruptedException ex) {
        }
        finally {
            compressionThreadPool.shutdown();
        }
        return new ArrayList<byte[]>(results);
    }

    private byte[] deflateImageData(byte[] inflatedImageData, int strategy, Integer compressionLevel) throws IOException {
        byte[] result = null;
        int bestCompression = 9;
        if (compressionLevel == null || compressionLevel > 9 || compressionLevel < 0) {
            for (int compression = 9; compression > 0; --compression) {
                ByteArrayOutputStream deflatedOut = this.deflate(inflatedImageData, strategy, compression);
                if (result != null && result.length <= deflatedOut.size()) continue;
                result = deflatedOut.toByteArray();
                bestCompression = compression;
            }
        } else {
            result = this.deflate(inflatedImageData, strategy, compressionLevel).toByteArray();
            bestCompression = compressionLevel;
        }
        this.log.debug("Compression strategy: %s, compression level=%d, bytes=%d", strategy, bestCompression, result.length);
        return result;
    }

    private ByteArrayOutputStream deflate(byte[] inflatedImageData, int strategy, int compression) throws IOException {
        ByteArrayOutputStream deflatedOut = new ByteArrayOutputStream();
        Deflater deflater = new Deflater(compression);
        deflater.setStrategy(strategy);
        DeflaterOutputStream stream = new DeflaterOutputStream((OutputStream)deflatedOut, deflater);
        stream.write(inflatedImageData);
        stream.close();
        return deflatedOut;
    }

    private byte[] inflateImageData(ByteArrayOutputStream imageBytes) throws IOException {
        int readLength;
        InflaterInputStream inflater = new InflaterInputStream(new ByteArrayInputStream(imageBytes.toByteArray()));
        ByteArrayOutputStream inflatedOut = new ByteArrayOutputStream();
        byte[] block = new byte[8192];
        while ((readLength = inflater.read(block)) != -1) {
            inflatedOut.write(block, 0, readLength);
        }
        byte[] inflatedImageData = inflatedOut.toByteArray();
        return inflatedImageData;
    }

    private Set<PngPixel> getColors(PngImage original, List<byte[]> rows) throws IOException {
        HashSet<PngPixel> colors = new HashSet<PngPixel>();
        PngImageType imageType = PngImageType.forColorType(original.getColorType());
        int sampleSize = original.getSampleBitCount();
        for (byte[] row : rows) {
            int sampleCount = (row.length - 1) * 8 / sampleSize;
            ByteArrayInputStream ins = new ByteArrayInputStream(row);
            DataInputStream dis = new DataInputStream(ins);
            dis.readUnsignedByte();
            block7: for (int i = 0; i < sampleCount; ++i) {
                switch (imageType) {
                    case INDEXED_COLOR: {
                        continue block7;
                    }
                    case GREYSCALE: 
                    case GREYSCALE_ALPHA: {
                        continue block7;
                    }
                    case TRUECOLOR: {
                        int blue;
                        int green;
                        int red;
                        if (original.getBitDepth() == 8) {
                            red = dis.readUnsignedByte();
                            green = dis.readUnsignedByte();
                            blue = dis.readUnsignedByte();
                            colors.add(new PngPixel(red, green, blue));
                            continue block7;
                        }
                        red = dis.readUnsignedShort();
                        green = dis.readUnsignedShort();
                        blue = dis.readUnsignedShort();
                        colors.add(new PngPixel(red, green, blue));
                        continue block7;
                    }
                    case TRUECOLOR_ALPHA: {
                        int alpha;
                        int blue;
                        int green;
                        int red;
                        if (original.getBitDepth() == 8) {
                            red = dis.readUnsignedByte();
                            green = dis.readUnsignedByte();
                            blue = dis.readUnsignedByte();
                            alpha = dis.readUnsignedByte();
                            colors.add(new PngPixel(red, green, blue, alpha));
                            continue block7;
                        }
                        red = dis.readUnsignedShort();
                        green = dis.readUnsignedShort();
                        blue = dis.readUnsignedShort();
                        alpha = dis.readUnsignedShort();
                        colors.add(new PngPixel(red, green, blue, alpha));
                        continue block7;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
        }
        this.log.debug("color count=%d", colors.size());
        return colors;
    }

    public long getTotalSavings() {
        long totalSavings = 0L;
        for (Stats stat : this.getStats()) {
            totalSavings += stat.getOriginalFileSize() - stat.getOptimizedFileSize();
        }
        return totalSavings;
    }

    private void printData(byte[] inflatedImageData) {
        StringBuilder result = new StringBuilder();
        for (byte b : inflatedImageData) {
            result.append(String.format("%2x|", b));
        }
        this.log.debug(result.toString(), new Object[0]);
    }

    public static class Stats {
        private long originalFileSize;
        private long optimizedFileSize;

        public long getOriginalFileSize() {
            return this.originalFileSize;
        }

        public long getOptimizedFileSize() {
            return this.optimizedFileSize;
        }

        public Stats(long originalFileSize, long optimizedFileSize) {
            this.originalFileSize = originalFileSize;
            this.optimizedFileSize = optimizedFileSize;
        }
    }

    private static class PngPixel {
        private final int red;
        private final int green;
        private final int blue;
        private final int alpha;

        public PngPixel(int red, int green, int blue) {
            this(red, green, blue, -1);
        }

        public PngPixel(int red, int green, int blue, int alpha) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.alpha;
            result = 31 * result + this.blue;
            result = 31 * result + this.green;
            result = 31 * result + this.red;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PngPixel other = (PngPixel)obj;
            return this.alpha == other.alpha && this.blue == other.blue && this.green == other.green && this.red == other.red;
        }
    }
}

