/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.step;

import java.io.Closeable;
import org.eclipse.core.resources.IProject;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.launch.context.ILaunchContext;
import org.tizen.common.rds.RdsDeltaDetector;
import org.tizen.common.util.log.UserLogger;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.service.SyncResult;
import org.tizen.sdblib.service.SyncService;
import org.tizen.sdblib.util.IOUtil;
import org.tizen.web.zimlaunch.core.CompositeStep;
import org.tizen.web.zimlaunch.core.IStep;
import org.tizen.web.zimlaunch.exception.TizenWebIDEException;
import org.tizen.web.zimlaunch.exception.TizenWebIDEExceptionCode;
import org.tizen.web.zimlaunch.notification.TizenWebNotifier;
import org.tizen.web.zimlaunch.resource.ZimLaunchResource;
import org.tizen.web.zimlaunch.step.Messages;
import org.tizen.web.zimlaunch.util.CommandLauncher;

public class RdsDeltaInputStep
extends CompositeStep {
    protected static final Logger logger = LoggerFactory.getLogger(RdsDeltaInputStep.class);
    public static final String name = Messages.STEP_RDS_DELTA;
    protected CommandLauncher launcher;
    protected TizenWebNotifier notifier;
    protected ZimLaunchResource resource;
    protected RdsDeltaDetector deltaDetector;
    protected boolean isInstalled;
    protected String mode;
    protected IDevice device;
    protected IProject project;
    protected int percent;

    public RdsDeltaInputStep() {
        super(new IStep[0]);
    }

    @Override
    public void executeStep(ILaunchContext ctx) throws Exception {
        UserLogger.start((String)"web.launch", (String)".rds.delta");
        this.preExecuteStep(ctx);
        String errMsg = "";
        int code = 0;
        String rdsDeltaPath = this.getRdsDeltaPath();
        this.project.refreshLocal(2, null);
        String strResInfoFile = this.deltaDetector.makeDeltaFile();
        String strRemotePath = String.valueOf(rdsDeltaPath) + "/info/";
        SyncService service = null;
        try {
            service = this.device.getSyncService();
            SyncResult syncSuccess = service.push(strResInfoFile, this.device.getFileEntry(strRemotePath));
            code = syncSuccess.getCode();
            if (!syncSuccess.isOk()) {
                errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)name);
                TizenWebIDEException.abort(Messages.getFailMessage((String)Messages.STEP_RDS_DELTA), new TizenWebIDEException(errMsg, code), new TizenWebNotifier[0]);
            }
        }
        finally {
            IOUtil.tryClose((Closeable)service);
        }
        logger.debug(Messages.getSuccessMessage((String)Messages.STEP_RDS_DELTA));
        this.handleCancelEvent(this.notifier, this.notifier.getMonitor());
        UserLogger.end((String)"web.launch", (String)".rds.delta");
    }

    public String getRdsDeltaPath() {
        String deltaPath = String.valueOf(TizenPlatformConstants.getAppTmpDirectory((IDevice)this.device)) + "/" + this.resource.getAppinfo().getAppPackageID();
        return deltaPath;
    }

    protected void preExecuteStep(ILaunchContext ctx) throws Exception {
        String errMsg = "";
        int code = 0;
        this.launcher = (CommandLauncher)ctx.getValue((Object)"command launcher");
        String eMsg = Messages.getFailMessage((String)Messages.TRANSFER_PACKAGE);
        if (this.launcher == null) {
            code = TizenWebIDEExceptionCode.WEB_IDE_STEPCONTEXT_CAN_NOT_FIND_COMMNAD_LAUNCHER.getCode();
            errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)Messages.STEP_CONTEXT_HANDLE);
            TizenWebIDEException.abort(eMsg, new TizenWebIDEException(errMsg, code), new TizenWebNotifier[0]);
        }
        this.resource = (ZimLaunchResource)ctx.getValue((Object)"resource");
        if (this.resource == null) {
            code = TizenWebIDEExceptionCode.WEB_IDE_STEPCONTEXT_CAN_NOT_FIND_LAUNCH_RESOURCE.getCode();
            errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)Messages.STEP_CONTEXT_HANDLE);
            TizenWebIDEException.abort(eMsg, new TizenWebIDEException(errMsg, code), new TizenWebNotifier[0]);
        }
        this.notifier = (TizenWebNotifier)ctx.getValue((Object)"notifier");
        this.isInstalled = (Boolean)ctx.getValue((Object)"widget installation");
        this.mode = (String)ctx.getValue((Object)"mode");
        this.device = this.resource.getDeviceinfo().getDevice();
        this.project = this.resource.getAppinfo().getProject();
        this.deltaDetector = new RdsDeltaDetector(this.device, this.project, this.getRdsDeltaPath());
        this.work = 100;
        this.rwork = 100;
        this.percent = 10;
        this.pwork = this.notifier.getRemainWork() < 20 ? this.notifier.getPercentRemainWork(this.percent) : 10;
    }

    @Override
    public String getStepName() {
        return name;
    }
}

