/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.builder.util;

import java.io.InputStream;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.tizen.web.config.schema.model.Category;
import org.tizen.web.config.schema.model.Widget;
import org.tizen.web.editor.configuration.ConfigurationException;
import org.tizen.web.editor.configuration.ConfiguratorFactory;
import org.tizen.web.editor.configuration.IMobileConfigurator;
import org.tizen.web.editor.configuration.ITizenConfigurator;

public class WebProjectUtil {
    static final String FONT_PACKAGE_CATEGORY = "http://tizen.org/category/downloadable_font";

    public static boolean isFontProject(InputStream configContents) throws ConfigurationException {
        Widget widget = ConfiguratorFactory.unmarshal((InputStream)configContents);
        List contents = widget.getContent();
        if (contents == null) {
            return false;
        }
        for (Object content : contents) {
            if (!(content instanceof Category) || !FONT_PACKAGE_CATEGORY.equals(((Category)content).getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isFontProject(IProject project) throws ConfigurationException {
        ITizenConfigurator wgtConfig = ConfiguratorFactory.unmarshalWidgetConfiguration((IProject)project);
        if (wgtConfig instanceof IMobileConfigurator) {
            List categories = ((IMobileConfigurator)wgtConfig).getCategories();
            if (categories == null) {
                return false;
            }
            for (Category category : categories) {
                if (!FONT_PACKAGE_CATEGORY.equals(category.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

