/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.wizard.model;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipFile;
import org.eclipse.ui.internal.wizards.datatransfer.ArchiveFileManipulations;
import org.eclipse.ui.internal.wizards.datatransfer.ZipLeveledStructureProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.tproject.TprojectHandler;
import org.tizen.web.project.wizard.WizardMessages;

public class SourceProject {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String path;
    private boolean isZipFile;
    private boolean isAvailableProject;
    private String platformName;
    private File projectDescriptionFile;

    public SourceProject(String path) {
        this.path = path;
        this.isZipFile = ArchiveFileManipulations.isZipFile((String)this.path);
        this.isAvailableProject = this.checkAvailableProject();
    }

    public String getPath() {
        return this.path;
    }

    public boolean isZipFile() {
        return this.isZipFile;
    }

    public File getProjectDescriptioinFile() {
        return this.projectDescriptionFile;
    }

    public ZipFile getZipFile() throws IOException {
        return new ZipFile(this.path);
    }

    public boolean isAvailableProject() {
        return this.isAvailableProject;
    }

    public ZipLeveledStructureProvider getStructureProvider() throws IOException {
        ZipFile zipFile = this.getZipFile();
        return new ZipLeveledStructureProvider(zipFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkAvailableProject() {
        boolean result = false;
        if (this.isZipFile) {
            ZipLeveledStructureProvider structureProvider = null;
            try {
                String elementLabel;
                structureProvider = this.getStructureProvider();
                Object child = structureProvider.getRoot();
                List children = structureProvider.getChildren(child);
                if (children == null) {
                    children = Collections.EMPTY_LIST;
                }
                Iterator childrenEnum = children.iterator();
                do {
                    if (childrenEnum.hasNext()) continue;
                    return result;
                } while (structureProvider.isFolder(child = childrenEnum.next()) || !(elementLabel = structureProvider.getLabel(child)).equalsIgnoreCase("config.xml"));
                return true;
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                return result;
            }
            finally {
                if (structureProvider != null) {
                    structureProvider.closeArchive();
                }
            }
        }
        File directory = new File(this.path);
        if (!directory.isDirectory()) return result;
        File[] childs = directory.listFiles();
        if (childs == null) return result;
        File[] fileArray = childs;
        int n = childs.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                String name = file.getName();
                if (name.equals(".project")) {
                    result = true;
                    this.projectDescriptionFile = file;
                } else if (name.equals(".tproject")) {
                    this.platformName = TprojectHandler.getFirstPlatformNameFromFile((File)file);
                }
            }
            ++n2;
        }
        return result;
    }

    public String getPlatformName() {
        if (this.platformName != null) {
            return this.platformName;
        }
        if (!new File(this.path).exists()) {
            return WizardMessages.WebProjectMigrationWizardPage_NotSelected;
        }
        return WizardMessages.WebProjectMigrationWizardPage_NotAvailableProject;
    }
}

