/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.wizard.ui;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.internal.ide.dialogs.IFileStoreFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.sign.util.SignatureUtility;
import org.tizen.common.util.EFSUtil;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.ObjectUtil;
import org.tizen.common.util.PluginUtil;
import org.tizen.web.apptemplate.model.TizenAppTemplateType;
import org.tizen.web.common.IDEPathUtil;
import org.tizen.web.model.TizenModelFactory;
import org.tizen.web.project.wizard.Activator;
import org.tizen.web.project.wizard.WizardMessages;
import org.tizen.web.project.wizard.ui.UserTemplateExportWizardDescriptionPage;
import org.tizen.web.project.wizard.ui.UserTemplateExportWizardIconPage;
import org.tizen.web.project.wizard.ui.UserTemplateExportWizardTemplatePage;

public class UserTemplateExportWizard
extends Wizard
implements IExportWizard {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private IFileStoreFilter fileFilter = new IFileStoreFilter(){

        public boolean accept(IFileStore store) {
            String name = store.getName();
            if (".project".equalsIgnoreCase(name)) {
                return false;
            }
            if (".settings".equalsIgnoreCase(name)) {
                return false;
            }
            String extension = FileUtil.getFileExtension((String)name);
            if ("wgt".equalsIgnoreCase(extension)) {
                return false;
            }
            return !SignatureUtility.isSignatureFile((String)name);
        }
    };
    private UserTemplateExportWizardTemplatePage templatePage;
    private UserTemplateExportWizardIconPage iconPage;
    private UserTemplateExportWizardDescriptionPage descriptionPage;
    private IProject selectedProject;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(WizardMessages.UserTemplateExportWizard_Title);
        this.setNeedsProgressMonitor(true);
        if (selection != null) {
            Object obj = selection.getFirstElement();
            if (obj instanceof IProject) {
                this.selectedProject = (IProject)obj;
            } else if (obj instanceof IResource) {
                this.selectedProject = ((IResource)obj).getProject();
            }
        }
    }

    public void addPages() {
        super.addPages();
        String title = WizardMessages.UserTemplateExportWizard_PageTitle;
        this.templatePage = new UserTemplateExportWizardTemplatePage(WizardMessages.UserTemplateExportWizard_TemplatePageName);
        this.templatePage.setSelectedProject(this.selectedProject);
        this.templatePage.setTitle(title);
        this.templatePage.setDescription(WizardMessages.UserTemplateExportWizard_TemplatePageDescription);
        this.addPage((IWizardPage)this.templatePage);
        this.iconPage = new UserTemplateExportWizardIconPage(WizardMessages.UserTemplateExportWizard_IconPageName);
        this.iconPage.setTitle(title);
        this.iconPage.setDescription(WizardMessages.UserTemplateExportWizard_IconPageDescription);
        this.addPage((IWizardPage)this.iconPage);
        this.descriptionPage = new UserTemplateExportWizardDescriptionPage(WizardMessages.UserTemplateExportWizard_DescriptionPageName, this);
        this.descriptionPage.setTitle(title);
        this.descriptionPage.setDescription(WizardMessages.UserTemplateExportWizard_DescriptionPageDescription);
        this.addPage((IWizardPage)this.descriptionPage);
    }

    public boolean performFinish() {
        String templateDir = this.templatePage.getTemplateNameText();
        final IPath rootPath = new Path(this.templatePage.getExportLocationText()).append(templateDir);
        final IPath userTemplatePath = IDEPathUtil.getUserTemplatePath().append(templateDir);
        IProject selectedProject = this.templatePage.getSelectedProject();
        final IPath projectPath = selectedProject.getLocation();
        final IPath templateProjectPath = rootPath.append("project");
        final String templateName = this.templatePage.getTemplateNameText();
        final boolean isAutoImport = this.templatePage.isAutomaticallyImport();
        final List<UserTemplateExportWizardIconPage.IconWrapper> icons = this.iconPage.getIcons();
        final String previewImage = this.descriptionPage.getPreviewImageText();
        IProjectNature nature = null;
        try {
            nature = selectedProject.getNature("org.tizen.webuibuilder.nature");
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        final String type = nature != null ? "UIBuilder" : "TIZEN";
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    try {
                        monitor = (IProgressMonitor)ObjectUtil.nvl((Object[])new IProgressMonitor[]{monitor, new NullProgressMonitor()});
                        int totalTicks = 100;
                        monitor.beginTask(WizardMessages.UserTemplateExportWizard_FinishTask, totalTicks);
                        monitor.subTask(WizardMessages.UserTemplateExportWizard_Task_CopyToLocation);
                        EFSUtil.DialogChoicer previousChoice = EFSUtil.copyWithFilter((URI)projectPath.toFile().toURI(), (URI)templateProjectPath.toFile().toURI(), (IFileStoreFilter)UserTemplateExportWizard.this.fileFilter, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                        String icon32 = null;
                        String icon64 = null;
                        for (UserTemplateExportWizardIconPage.IconWrapper icon : icons) {
                            switch (icon.getSize()) {
                                case icon32: {
                                    icon32 = icon.getIconPath(true);
                                    break;
                                }
                                case icon64: {
                                    icon64 = icon.getIconPath(true);
                                    break;
                                }
                            }
                        }
                        UserTemplateExportWizard.this.copyImageFile(icon32, rootPath, previousChoice, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                        UserTemplateExportWizard.this.copyImageFile(icon64, rootPath, previousChoice, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                        UserTemplateExportWizard.this.copyImageFile(previewImage, rootPath, previousChoice, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                        monitor.subTask(WizardMessages.UserTemplateExportWizard_Task_CreateInformation);
                        IPath templateXmlPath = rootPath.append("tizen-app-template.xml");
                        TizenModelFactory.marshalAppTemplate((TizenAppTemplateType)UserTemplateExportWizard.this.getModel(type, icon32, icon64, templateName), (File)templateXmlPath.toFile());
                        monitor.worked(10);
                        IPath descriptionXmlPath = rootPath.append("description.xml");
                        UserTemplateExportWizard.this.descriptionPage.generateDescriptionXML(descriptionXmlPath.toFile(), false);
                        monitor.worked(10);
                        IPath xslPath = new Path("descriptionTemplate").append("description.xsl");
                        URL xslURL = PluginUtil.getBuiltInURL((Plugin)Activator.getDefault(), (String)xslPath.toString());
                        if (xslURL == null) {
                            throw new FileNotFoundException("Could not find the XSL file: " + xslPath);
                        }
                        IPath xslDestPath = rootPath.append("description.xsl");
                        EFSUtil.copyWithFilter((URI)xslURL.toURI(), (URI)xslDestPath.toFile().toURI(), null, (EFSUtil.DialogChoicer)previousChoice, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                        monitor.subTask(WizardMessages.UserTemplateExportWizard_Task_ImportTemplate);
                        URI userTemplateURI = userTemplatePath.toFile().toURI();
                        if (isAutoImport) {
                            EFSUtil.copyWithFilter((URI)rootPath.toFile().toURI(), (URI)userTemplateURI, null, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                        } else {
                            monitor.worked(20);
                        }
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        monitor.done();
                    }
                    catch (Exception e) {
                        UserTemplateExportWizard.this.logger.error(e.getMessage(), (Throwable)e);
                        Status status = new Status(4, "org.tizen.web.project.wizard", e.getMessage(), (Throwable)e);
                        ErrorDialog.openError((Shell)UserTemplateExportWizard.this.getShell(), (String)WizardMessages.UserTemplateExportWizard_ErrorDialogTitle, (String)WizardMessages.UserTemplateExportWizard_ErrorDialogMsg, (IStatus)status);
                        throw new CoreException((IStatus)status);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            return true;
        }
        catch (InterruptedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private String getSafeLastSegment(String path) {
        return path != null ? new Path(path).lastSegment() : null;
    }

    private void copyImageFile(String file, IPath destinationRoot, EFSUtil.DialogChoicer previousChoice, IProgressMonitor monitor) throws CoreException {
        if (file == null || destinationRoot == null) {
            return;
        }
        Path filePath = new Path(file);
        if (filePath.lastSegment() == null) {
            return;
        }
        URI destination = destinationRoot.append(filePath.lastSegment()).toFile().toURI();
        EFSUtil.copyWithFilter((URI)filePath.toFile().toURI(), (URI)destination, null, (EFSUtil.DialogChoicer)previousChoice, (IProgressMonitor)monitor);
    }

    protected TizenAppTemplateType getModel(String type, String icon32file, String icon64file, String templateName) {
        TizenAppTemplateType appTemplateType = TizenModelFactory.getAppTemplate();
        appTemplateType.setWidgetType(type);
        appTemplateType.setDescriptionFileName("description.xml");
        appTemplateType.setIcon32(this.getSafeLastSegment(icon32file));
        appTemplateType.setIcon64(this.getSafeLastSegment(icon64file));
        appTemplateType.setSdkVersion("");
        appTemplateType.setTemplateName(templateName);
        appTemplateType.setTemplateVersion("");
        return appTemplateType;
    }

    public IProject getSelectedProject() {
        IProject selectedProject = this.templatePage.getSelectedProject();
        return selectedProject;
    }
}

