/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.wizard.ui;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.Assert;
import org.tizen.common.util.ImageUtil;
import org.tizen.common.util.PluginUtil;
import org.tizen.web.project.wizard.Activator;
import org.tizen.web.project.wizard.WizardMessages;

public class UserTemplateExportWizardIconPage
extends WizardPage {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private List<IconWrapper> icons = new ArrayList<IconWrapper>();

    public UserTemplateExportWizardIconPage(String pageName) {
        super(pageName);
    }

    public UserTemplateExportWizardIconPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        IconSize[] iconSizeArray = IconSize.values();
        int n = iconSizeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IconSize iconSize = iconSizeArray[n2];
            final IconWrapper iconWrapper = new IconWrapper(composite, iconSize);
            Text iconText = iconWrapper.getText();
            iconText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    UserTemplateExportWizardIconPage.this.validatePage();
                }
            });
            Button iconButton = iconWrapper.getButton();
            iconButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    UserTemplateExportWizardIconPage.this.handleBrowseButtonPressed(iconWrapper);
                }
            });
            this.icons.add(iconWrapper);
            ++n2;
        }
        this.setControl((Control)composite);
    }

    protected boolean validatePage() {
        for (IconWrapper icon : this.icons) {
            if (icon.validate()) continue;
            this.setErrorMessage(WizardMessages.bind((String)WizardMessages.UserTemplateExportWizardIconPage_InvalidPathErrorMsg, (Object)icon.getSize().getName()));
            this.setPageComplete(false);
            return false;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
        return true;
    }

    protected void handleBrowseButtonPressed(IconWrapper iconWrapper) {
        String selectedFile;
        FileDialog fileDialog = new FileDialog(this.getShell(), 0x10000000);
        fileDialog.setText(WizardMessages.UserTemplateExportWizardIconPage_FileDialog);
        fileDialog.setFilterExtensions(ImageUtil.supportedImageExtension);
        String locationText = iconWrapper.getText().getText();
        if (locationText != null) {
            File file = new File(locationText.trim());
            fileDialog.setFilterPath(file.getParent());
        }
        if ((selectedFile = fileDialog.open()) != null) {
            iconWrapper.drawImageToButton(selectedFile);
        }
    }

    public List<IconWrapper> getIcons() {
        return this.icons;
    }

    public static enum IconSize {
        icon32(32, "tizen_blank_32.png"),
        icon64(64, "tizen_blank_64.png");

        private int size;
        private String defaultFilename;

        private IconSize(int size, String defaultFilename) {
            this.size = size;
            this.defaultFilename = defaultFilename;
        }

        public int getSize() {
            return this.size;
        }

        public String getDefaultFilename() {
            return this.defaultFilename;
        }

        public String getName() {
            return WizardMessages.bind((String)WizardMessages.UserTemplateExportWizardIconPage_IconSizeName, (Object)this.size);
        }
    }

    public class IconWrapper {
        private IconSize size;
        private Text text;
        private Button button;

        public IconWrapper(Composite parent, IconSize size) {
            Assert.notNull((Object)parent);
            Assert.notNull((Object)((Object)size));
            this.size = size;
            this.createControl(parent);
        }

        private void createControl(Composite parent) {
            Label iconLabel = new Label(parent, 0);
            iconLabel.setText(String.valueOf(this.size.getName()) + " :");
            iconLabel.setLayoutData((Object)new GridData(768));
            this.button = new Button(parent, 8);
            GridData canvasGridData = new GridData(68);
            canvasGridData.verticalSpan = 2;
            canvasGridData.heightHint = this.size.getSize();
            canvasGridData.widthHint = this.size.getSize();
            this.button.setLayoutData((Object)canvasGridData);
            this.text = new Text(parent, 2048);
            GridData doubleColumnGridData = new GridData(768);
            this.text.setLayoutData((Object)doubleColumnGridData);
        }

        public IconSize getSize() {
            return this.size;
        }

        public Text getText() {
            return this.text;
        }

        public Button getButton() {
            return this.button;
        }

        public String getDefaultIconPath() {
            IPath path = new Path("icons").append(this.size.getDefaultFilename());
            URL iconURL = PluginUtil.getFileURLinBundle((Bundle)Activator.getDefault().getBundle(), (String)path.toString());
            if (iconURL == null) {
                return "";
            }
            return iconURL.getPath();
        }

        public String getIconPath(boolean isDefault) {
            String path = this.text.getText().trim();
            if (!path.isEmpty()) {
                return path;
            }
            if (isDefault) {
                return this.getDefaultIconPath();
            }
            return path;
        }

        public boolean validate() {
            File iconFile;
            String iconText = this.getIconPath(false);
            return iconText.isEmpty() || (iconFile = new File(iconText)).exists() && iconFile.canRead() && !iconFile.isDirectory();
        }

        public boolean drawImageToButton(String selectedFile) {
            try {
                Image image = new Image((Device)Display.getDefault(), selectedFile);
                if (image != null) {
                    this.button.setImage(image);
                }
                this.text.setText(selectedFile);
                return true;
            }
            catch (SWTException e) {
                UserTemplateExportWizardIconPage.this.logger.error(e.getMessage(), (Throwable)e);
                return false;
            }
        }
    }
}

