/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.refactoring;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;
import org.tizen.web.zimlaunch.refactoring.Messages;
import org.tizen.web.zimlaunch.refactoring.ProjectDeleteUndoChange;

public class ProjectDeleteChange
extends ResourceChange {
    private ILaunchConfiguration[] configurations;
    private String projectName;

    public ProjectDeleteChange(String projectName, ILaunchConfiguration[] configurations) {
        this.projectName = projectName;
        this.configurations = configurations;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        ArrayList<ILaunchConfigurationWorkingCopy> undoConfigurations = new ArrayList<ILaunchConfigurationWorkingCopy>();
        ILaunchConfiguration[] iLaunchConfigurationArray = this.configurations;
        int n = this.configurations.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration lc = iLaunchConfigurationArray[n2];
            undoConfigurations.add(lc.copy(lc.getName()));
            lc.delete();
            ++n2;
        }
        return new ProjectDeleteUndoChange(this.projectName, undoConfigurations.toArray(new ILaunchConfiguration[0]));
    }

    protected IResource getModifiedResource() {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(this.projectName);
    }

    public String getName() {
        return Messages.REMOVE_LAUNCH_CONFIGURATION;
    }
}

