/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.feature;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.tizen.web.config.schema.model.Feature;
import org.tizen.web.editor.configuration.support.AbstractChangeListener;

public class FeatureEditingSupport
extends EditingSupport {
    private int column;
    private CellEditor editor;
    private AbstractChangeListener listener;

    public FeatureEditingSupport(ColumnViewer viewer, int column) {
        super(viewer);
        this.column = column;
        switch (column) {
            case 0: {
                if (!(viewer instanceof TableViewer)) break;
                this.editor = new TextCellEditor((Composite)((TableViewer)viewer).getTable());
                break;
            }
        }
    }

    protected CellEditor getCellEditor(Object element) {
        return this.editor;
    }

    protected boolean canEdit(Object element) {
        switch (this.column) {
            case 0: {
                return false;
            }
        }
        return false;
    }

    protected Object getValue(Object element) {
        if (!(element instanceof Feature)) {
            return null;
        }
        Feature feature = (Feature)element;
        switch (this.column) {
            case 0: {
                String src = feature.getName();
                if (src != null) {
                    return src;
                }
                return "";
            }
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        if (!(element instanceof Feature)) {
            return;
        }
        Feature feature = (Feature)element;
        switch (this.column) {
            case 0: {
                feature.setName((String)value);
                break;
            }
        }
        this.getViewer().update(element, null);
        if (this.getListener() != null) {
            this.getListener().notifyChange();
        }
    }

    public void setListener(AbstractChangeListener listener) {
        this.listener = listener;
    }

    public void unsetListener() {
        this.listener = null;
    }

    public AbstractChangeListener getListener() {
        return this.listener;
    }
}

