/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.common.core;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.ProjectUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.web.common.WebConstant;

public class WebProjectUtil
extends ProjectUtil {
    public static final Logger logger = LoggerFactory.getLogger(WebProjectUtil.class);

    public static String getPropertyValue(IProject project, QualifiedName key, String defaultValue) throws CoreException {
        String value;
        if (project != null && key != null && (value = project.getPersistentProperty(key)) != null) {
            return value;
        }
        return defaultValue;
    }

    public static boolean getPropertyValue(IProject project, QualifiedName key, boolean defaultValue) throws CoreException {
        String ret = WebProjectUtil.getPropertyValue(project, key, Boolean.toString(defaultValue));
        return Boolean.parseBoolean(ret);
    }

    public static boolean isFileInTheProject(IProject project, String filePath) {
        if (project == null || StringUtil.isEmpty((CharSequence)filePath)) {
            return false;
        }
        try {
            SWTUtil.refreshLocal((IProject)project, (int)1);
            IResource resource = project.findMember(filePath);
            return resource instanceof IFile;
        }
        catch (CoreException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static IFile findDefaultIconFile(IProject project) {
        IFile iconFile = null;
        String[] stringArray = WebConstant.DEFAULT_ICONS;
        int n = WebConstant.DEFAULT_ICONS.length;
        int n2 = 0;
        while (n2 < n) {
            String icon = stringArray[n2];
            iconFile = project.getFile(icon);
            if (iconFile.exists()) break;
            ++n2;
        }
        return iconFile;
    }
}

