/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.preferences;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.OSChecker;
import org.tizen.common.util.StringUtil;
import org.tizen.web.common.WebCommonActivator;

public class ChromePreferenceInitializer
extends AbstractPreferenceInitializer {
    private static Logger logger = LoggerFactory.getLogger(ChromePreferenceInitializer.class);
    private static final String ENV_USERPROFILE = "USERPROFILE";
    private static final String ENV_LOCALAPPDATA = "LOCALAPPDATA";
    private static final String ENV_PROGRAMFILES = "programfiles";
    private static final String ENV_PROGRAMFILES_X86 = "programfiles(x86)";
    private static final String CHROME_LINUX = "/opt/google/chrome/google-chrome";
    private static final String CHROME_LINUX_COMMAND = "which google-chrome";
    private static final String CHROME_WIN = "\\Google\\Chrome\\Application\\chrome.exe";
    private static final String CHROME_MACOS = "/Applications/Google Chrome.app/Contents/MacOS/Google Chrome";
    public static final String[] DEFAULT_CHROME_OPTIONS = new String[]{"--no-first-run", "--activate-on-launch", "--no-default-browser-check", "--allow-file-access-from-files", "--disable-web-security", "--disable-translate", "--proxy-auto-detect", "--proxy-bypass-list=127.0.0.1", "--enable-blink-features=ShadowDOMV0", "--enable-blink-features=CustomElementsV0"};

    public void initializeDefaultPreferences() {
        ChromePreferenceInitializer.setDefaultValue();
    }

    public static void setDefaultValue() {
        boolean creationSuccess;
        IPreferenceStore store = WebCommonActivator.getDefault().getPreferenceStore();
        String chrome = ChromePreferenceInitializer.getDefaultChromeLocation();
        if (!StringUtil.isEmpty((CharSequence)chrome)) {
            store.setDefault("CHROME_EXECUTABLE", chrome);
        } else {
            store.setDefault("CHROME_EXECUTABLE", "");
        }
        StringBuffer extraParams = new StringBuffer();
        String[] stringArray = DEFAULT_CHROME_OPTIONS;
        int n = DEFAULT_CHROME_OPTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            extraParams.append(param);
            extraParams.append(" ");
            ++n2;
        }
        store.setDefault("EXTRA_PARAM", extraParams.toString());
        String sdkDataPath = InstallPathConfig.getUserDataPath();
        String chromeUserDataLocation = String.valueOf(sdkDataPath) + File.separator + "chrome-user-data";
        boolean chromeUserDataLocationExists = new File(chromeUserDataLocation).exists();
        if (!chromeUserDataLocationExists && !(creationSuccess = new File(chromeUserDataLocation).mkdir())) {
            logger.info("Creation of Chrome User Data Folder:" + chromeUserDataLocation + " failed");
            return;
        }
        store.setDefault("PROFILE_PATH", chromeUserDataLocation);
    }

    public static String getDefaultChromeLocation() {
        String chromeDir;
        String chrome = null;
        if (OSChecker.isMAC()) {
            chrome = CHROME_MACOS;
        } else if (OSChecker.isWindows()) {
            chromeDir = OSChecker.isWindows7() ? System.getenv(ENV_LOCALAPPDATA) : String.valueOf(System.getenv(ENV_USERPROFILE)) + File.separator + "Local Settings" + File.separator + "Application Data";
            chrome = String.valueOf(chromeDir) + CHROME_WIN;
        } else if (OSChecker.isLinux()) {
            chrome = CHROME_LINUX;
        } else {
            return null;
        }
        if (ChromePreferenceInitializer.checkFileExist(chrome)) {
            return chrome;
        }
        if (OSChecker.isMAC()) {
            logger.info("Currently macos's default path is only first location");
        } else if (OSChecker.isWindows()) {
            chromeDir = System.getenv(ENV_PROGRAMFILES);
            chrome = String.valueOf(chromeDir) + CHROME_WIN;
        } else if (OSChecker.isLinux()) {
            chrome = ChromePreferenceInitializer.getChromeInLinux();
        }
        if (ChromePreferenceInitializer.checkFileExist(chrome)) {
            return chrome;
        }
        if (OSChecker.isWindows7() && OSChecker.is64bit()) {
            chromeDir = System.getenv(ENV_PROGRAMFILES_X86);
            chrome = String.valueOf(chromeDir) + CHROME_WIN;
        }
        if (!ChromePreferenceInitializer.checkFileExist(chrome)) {
            return null;
        }
        return chrome;
    }

    public static String getChromeInLinux() {
        String line;
        block5: {
            line = null;
            Runtime rt = Runtime.getRuntime();
            BufferedReader br = null;
            try {
                try {
                    Process proc = rt.exec(CHROME_LINUX_COMMAND);
                    InputStream stdin = proc.getInputStream();
                    InputStreamReader isr = new InputStreamReader(stdin);
                    br = new BufferedReader(isr);
                    line = br.readLine();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    IOUtil.tryClose((Object[])new Object[]{br});
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{br});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{br});
        }
        return line;
    }

    public static boolean checkFileExist(String absolutePath) {
        if (absolutePath == null) {
            return false;
        }
        absolutePath = absolutePath.trim();
        if (absolutePath.length() != 0) {
            File file = new File(absolutePath);
            return file.isFile() && file.exists() && file.isAbsolute();
        }
        return false;
    }
}

