/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.cli.command;

import java.text.MessageFormat;
import org.tizen.common.core.command.ExecutionContext;
import org.tizen.common.core.command.Executor;
import org.tizen.common.util.Assert;
import org.tizen.web.zimlaunch.cli.command.WRTCommand;
import org.tizen.web.zimlaunch.cli.command.WgtInfoCommand;

public class RunCommand
extends WRTCommand {
    protected static final String WRT_LAUNCHER_RUN_COMMAND = "/usr/bin/wrt-launcher --start";
    protected static final String WRT_LAUNCHER_RUN_COMMNAD_TIME = "--timeout=";
    protected String widgetID;

    public String getWidgetID() {
        return this.widgetID;
    }

    public RunCommand(String wigetID) {
        this.widgetID = wigetID;
    }

    protected String getPackageName(Executor executor, ExecutionContext context) throws Exception {
        WgtInfoCommand getNameCommand = new WgtInfoCommand(this.getWidgetID());
        getNameCommand.setDevice(this.getDevice());
        getNameCommand.setPrintOption(this.isPrintOption());
        getNameCommand.run(executor, context);
        return getNameCommand.getPackageName();
    }

    @Override
    protected boolean checkCommandReturnCode() {
        if (!this.getResult().contains("result: launched")) {
            return false;
        }
        return super.checkCommandReturnCode();
    }

    @Override
    public void run(Executor executor, ExecutionContext context) throws Exception {
        String name = this.getWidgetID();
        Assert.notNull((Object)name);
        this.setCommand("/usr/bin/wrt-launcher --start " + name + " " + WRT_LAUNCHER_RUN_COMMNAD_TIME + this.getTime());
        super.run(executor, context);
        String msg = this.checkCommandReturnCode() ? MessageFormat.format("''{0}'' launch successful.", this.getWidgetID()) : MessageFormat.format("''{0}'' launch failed.", this.getWidgetID());
        if (this.isPrintOption()) {
            context.getPrompter().notify(msg);
        }
        this.clearResult();
        this.setResult(msg);
    }

    @Override
    public void undo(Executor executor, ExecutionContext context) throws Exception {
        super.undo(executor, context);
    }
}

