/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.command;

import org.tizen.common.core.application.Version;
import org.tizen.common.sdb.command.ApplicationCommand;
import org.tizen.common.sdb.command.LaunchCommand;
import org.tizen.common.sdb.command.SdbCommandHelper;
import org.tizen.common.sdb.command.receiver.CommandOutputReceiver;
import org.tizen.common.sdb.command.receiver.PkgCmdReceiver;
import org.tizen.common.ui.view.console.ITizenConsoleManager;
import org.tizen.common.util.PlatformInformationUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.service.ApplicationCmdService;
import org.tizen.web.zimlaunch.notification.TizenWebConsole;
import org.tizen.web.zimlaunch.resource.ZimLaunchResource;
import org.tizen.web.zimlaunch.util.LaunchUtil;

public class WebDebugLaunchCommand
extends LaunchCommand {
    protected ZimLaunchResource resource;
    protected String appId;
    protected String DEBUG_LAUNCH_COMMAND = "/usr/bin/wrt-launcher --debug --timeout=%d --start %s";
    private int port = 0;

    public WebDebugLaunchCommand(IDevice device, String appId, String args, ZimLaunchResource resource, boolean useWidgetViewerSdk) {
        super(device, appId, args, useWidgetViewerSdk, (ITizenConsoleManager)TizenWebConsole.getInstance());
        this.appId = appId;
        this.resource = resource;
    }

    public void execute() throws Exception {
        if (ApplicationCommand.isAppCmdSupported((IDevice)this.getDevice())) {
            ApplicationCmdService appcmd = this.getApplicationCmdService();
            this.port = appcmd.debugWebApplication(this.appId);
        } else {
            String cmd = this.getDebugLaunchCommand();
            this.helper = new SdbCommandHelper(this.device, this.getConsole(), (CommandOutputReceiver)new PkgCmdReceiver(this.getConsole()));
            this.helper.runCommand(cmd);
        }
    }

    public String getPort() {
        return "port: " + String.valueOf(this.port);
    }

    protected String getDebugLaunchCommand() throws Exception {
        String cmd = String.format(this.DEBUG_LAUNCH_COMMAND, this.resource.getDeviceinfo().getTimeout(), this.appId);
        Version version = new Version(PlatformInformationUtil.getPlatformVersion((IDevice)this.device));
        if (version.isSameOrBiggerThanVersion3()) {
            cmd = cmd.replaceFirst("wrt-", "app_");
            cmd = cmd.replaceFirst("-debug", "w");
            cmd = cmd.replaceFirst(" --timeout=" + this.resource.getDeviceinfo().getTimeout(), "");
            if (LaunchUtil.isWatch(this.resource.getAppinfo().getProject())) {
                cmd = cmd.replaceFirst("--start", "--start org.tizen.widget_viewer_sdk widget_id");
            }
        }
        return cmd;
    }
}

