/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.exception;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.tizen.common.util.StringUtil;
import org.tizen.web.zimlaunch.Activator;
import org.tizen.web.zimlaunch.exception.TizenWebIDEExceptionCode;
import org.tizen.web.zimlaunch.notification.TizenWebNotifier;

public class TizenWebIDEException
extends Exception {
    private static final long serialVersionUID = -2718256272172535526L;
    private static final String DEFAULT_MESSAGE = "An exception occurred";

    public TizenWebIDEException() {
    }

    public TizenWebIDEException(String message) {
        super(StringUtil.trim((String)message));
    }

    public TizenWebIDEException(String message, int code) {
        super(String.valueOf(StringUtil.trim((String)message)) + "\n" + TizenWebIDEExceptionCode.getDescriptionforCode(code));
    }

    public TizenWebIDEException(String message, TizenWebIDEExceptionCode code) {
        super(String.valueOf(StringUtil.trim((String)message)) + "\n" + code.getDescription());
    }

    public static void abort(String message, Throwable exception, TizenWebNotifier ... notifiers) throws CoreException {
        Status status = new Status(4, Activator.getUniqueIdentifier(), message, exception);
        if (notifiers != null && notifiers.length > 0) {
            TizenWebNotifier[] tizenWebNotifierArray = notifiers;
            int n = notifiers.length;
            int n2 = 0;
            while (n2 < n) {
                TizenWebNotifier notifier = tizenWebNotifierArray[n2];
                if (StringUtil.isEmpty((CharSequence)message)) {
                    message = DEFAULT_MESSAGE;
                } else {
                    message = "An exception occurred\n(" + message + ")";
                    notifier.notifyContents(message, 0);
                }
                notifier.notifyEnd(DEFAULT_MESSAGE, null);
                ++n2;
            }
        }
        throw new CoreException((IStatus)status);
    }

    public static void abortAndStack(String message, Throwable exception, TizenWebNotifier ... notifiers) throws CoreException {
        StringBuilder sb = new StringBuilder();
        if (exception != null) {
            sb.append(exception.getMessage()).append("\nCall Stack");
            StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement e = stackTraceElementArray[n2];
                sb.append("\n").append(e.toString());
                ++n2;
            }
        }
        String stack = sb.toString();
        Status status = new Status(4, Activator.getUniqueIdentifier(), message, (Throwable)new TizenWebIDEException(stack));
        if (notifiers != null && notifiers.length > 0) {
            TizenWebNotifier[] tizenWebNotifierArray = notifiers;
            int n = notifiers.length;
            int n3 = 0;
            while (n3 < n) {
                TizenWebNotifier notifier = tizenWebNotifierArray[n3];
                message = !StringUtil.isEmpty((CharSequence)message) ? DEFAULT_MESSAGE : "An exception occurred\n(" + message + ")" + "\n" + stack;
                notifier.notifyContents(message, 0);
                notifier.notifyEnd(DEFAULT_MESSAGE, null);
                ++n3;
            }
        }
        throw new CoreException((IStatus)status);
    }
}

