/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.step;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.IApplicationConfiguration;
import org.tizen.common.ITizenProject;
import org.tizen.common.app.EclipseApplication;
import org.tizen.common.launch.context.ILaunchContext;
import org.tizen.common.util.ArrayUtil;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.PreferenceLinkMessageDialog;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.app.IApplication;
import org.tizen.sdblib.app.IApplicationListener;
import org.tizen.sdblib.app.IApplicationType;
import org.tizen.web.common.WebCommonActivator;
import org.tizen.web.common.app.WebApplication;
import org.tizen.web.common.util.ProjectUtil;
import org.tizen.web.zimlaunch.command.WebDebugLaunchCommand;
import org.tizen.web.zimlaunch.debug.core.HybridAppDebugListener;
import org.tizen.web.zimlaunch.resource.TizenWebAppInfo;
import org.tizen.web.zimlaunch.resource.ZimLaunchResource;
import org.tizen.web.zimlaunch.step.DebugInspectorOpenStep;
import org.tizen.web.zimlaunch.step.DebugPortSettingStep;
import org.tizen.web.zimlaunch.step.DebugURLSettingStep;
import org.tizen.web.zimlaunch.step.LaunchStep;
import org.tizen.web.zimlaunch.step.Messages;
import org.tizen.web.zimlaunch.util.LaunchUtil;

public class DebugStep
extends LaunchStep {
    protected static final Logger logger = LoggerFactory.getLogger(DebugStep.class);
    public static final String name = Messages.STEP_DEBUG_RUN;
    private String result;

    public DebugStep(DebugPortSettingStep portStep, DebugURLSettingStep urlStep, DebugInspectorOpenStep inspectorStep) {
        super(portStep, urlStep, inspectorStep);
    }

    @Override
    protected void preExecuteStep(ILaunchContext ctx) throws Exception {
        super.preExecuteStep(ctx);
        String chromePath = WebCommonActivator.getChromeExceutePath();
        if (StringUtil.isEmpty((CharSequence)chromePath) || !FileUtil.isExist((String)chromePath)) {
            SWTUtil.syncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    PreferenceLinkMessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error", (String)NLS.bind((String)Messages.STEP_DEBUG_INSPECTOR_OPEN_FAILED, (Object)WebCommonActivator.getChromeExceutePath()), (String)"here", (String)"org.tizen.web.preferences.ChromePreferencePage");
                }
            });
            chromePath = WebCommonActivator.getChromeExceutePath();
            if (StringUtil.isEmpty((CharSequence)chromePath)) {
                this.notifier.getMonitor().setCanceled(true);
                this.handleCancelEvent(this.notifier, this.notifier.getMonitor());
            }
        }
        ZimLaunchResource resource = (ZimLaunchResource)ctx.getValue((Object)"resource");
        this.addInterestingAppForHybrid(resource);
    }

    private void addInterestingAppForHybrid(ZimLaunchResource resource) throws CoreException {
        if (resource != null) {
            IProject webProject;
            ITizenProject tizenWebProject;
            IDevice device = resource.getDeviceinfo().getDevice();
            HybridAppDebugListener listener = new HybridAppDebugListener();
            Object[] serviceApps = this.generateServiceApps(device, resource.getAppinfo(), listener);
            if (!ArrayUtil.isEmpty((Object[])serviceApps) && serviceApps.length == 1 && (tizenWebProject = ProjectUtil.getTizenProject((IProject)(webProject = resource.getAppinfo().getProject()))) != null) {
                WebApplication hybridApp = new WebApplication(device, webProject.getName(), resource.getAppinfo().getAppPackageID(), resource.getAppinfo().getAppID(), (IApplicationType)tizenWebProject.getTizenProjectType(), (IApplication[])serviceApps);
                hybridApp.addListener((IApplicationListener)listener);
                SmartDevelopmentBridge.addInterestingApplication((IApplication)hybridApp);
            }
        }
    }

    private IApplication[] generateServiceApps(IDevice device, TizenWebAppInfo webAppInfo, IApplicationListener listener) throws CoreException {
        IProject[] serviceProjects;
        ArrayList<EclipseApplication> serviceApps = new ArrayList<EclipseApplication>();
        IProject[] iProjectArray = serviceProjects = ProjectUtil.getReferencedNativeProjects((IProject)webAppInfo.getProject());
        int n = serviceProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject serviceProject = iProjectArray[n2];
            ITizenProject tizenProject = ProjectUtil.getTizenProject((IProject)serviceProject);
            if (tizenProject != null) {
                IApplicationConfiguration appConfig = (IApplicationConfiguration)serviceProject.getAdapter(IApplicationConfiguration.class);
                EclipseApplication serviceApp = new EclipseApplication(serviceProject, device, FilenameUtil.getName((String)appConfig.getBinaryName()), webAppInfo.getAppPackageID(), webAppInfo.getAppID(), (IApplicationType)tizenProject.getTizenProjectType());
                serviceApp.addListener(listener);
                serviceApps.add(serviceApp);
            }
            ++n2;
        }
        if (serviceApps.size() == 0) {
            return null;
        }
        return serviceApps.toArray(new IApplication[0]);
    }

    @Override
    protected void postRun() {
        super.postRun();
        int remotePort = this.launcher.getRemotePort(this.result);
        this.resource.getDeviceinfo().setRemotePort(remotePort);
        String inspectorPath = this.launcher.getInspectorPath(this.result);
        this.resource.getDeviceinfo().setInspectorPath(inspectorPath);
    }

    @Override
    protected void executeLaunchCommand() throws Exception {
        String appId = this.resource.getAppinfo().getAppID();
        boolean useWidgetViewerSdk = false;
        if (LaunchUtil.isWatch(this.resource.getAppinfo().getProject())) {
            useWidgetViewerSdk = true;
        }
        WebDebugLaunchCommand command = new WebDebugLaunchCommand(this.device, appId, "", this.resource, useWidgetViewerSdk);
        command.execute();
        this.result = command.getCommandOutput();
        if (this.result == null || this.result.isEmpty()) {
            this.result = String.valueOf(command.getPort());
        }
    }
}

