/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.model.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    static final Logger logger = LoggerFactory.getLogger(FileUtil.class);
    static final String TEMPLATE_XML = "tizen-app-template.xml";

    public static List<File> getFileList(File rootPath) throws FileNotFoundException {
        FileUtil.validateDirectory(rootPath);
        List<File> result = FileUtil.getFileListing(rootPath);
        if (result != null) {
            Collections.sort(result);
        }
        return result;
    }

    private static List<File> getFileListing(File rootPath) throws FileNotFoundException {
        ArrayList<File> result = new ArrayList<File>();
        File[] filesAndDirs = rootPath.listFiles();
        if (null == filesAndDirs) {
            return result;
        }
        for (File file : filesAndDirs) {
            String name = file.getName();
            if (TEMPLATE_XML.equalsIgnoreCase(name) && file.isFile()) {
                result.add(file);
                continue;
            }
            List<File> deeperList = FileUtil.getFileListing(file);
            if (null == deeperList) {
                logger.debug("NULL!!!! {}", (Object)name);
                continue;
            }
            result.addAll(deeperList);
        }
        return result;
    }

    private static void validateDirectory(File aDirectory) throws FileNotFoundException {
        if (aDirectory == null) {
            throw new IllegalArgumentException("Directory should not be null.");
        }
        if (!aDirectory.exists()) {
            throw new FileNotFoundException("Directory does not exist: " + aDirectory);
        }
        if (!aDirectory.isDirectory()) {
            throw new IllegalArgumentException("Is not a directory: " + aDirectory);
        }
        if (!aDirectory.canRead()) {
            throw new IllegalArgumentException("Directory cannot be read: " + aDirectory);
        }
    }
}

