/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.widl;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.tree.AbstractNode;
import org.tizen.common.TizenHelpContextIds;
import org.tizen.common.util.StringUtil;
import org.tizen.web.editor.widl.JavaScriptWriter;
import org.tizen.web.editor.widl.model.Argument;
import org.tizen.web.editor.widl.model.Attribute;
import org.tizen.web.editor.widl.model.Constant;
import org.tizen.web.editor.widl.model.Interface;
import org.tizen.web.editor.widl.model.Method;
import org.tizen.web.editor.widl.model.Module;
import org.tizen.web.editor.widl.model.Typedef;

public class IDLReader {
    private static IDLReader instance;

    private IDLReader() {
    }

    public static synchronized IDLReader getInstance() {
        if (instance == null) {
            instance = new IDLReader();
        }
        return instance;
    }

    public Collection<Module> processDocument(Document doc) {
        LinkedList<Module> modules = new LinkedList<Module>();
        Element root = doc.getRootElement();
        List moduleElements = root.elements("Module");
        for (Element element : moduleElements) {
            this.readModule(element, modules);
        }
        return modules;
    }

    private void readModule(Element moduleElement, Collection<Module> modules) {
        String moduleName = moduleElement.attributeValue("name");
        Module module = new Module(moduleName);
        Iterator i = moduleElement.elementIterator("descriptive");
        while (i.hasNext()) {
            Element descriptiveElement = (Element)i.next();
            this.readModuleDescriptive(module, descriptiveElement);
        }
        this.readModuleDefinition(module, moduleElement);
        modules.add(module);
    }

    private void readModuleDescriptive(Module module, Element descriptiveElement) {
        Element defAPIFeatureSetElement;
        Element brief = descriptiveElement.element("brief");
        if (brief != null) {
            module.setDescription(brief.getText());
        }
        if ((defAPIFeatureSetElement = descriptiveElement.element("def-api-feature-set")) != null) {
            String featureName = defAPIFeatureSetElement.attributeValue("identifier");
            module.setFeatureName(featureName);
            Element subelement = defAPIFeatureSetElement.element("descriptive");
            if (subelement == null) {
                return;
            }
            List subfeatureElements = subelement.elements("api-feature");
            for (Object object : subfeatureElements) {
                if (!(object instanceof Element)) continue;
                Element defAPISubFeature = (Element)object;
                String subfeatureName = defAPISubFeature.attributeValue("identifier");
                module.addSubfeatureName(subfeatureName);
            }
        } else {
            List defAPIFeatureElement = descriptiveElement.elements("def-api-feature");
            String comparingFeature = "";
            for (Object object : defAPIFeatureElement) {
                if (!(object instanceof Element)) continue;
                Element DefAPIFeature = (Element)object;
                String featureName = DefAPIFeature.attributeValue("identifier");
                if (comparingFeature.length() == 0 || comparingFeature.contains(featureName)) {
                    comparingFeature = featureName;
                    if (module.getFeatureName() != null) {
                        module.addSubfeatureName(module.getFeatureName());
                    }
                    module.setFeatureName(featureName);
                    continue;
                }
                module.addSubfeatureName(featureName);
            }
        }
    }

    private void readModuleDefinition(Module module, Element defElement) {
        Iterator i = defElement.elementIterator();
        while (i.hasNext()) {
            Element el = (Element)i.next();
            if (el.getName().compareTo("Typedef") == 0) {
                this.readTypedef(module, el);
            }
            if ("Interface".equals(el.getName())) {
                this.readInterface(module, el);
            }
            if (!"Implements".equals(el.getName())) continue;
            this.readImplementsDeclaration(module, el);
        }
    }

    private void readInterface(Module module, Element interfaceElement) {
        Element nameElement;
        Element inheritanceElement;
        Element extendedAttributeListElement;
        Element apiFeatureElement;
        Element innerDescriptiveElement;
        Element defInstantiatedElement;
        Element descriptiveElement = interfaceElement.element("descriptive");
        if (descriptiveElement != null && module.getFeatureName() == null && (defInstantiatedElement = descriptiveElement.element("def-instantiated")) != null && (innerDescriptiveElement = defInstantiatedElement.element("descriptive")) != null && (apiFeatureElement = innerDescriptiveElement.element("api-feature")) != null) {
            String featureName = apiFeatureElement.attributeValue("identifier");
            module.setFeatureName(featureName);
        }
        String iName = interfaceElement.attributeValue("name");
        Interface interfaze = new Interface(module, iName);
        module.addInterface(interfaze);
        this.readInterfaceMember(interfaze, interfaceElement);
        if (descriptiveElement != null) {
            Element brief = descriptiveElement.element("brief");
            Element description = descriptiveElement.element("description");
            interfaze.setDescription(this.getDescription(brief, description));
        }
        if ((extendedAttributeListElement = interfaceElement.element("ExtendedAttributeList")) != null) {
            List elements = extendedAttributeListElement.elements("ExtendedAttribute");
            for (Object object : elements) {
                Element extendedAttributeElement;
                String nameAttribute;
                if (!(object instanceof Element) || !"Supplemental".equals(nameAttribute = (extendedAttributeElement = (Element)object).attributeValue("name"))) continue;
                interfaze.setSupplemental(true);
            }
        }
        if ((inheritanceElement = interfaceElement.element("InterfaceInheritance")) != null && (nameElement = inheritanceElement.element("Name")) != null) {
            org.dom4j.Attribute nameAttribute = nameElement.attribute("name");
            interfaze.setParentInterface(nameAttribute.getText());
        }
    }

    private void readInterfaceMember(Interface interfaze, Element mElement) {
        Iterator i = mElement.elementIterator();
        while (i.hasNext()) {
            Element el = (Element)i.next();
            if (el.getName().compareTo("Const") == 0) {
                this.readConst(interfaze, el);
            }
            if (el.getName().compareTo("Attribute") == 0) {
                this.readAttribute(interfaze, el);
            }
            if (el.getName().compareTo("Operation") != 0) continue;
            this.readOperation(interfaze, el);
        }
    }

    private void readAttribute(Interface interfaze, Element aElement) {
        String aName = aElement.attributeValue("name");
        Element typeElement = aElement.element("Type");
        String declarationType = "";
        if (typeElement != null) {
            declarationType = typeElement.attributeValue("type");
            if (StringUtil.isEmpty((CharSequence)(declarationType = this.getDeclarationType(declarationType)))) {
                declarationType = typeElement.attributeValue("name");
            }
        }
        Attribute attr = new Attribute(interfaze, aName, declarationType);
        Element descriptiveElement = aElement.element("descriptive");
        if (descriptiveElement == null) {
            descriptiveElement = aElement.getParent().getParent().element("descriptive");
        }
        if (descriptiveElement != null) {
            Element def_api_feature;
            Element description;
            String desc = "";
            Element brief = descriptiveElement.element("brief");
            if (brief != null) {
                desc = brief.getTextTrim();
            }
            if ((description = descriptiveElement.element("description")) != null) {
                for (Object o : description.elements()) {
                    desc = String.valueOf(desc) + JavaScriptWriter.separator;
                    Element el = (Element)o;
                    if ("p".equals(el.getName())) {
                        desc = String.valueOf(desc) + " * " + el.asXML();
                        desc = desc.replaceAll("../../", TizenHelpContextIds.HELP_CONTENT_BASE_URL);
                        continue;
                    }
                    if (!"ul".equals(el.getName())) continue;
                    desc = String.valueOf(desc) + " * <ul>" + JavaScriptWriter.separator;
                    for (Object li : el.elements("li")) {
                        desc = String.valueOf(desc) + " * <li>" + ((Element)li).getTextTrim() + JavaScriptWriter.separator;
                    }
                    desc = String.valueOf(desc) + " * </ul>";
                }
            }
            if ((def_api_feature = descriptiveElement.element("def-api-feature")) != null) {
                attr.setFeature(def_api_feature.attribute("identifier").getText());
            }
            attr.setDescription(desc);
        }
        interfaze.addAttribute(attr);
    }

    private String getDeclarationType(String typeName) {
        if (typeName == null) {
            return "";
        }
        if (typeName.compareTo("DOMString") == 0) {
            typeName = "String";
        } else if (typeName.compareTo("Map") == 0) {
            typeName = "Object";
        } else if (typeName.compareTo("boolean") == 0) {
            typeName = "Boolean";
        } else if (typeName.contains(" long") || typeName.compareTo("long") == 0) {
            typeName = "Number";
        } else if (typeName.contains(" int") || typeName.compareTo("int") == 0) {
            typeName = "Number";
        } else if (typeName.contains(" short") || typeName.compareTo("short") == 0) {
            typeName = "Number";
        } else if (typeName.compareTo("float") == 0) {
            typeName = "Number";
        } else if (typeName.compareTo("double") == 0) {
            typeName = "Number";
        }
        return typeName;
    }

    private void readConst(Interface interfaze, Element aElement) {
        Element brief;
        String aName = aElement.attributeValue("name");
        Element declType = aElement.element("Type");
        String declarationType = declType.attributeValue("type");
        declarationType = this.getDeclarationType(declarationType);
        Constant constant = new Constant(interfaze, aName, declarationType);
        Element descriptiveElement = aElement.element("descriptive");
        if (descriptiveElement != null && (brief = descriptiveElement.element("brief")) != null) {
            constant.setDescription(brief.getTextTrim());
        }
        interfaze.addConstant(constant);
    }

    private String getDescription(Element brief, Element description) {
        String dscr = "";
        if (brief != null) {
            dscr = brief.getTextTrim();
        }
        if (description != null) {
            List elements = description.content();
            for (Object o : elements) {
                AbstractNode an = (AbstractNode)o;
                dscr = String.valueOf(dscr) + an.asXML();
                dscr = dscr.replaceAll("../../", TizenHelpContextIds.HELP_CONTENT_BASE_URL);
            }
        }
        return dscr;
    }

    private void readOperation(Interface interfaze, Element element) {
        String name = element.attributeValue("name");
        if (name == null) {
            return;
        }
        Element returnTypeElement = element.element("Type");
        Element argList = element.element("ArgumentList");
        Method method = new Method(interfaze, name);
        Element descriptiveElement = element.element("descriptive");
        if (descriptiveElement != null) {
            Element brief = descriptiveElement.element("brief");
            Element description = descriptiveElement.element("description");
            method.setDescription(this.getDescription(brief, description));
        }
        interfaze.addMethod(method);
        if (returnTypeElement != null) {
            String returnType = returnTypeElement.attributeValue("name");
            if (returnType == null || returnType.length() == 0) {
                returnType = returnTypeElement.attributeValue("type");
                returnType = this.getDeclarationType(returnType);
            }
            method.setReturnType(returnType);
        }
        if (argList != null) {
            Iterator it = argList.elementIterator("Argument");
            while (it.hasNext()) {
                Element argElement = (Element)it.next();
                String argName = argElement.attributeValue("name");
                Element declTypeElement = argElement.element("Type");
                if (declTypeElement == null) continue;
                String attributeValue = declTypeElement.attributeValue("type");
                if (attributeValue == null || attributeValue.length() == 0) {
                    attributeValue = declTypeElement.attributeValue("name");
                }
                attributeValue = this.getDeclarationType(attributeValue);
                Argument argument = new Argument(method, argName, attributeValue);
                method.addArgument(argument);
            }
        }
    }

    private void readTypedef(Module module, Element typedefElement) {
        Element typeElement = typedefElement.element("Type");
        String declType = "";
        boolean declIsArray = false;
        String restType = "";
        if (typeElement != null) {
            Element typeElement2 = typeElement.element("Type");
            if (typeElement2 != null) {
                declIsArray = true;
                typeElement = typeElement2;
            }
            declType = typeElement.attributeValue("name");
            declType = this.getDeclarationType(declType);
        }
        if (module.getTypedef(restType = typedefElement.attributeValue("name")) == null) {
            Typedef typedef = new Typedef(declType, declIsArray, restType);
            module.addTypedef(typedef);
        }
    }

    private void readImplementsDeclaration(Module module, Element el) {
        String target = el.attributeValue("name1");
        String source = el.attributeValue("name2");
        if (target != null && source != null) {
            module.addImplementationDeclaration(target, source);
        }
    }
}

