/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.feature.support;

import java.text.MessageFormat;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.tizen.common.ui.dialog.PopupDialog;
import org.tizen.common.util.DialogUtil;
import org.tizen.web.config.schema.model.Feature;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.editor.configuration.Messages;
import org.tizen.web.editor.configuration.feature.support.AddFeatureLabelProvider;
import org.tizen.web.editor.configuration.feature.support.FeatureFilter;
import org.tizen.web.editor.widl.model.FeatureWrapper;

public class AddFeatureDialog
extends PopupDialog {
    static final String FEATURE_SCREEN_SIZE_ALL = "http://tizen.org/feature/screen.size.all";
    static final String FEATURE_SCREEN_SIZE_NORMAL = "http://tizen.org/feature/screen.size.normal";
    private ITizenConfigurator configurator;
    private Label selectCountLabel;
    private CheckboxTableViewer featureTableViewer;
    private Text descText;
    private FeatureFilter featureFilter;

    public AddFeatureDialog(Shell parentShell, String title, ITizenConfigurator configurator) {
        super(parentShell, title);
        this.configurator = configurator;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x400);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setInput();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createFilterText(composite);
        this.createFeatureTable(composite);
        this.createDescText(composite);
        return composite;
    }

    private void createFilterText(Composite composite) {
        Text filterText = new Text(composite, 2176);
        filterText.setMessage(Messages.SEARCH_TEXT_MESSAGE);
        GridData data = new GridData(768);
        data.widthHint = 510;
        filterText.setLayoutData((Object)data);
        filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Text filter = (Text)event.widget;
                AddFeatureDialog.this.featureFilter.setSearchText(filter.getText());
                AddFeatureDialog.this.featureTableViewer.refresh();
                AddFeatureDialog.this.updateSelectCountLabel();
            }
        });
        this.selectCountLabel = new Label(composite, 0);
        GridData layoutData = new GridData(128);
        this.selectCountLabel.setText(MessageFormat.format(Messages.AddPrivilegeDialog_PrivilegeSelectionCount, 0));
        this.selectCountLabel.setLayoutData((Object)layoutData);
    }

    private void createFeatureTable(Composite parent) {
        Composite tableComp = new Composite(parent, 0);
        GridData data = new GridData(1808);
        data.heightHint = 200;
        tableComp.setLayoutData((Object)data);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComp.setLayout((Layout)tableLayout);
        Table table = new Table(tableComp, 2848);
        this.featureTableViewer = new CheckboxTableViewer(table);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.featureTableViewer);
        table.setHeaderVisible(false);
        table.setLinesVisible(true);
        TableViewerColumn column = new TableViewerColumn((TableViewer)this.featureTableViewer, 0);
        tableLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        this.featureTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.featureTableViewer.setLabelProvider((IBaseLabelProvider)new AddFeatureLabelProvider());
        this.featureFilter = new FeatureFilter();
        this.featureTableViewer.addFilter((ViewerFilter)this.featureFilter);
        this.featureTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                AddFeatureDialog.this.updateSelectCountLabel();
            }
        });
        this.featureTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)AddFeatureDialog.this.featureTableViewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                FeatureWrapper feature = (FeatureWrapper)selection.getFirstElement();
                String desc = feature.getFeatureDesc();
                if (desc == null) {
                    AddFeatureDialog.this.descText.setText("");
                } else {
                    AddFeatureDialog.this.descText.setText(desc);
                }
            }
        });
    }

    private void createDescText(Composite parent) {
        Composite base = new Composite(parent, 0);
        GridLayout grid = new GridLayout(1, false);
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        grid.horizontalSpacing = 0;
        grid.marginTop = 10;
        grid.verticalSpacing = 7;
        base.setLayout((Layout)grid);
        base.setLayoutData((Object)new GridData(768));
        Label desc = new Label(base, 0);
        GridData layoutData = new GridData(1);
        desc.setText(Messages.DESCRIPTION_LABEL);
        desc.setLayoutData((Object)layoutData);
        this.descText = new Text(base, 2634);
        layoutData = new GridData(768);
        layoutData.heightHint = 55;
        this.descText.setLayoutData((Object)layoutData);
    }

    private void updateSelectCountLabel() {
        int selectionCnt = this.featureTableViewer.getCheckedElements().length;
        this.selectCountLabel.setText(MessageFormat.format(Messages.AddPrivilegeDialog_PrivilegeSelectionCount, selectionCnt));
        this.selectCountLabel.pack();
        this.selectCountLabel.getParent().layout();
    }

    private void setInput() {
        TreeSet<FeatureWrapper> availableFeatureNames = new TreeSet<FeatureWrapper>();
        for (FeatureWrapper featureWrapper : this.configurator.getKnownFeatures()) {
            availableFeatureNames.add(featureWrapper);
        }
        for (Feature feature : this.configurator.getFeatures()) {
            availableFeatureNames.remove(new FeatureWrapper(feature.getName()));
        }
        this.featureTableViewer.setInput(availableFeatureNames);
    }

    protected void okPressed() {
        Object feature;
        Object[] objs = this.featureTableViewer.getCheckedElements();
        String errorMsg = "";
        Object[] objectArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            feature = objectArray[n2];
            if (feature instanceof FeatureWrapper) {
                String featureName = ((FeatureWrapper)feature).getName();
                if (featureName.equals(FEATURE_SCREEN_SIZE_ALL)) {
                    errorMsg = Messages.AddFeatureWizard_WarningAllScreenSize;
                } else if (featureName.equals(FEATURE_SCREEN_SIZE_NORMAL)) {
                    errorMsg = Messages.AddFeatureWizard_WarningNormalScreenSize;
                }
            }
            ++n2;
        }
        if (!StringUtils.isEmpty((CharSequence)errorMsg) && DialogUtil.openQuestionDialog((String)errorMsg) == 128) {
            return;
        }
        objectArray = objs;
        n = objs.length;
        n2 = 0;
        while (n2 < n) {
            feature = objectArray[n2];
            if (feature instanceof FeatureWrapper) {
                this.configurator.setFeature(((FeatureWrapper)feature).getName());
            }
            ++n2;
        }
        super.okPressed();
    }
}

