/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.Assert;
import org.tizen.common.util.ProjectUtil;
import org.tizen.sdblib.util.ObjectUtil;

public class BuildResourceManager {
    protected static final Logger logger = LoggerFactory.getLogger(BuildResourceManager.class);
    public static final String DOT = ".";
    public static final String TEMP_BUILD_DIRECTORY = ".build";
    public static final String FILTER_KEY = "buildResourceFilter";
    private IProject project;
    private IFolder buildFolder;
    private static List<IPath> exclusiveFiles = new ArrayList<IPath>();
    private static Map<IProject, Boolean> projectCleanBuildState = new HashMap<IProject, Boolean>();
    private String filterPattern;
    private static Map<IProject, String> buildDeviceSerialNo = new HashMap<IProject, String>();

    public BuildResourceManager(IProject project) {
        Assert.notNull((Object)project);
        this.project = project;
        this.filterPattern = null;
    }

    public static void setBuildDeviceSerialNo(IProject project, String deviceSerialNo) {
        buildDeviceSerialNo.put(project, deviceSerialNo);
    }

    public static String getBuildDeviceSerialNo(IProject project) {
        return buildDeviceSerialNo.get(project);
    }

    public String getBuildDeviceSerialNo() {
        return BuildResourceManager.getBuildDeviceSerialNo(this.project);
    }

    public static void setProjectCleanBuildState(IProject project, Boolean state) {
        Assert.notNull((Object)project);
        Assert.notNull((Object)state);
        projectCleanBuildState.put(project, state);
    }

    public static Boolean getProjectCleanBuildState(IProject project) {
        Assert.notNull((Object)project);
        if (projectCleanBuildState.containsKey(project)) {
            return projectCleanBuildState.get(project);
        }
        return false;
    }

    protected static void checkParent(IContainer container) throws CoreException {
        Assert.notNull((Object)container);
        IContainer parent = container.getParent();
        if (parent instanceof IFolder) {
            BuildResourceManager.checkParent(parent);
            if (!parent.exists()) {
                IFolder parentFolder = (IFolder)parent;
                parentFolder.create(true, true, null);
                parentFolder.refreshLocal(2, null);
            }
        }
    }

    protected static IFolder getBuildFolder(IProject project, IProgressMonitor monitor) throws CoreException {
        Assert.notNull((Object)project);
        monitor = (IProgressMonitor)ObjectUtil.nvl((Object[])new IProgressMonitor[]{monitor, new NullProgressMonitor()});
        IFolder buildFolder = project.getFolder(TEMP_BUILD_DIRECTORY);
        if (!buildFolder.isSynchronized(0)) {
            buildFolder.refreshLocal(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        if (!buildFolder.exists()) {
            buildFolder.create(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        return buildFolder;
    }

    public IFolder getBuildFolder(IProgressMonitor monitor) throws CoreException {
        monitor = (IProgressMonitor)ObjectUtil.nvl((Object[])new IProgressMonitor[]{monitor, new NullProgressMonitor()});
        if (this.buildFolder == null) {
            this.buildFolder = this.project.getFolder(TEMP_BUILD_DIRECTORY);
        }
        if (!this.buildFolder.isSynchronized(0)) {
            this.buildFolder.refreshLocal(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        if (!this.buildFolder.exists()) {
            this.buildFolder.create(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        return this.buildFolder;
    }

    public static void addExclusivePath(IPath projectRelativeFullPath) {
        Assert.notNull((Object)projectRelativeFullPath);
        if (!exclusiveFiles.contains(projectRelativeFullPath)) {
            exclusiveFiles.add(projectRelativeFullPath);
        }
    }

    public static void addExclusiveList(List<IPath> projectRelativeFullPathList) {
        Assert.notNull(projectRelativeFullPathList);
        for (IPath projectRelativeFullPath : projectRelativeFullPathList) {
            BuildResourceManager.addExclusivePath(projectRelativeFullPath);
        }
    }

    public static IPath[] getExclusiveFileList() {
        return exclusiveFiles.toArray(new IPath[0]);
    }

    public static void removeExclusiveFile(IPath projectRelativeFullPath) {
        Assert.notNull((Object)projectRelativeFullPath);
        if (exclusiveFiles.contains(projectRelativeFullPath)) {
            exclusiveFiles.remove(projectRelativeFullPath);
        }
    }

    public static void removeExclusiveFileList(List<IPath> projectRelativeFullPathList) {
        Assert.notNull(projectRelativeFullPathList);
        for (IPath projectRelativeFullPath : projectRelativeFullPathList) {
            BuildResourceManager.removeExclusiveFile(projectRelativeFullPath);
        }
    }

    public boolean isFilteredResource(IResource resource) {
        Assert.notNull((Object)resource);
        if (resource.getName().startsWith(DOT)) {
            return true;
        }
        if (resource.getType() == 1 && "wgt".equalsIgnoreCase(resource.getFileExtension())) {
            return true;
        }
        IPath resourcePath = resource.getFullPath();
        IPath[] iPathArray = BuildResourceManager.getExclusiveFileList();
        int n = iPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPath projectRelativeFullPath = iPathArray[n2];
            if (projectRelativeFullPath.equals((Object)resourcePath)) {
                return true;
            }
            ++n2;
        }
        String externalFilter = this.getExternalFilter();
        return externalFilter != null && resource.getLocation().toString().matches(externalFilter);
    }

    protected String getExternalFilter() {
        Map buildCommandArgument;
        if (this.filterPattern == null && (buildCommandArgument = ProjectUtil.getBuildCommandArgument((IProject)this.project, (String)"org.tizen.web.project.builder.WebBuilder")) != null && buildCommandArgument.containsKey(FILTER_KEY)) {
            this.filterPattern = (String)buildCommandArgument.get(FILTER_KEY);
        }
        return this.filterPattern;
    }

    public static IPath getLastWorkingRelativePath(IProject project2) {
        return null;
    }
}

