/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.builder.ide;

import org.tizen.common.builder.BuildResult;
import org.tizen.common.file.IResource;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLErrorHandler
implements ErrorHandler {
    private BuildResult buildResult;
    private IResource resource;

    public XMLErrorHandler(BuildResult br, IResource resource) {
        this.buildResult = br;
        this.resource = resource;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.fatalError(e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.buildResult.setResult(BuildResult.Status.ERROR);
        this.buildResult.addBuildErrorInfo(this.resource, e.getLineNumber(), e.getColumnNumber(), 2, e.getMessage());
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        if (!this.buildResult.getResult().equals((Object)BuildResult.Status.ERROR)) {
            this.buildResult.setResult(BuildResult.Status.WARNING);
        }
        this.buildResult.addBuildErrorInfo(this.resource, e.getLineNumber(), e.getColumnNumber(), 1, e.getMessage());
    }
}

