#!/bin/bash -x

while getopts "m:h" opt ; do 
	case $opt in 
		m)
			message="$OPTARG"
			;;
		h)
			echo "SUDO Wrapper"
			echo "usage: tsudo [-m display message] commnads"
			echo " * display message only support gksudo"
			echo " * tsudo needs an absolute path"
			exit 0
	esac
done 

shift $((OPTIND-1))

cmd="$@"
case $INSTALLMANAGER_UI in
	"GUI")
		if [ "`which gksudo`" ] ; then
			if [ "$message" ] ; then
				gksudo -m "$message" -- $cmd
			else
				gksudo -- $cmd
			fi
		elif [ "`which beesu`" ] ; then
			beesu $cmd
		elif [ "`which pkexec`" ] ; then
			pkexec $cmd
		else sudo $cmd
		fi
		;;
	"CLI")
		if [ "$INTERACTIVE" = "true" ] ; then
			sudo $cmd
		else

			cat > tsudo_cmd << EOF
#!/usr/bin/expect --
set timeout 10
spawn sh -c "sudo -S ${cmd};echo \$? > exit_status"
expect {
	"password for" {
		send "${SUPASS}\r"
		exp_continue
	} eof {
		return
	}
}
interact
EOF
			chmod +x ./tsudo_cmd
			./tsudo_cmd
			EXIT_CODE=`cat exit_status`
			if [ "x${EXIT_CODE}" != "x0" ]; then
				rm exit_status
				exit 1;
			else
				rm exit_status
				exit 0;
			fi
		fi
		;;
	*)
		echo "fail: $INSTALLMANAGER_UI $INTERACTIVE"
		exit 1;
		;;
esac

