/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.core.model;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.model.Property;
import org.tizen.manager.util.Log;

public class Snapshot
implements Comparable<Snapshot>,
Cloneable {
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_PATH = "path";
    private static final String FIELD_TIME = "time";
    private List<Property> mProperties;
    private static final Logger logger = Log.getLogger(Snapshot.class);

    public Snapshot(List<Property> properties) {
        this.mProperties = properties;
    }

    public Object clone() throws CloneNotSupportedException {
        Snapshot snapshot = (Snapshot)super.clone();
        snapshot.mProperties = new ArrayList<Property>();
        for (int i = 0; i < this.mProperties.size(); ++i) {
            snapshot.mProperties.add(i, (Property)this.mProperties.get(i).clone());
        }
        return snapshot;
    }

    public String getType() {
        return this.getValue(FIELD_TYPE);
    }

    public String getName() {
        return this.getValue(FIELD_NAME);
    }

    public String getPath() {
        return this.getValue(FIELD_PATH);
    }

    public Date getTime() {
        String strDate = this.getValue(FIELD_TIME);
        if (strDate != null) {
            String formattedStrDate = String.format("%-17s", strDate).replace(' ', '0');
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            Date date = null;
            try {
                date = sdf.parse(formattedStrDate);
            }
            catch (ParseException e) {
                logger.error("Snapshot time attribute is not SimpleDateFormat.");
            }
            return date;
        }
        return null;
    }

    private Property getProperty(String key) {
        for (Property prop : this.mProperties) {
            if (!prop.getName().equals(key)) continue;
            return prop;
        }
        return null;
    }

    public List<Property> getProperties() {
        return this.mProperties;
    }

    public void setProperties(List<Property> properties) {
        this.mProperties = properties;
    }

    private String getValue(String key) {
        Property property = this.getProperty(key);
        if (property == null) {
            return null;
        }
        return property.getValue();
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object arg) {
        if (arg != null) {
            String argName = ((Snapshot)arg).getName();
            return argName != null && argName.equals(this.getName());
        }
        return false;
    }

    @Override
    public int compareTo(Snapshot snapshot) {
        Date time = this.getTime();
        Date argTime = snapshot.getTime();
        if (argTime != null && time != null) {
            return argTime.compareTo(time);
        }
        return -1;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }
}

