/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.core.Install;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.tizen.manager.core.ContentProvider;
import org.tizen.manager.core.Install.IInstallUninstallPackageProgressMonitor;
import org.tizen.manager.core.Install.InstallUninstallObject;
import org.tizen.manager.core.Install.ManagerableUninstallerCallable;
import org.tizen.manager.core.Install.UninstallManagerMonitor;
import org.tizen.manager.pkg.Package;

public class UninstallPackageManager {
    private HashMap<String, InstallUninstallObject> uninstallObjectMap = new HashMap();
    private ExecutorService uninstallerThreadExecutor = Executors.newFixedThreadPool(1);
    private ContentProvider contentProvider;

    public UninstallPackageManager(ContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public synchronized void requestUninstallPackage(Package pkg, IInstallUninstallPackageProgressMonitor monitor) {
        if (this.uninstallObjectMap.containsKey(pkg.getPackageName())) {
            monitor.setProgress("There already exists same uninstall-process.");
            InstallUninstallObject uninstallObject = this.uninstallObjectMap.get(pkg.getPackageName());
            uninstallObject.addMonitor(monitor);
            if (uninstallObject.isCompleted()) {
                monitor.setProgress("The existing uninstall-process is already done.");
                monitor.done();
            }
        } else {
            monitor.setProgress("Creating new uninstall-progress... ");
            InstallUninstallObject doObject = new InstallUninstallObject(pkg.getPackageName());
            doObject.addMonitor(monitor);
            UninstallManagerMonitor uninstallMonitor = new UninstallManagerMonitor(this, pkg);
            this.uninstallObjectMap.put(pkg.getPackageName(), doObject);
            this.uninstallerThreadExecutor.submit(new ManagerableUninstallerCallable(this.contentProvider, pkg, uninstallMonitor));
        }
    }

    public synchronized void removePackage(Package pkg) {
        this.uninstallObjectMap.remove(pkg.getPackageName());
    }

    synchronized void setDone(Package pkg, Exception error) {
        InstallUninstallObject doObject = this.uninstallObjectMap.get(pkg.getPackageName());
        doObject.setCompleted(true);
        ArrayList<IInstallUninstallPackageProgressMonitor> monitorListClone = new ArrayList<IInstallUninstallPackageProgressMonitor>();
        monitorListClone.addAll(doObject.getMonitorList());
        for (IInstallUninstallPackageProgressMonitor idmProgressMonitor : monitorListClone) {
            doObject.removeMonitor(idmProgressMonitor);
            idmProgressMonitor.setError(error);
            idmProgressMonitor.done();
        }
        if (doObject.getMonitorList().isEmpty()) {
            this.uninstallObjectMap.remove(pkg.getPackageName());
        }
    }

    synchronized void setRemoveOldWorked(Package pkg, int work) {
        InstallUninstallObject doObject = this.uninstallObjectMap.get(pkg.getPackageName());
        List<IInstallUninstallPackageProgressMonitor> monitorList = doObject.getMonitorList();
        for (IInstallUninstallPackageProgressMonitor idmProgressMonitor : monitorList) {
            idmProgressMonitor.removeOldWorked(work);
        }
    }

    synchronized void setMoveFilesWorked(Package pkg, int work) {
        InstallUninstallObject doObject = this.uninstallObjectMap.get(pkg.getPackageName());
        List<IInstallUninstallPackageProgressMonitor> monitorList = doObject.getMonitorList();
        for (IInstallUninstallPackageProgressMonitor idmProgressMonitor : monitorList) {
            idmProgressMonitor.moveFilesWorked(work);
        }
    }

    synchronized void setRunScriptWorked(Package pkg, int work) {
        InstallUninstallObject doObject = this.uninstallObjectMap.get(pkg.getPackageName());
        List<IInstallUninstallPackageProgressMonitor> monitorList = doObject.getMonitorList();
        for (IInstallUninstallPackageProgressMonitor idmProgressMonitor : monitorList) {
            idmProgressMonitor.runScriptWorked(work);
        }
    }

    synchronized void setProgress(Package pkg, String message) {
        InstallUninstallObject doObject = this.uninstallObjectMap.get(pkg.getPackageName());
        List<IInstallUninstallPackageProgressMonitor> monitorList = doObject.getMonitorList();
        for (IInstallUninstallPackageProgressMonitor idmProgressMonitor : monitorList) {
            idmProgressMonitor.setProgress(message);
        }
    }
}

