#!/bin/bash -x

APPLICATIONS_DIR=
TARGET_DIR=
INSTALLED_DIR_NAME=
APP_NAME=

parseParameter()
{
	while [ $# -gt 0 ]
	do
		case $1 in
			-t|--targetDir)
				shift
				APPLICATIONS_DIR="$1"
				;;
			-in|--installedDirName)
				shift
				INSTALLED_DIR_NAME="$1"
				;;
			-n|--name)
				shift
				APP_NAME="$1"
				;;
			-an|--appName)
				shift
				APP_NAME="$1"
				;;
			*)
				exit 12
				;;
		esac
		shift
	done
}
parseParameter "$@"

# Check Application directory
if [ "$APPLICATIONS_DIR" = "" ]; then
	if [ -e "${HOME}/Applications" ]; then
		APPLICATIONS_DIR="${HOME}/Applications"
	else
		APPLICATIONS_DIR="/Applications"
	fi
fi

# Check group name
if [ "$INSTALLED_DIR_NAME" != "" ]; then
	TARGET_DIR="$APPLICATIONS_DIR/$INSTALLED_DIR_NAME"
else
	TARGET_DIR="$APPLICATIONS_DIR"
fi

if [ -f "${TARGET_DIR}/${APP_NAME}" ]; then
	rm -rf "${TARGET_DIR}/${APP_NAME}"
fi

# If no alias, remove group dir
if [ "$INSTALLED_DIR_NAME" != "" ]; then
	EXISTS_FILE="`ls -A "$TARGET_DIR"`"
	if [ "${EXISTS_FILE}" ]; then
    	echo "Take action $TARGET_DIR is not Empty"
	else
    	echo "$TARGET_DIR is Empty"
    	rm -rf "${TARGET_DIR}"		
	fi
fi

