/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.page.monitor;

import java.util.ArrayList;
import org.apache.logging.log4j.Logger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TableItem;
import org.tizen.manager.core.ICommonProgressMonitor;
import org.tizen.manager.exception.ProgressLog;
import org.tizen.manager.pkg.Component;
import org.tizen.manager.util.Log;
import org.tizen.packagemanager.ui.page.ProgressItem;
import org.tizen.packagemanager.ui.page.ProgressTabView;
import org.tizen.packagemanager.ui.page.ProgressTableView;
import org.tizen.packagemanager.ui.page.ViewController;
import org.tizen.packagemanager.ui.page.monitor.TotalProgressMonitor;

public class UninstallProgressMonitor
implements ICommonProgressMonitor {
    private static final Logger logger = Log.getLogger(UninstallProgressMonitor.class);
    private Long workingSize = 0L;
    private boolean isDone = false;
    private boolean isFailed = false;
    private boolean isPause = false;
    private ICommonProgressMonitor.ProgressMonitorType progressMonitorType = ICommonProgressMonitor.ProgressMonitorType.NONE;
    private ProgressTabView parentView = null;
    private ProgressTableView tableView = null;
    private Exception error = null;
    private ProgressItem progressItem = null;
    private Component component = null;
    private boolean isCanceled = false;
    private int currentWorked;
    private TotalProgressMonitor totalMonitor;
    private ViewController viewController;
    private ArrayList<ICommonProgressMonitor> group;

    public UninstallProgressMonitor(ViewController viewController, ProgressItem progressItem, ProgressTabView parenView, boolean isRefreshRepoNeeded, TotalProgressMonitor totalMonitor) {
        assert (logger != null);
        this.viewController = viewController;
        this.progressItem = progressItem;
        this.component = progressItem.getComponent();
        this.parentView = parenView;
        this.tableView = this.parentView.getProgressTableView();
        this.workingSize = this.component.getUninstallSize();
        this.totalMonitor = totalMonitor;
        this.totalMonitor.addWorkingMonitor(this);
        this.group = new ArrayList();
        this.group.add(this);
        this.progressMonitorType = ICommonProgressMonitor.ProgressMonitorType.UNINSTALL;
    }

    @Override
    public void beginTask(String name, int totalWork) {
        this.totalMonitor.setRemainingTime();
    }

    @Override
    public synchronized void done() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                UninstallProgressMonitor.this.isDone = true;
                TableItem tableItem = UninstallProgressMonitor.this.tableView.getTableItemByComponent(UninstallProgressMonitor.this.component);
                if (UninstallProgressMonitor.this.component.getError() == null) {
                    UninstallProgressMonitor.this.progressItem.setProgress(100);
                    UninstallProgressMonitor.this.tableView.setItemProgress(tableItem);
                } else if (UninstallProgressMonitor.this.isCanceled()) {
                    UninstallProgressMonitor.this.tableView.setItemCanceled(tableItem);
                } else {
                    UninstallProgressMonitor.this.isFailed = true;
                    UninstallProgressMonitor.this.tableView.setItemFailed(tableItem);
                }
                UninstallProgressMonitor.this.totalMonitor.updateTotalWorked();
                UninstallProgressMonitor.this.viewController.getMainTabView().refresh(false);
                UninstallProgressMonitor.this.viewController.getExtendedTabView().refresh(false);
            }
        });
        this.totalMonitor.addDoneMonitor(this);
    }

    @Override
    public boolean isCanceled() {
        return this.isCanceled;
    }

    @Override
    public void setCanceled(boolean value) {
        if (!value || this.isCancelable()) {
            this.isCanceled = value;
            if (this.isCanceled) {
                this.progressItem.setProgress(0);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        UninstallProgressMonitor.this.tableView.refreshTableItem(UninstallProgressMonitor.this.progressItem);
                    }
                });
            }
        }
    }

    @Override
    public void init() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                TableItem tableItem = UninstallProgressMonitor.this.tableView.getTableItemByComponent(UninstallProgressMonitor.this.component);
                UninstallProgressMonitor.this.tableView.setProgressText(tableItem, "");
            }
        });
    }

    @Override
    public void worked(int work) {
        this.currentWorked = work;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                UninstallProgressMonitor.this.totalMonitor.updateTotalWorked();
                TableItem tableItem = UninstallProgressMonitor.this.tableView.getTableItemByComponent(UninstallProgressMonitor.this.component);
                if (UninstallProgressMonitor.this.progressItem.getWorkType() == ProgressItem.WorkType.NONE) {
                    UninstallProgressMonitor.this.progressItem.setWorkingState(ProgressItem.WorkType.UNINSTALL);
                }
                UninstallProgressMonitor.this.progressItem.setProgress(UninstallProgressMonitor.this.currentWorked);
                UninstallProgressMonitor.this.tableView.setItemProgress(tableItem);
            }
        });
    }

    @Override
    public void setError(Exception err) {
        if (this.error == null) {
            this.error = err;
        }
    }

    @Override
    public Exception getError() {
        return this.error;
    }

    @Override
    public void setCancelable(boolean isCancelable) {
        this.progressItem.setCancelable(isCancelable);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                UninstallProgressMonitor.this.tableView.refreshTableItem(UninstallProgressMonitor.this.progressItem);
            }
        });
        if (!isCancelable) {
            for (ICommonProgressMonitor groupMonitor : this.getMonitorGroup()) {
                if (groupMonitor == this || !groupMonitor.isCancelable()) continue;
                groupMonitor.setCancelable(isCancelable);
            }
        }
    }

    @Override
    public boolean isCancelable() {
        return this.progressItem.isCancelable();
    }

    @Override
    public int getWorked() {
        return this.currentWorked;
    }

    @Override
    public void setProgress(String msg) {
        this.setProgress(msg, ProgressLog.LogType.INFO);
    }

    @Override
    public void setProgress(String msg, ProgressLog.LogType type) {
        if (type == ProgressLog.LogType.INFO) {
            logger.info(msg);
        } else if (type == ProgressLog.LogType.ERROR) {
            logger.error(msg);
        } else {
            logger.warn(msg);
        }
        this.component.addProgressLog(msg, ProgressLog.LogType.INFO);
    }

    @Override
    public void setMonitorGroup(ArrayList<ICommonProgressMonitor> monitorGroup) {
        this.group = monitorGroup;
    }

    @Override
    public ArrayList<ICommonProgressMonitor> getMonitorGroup() {
        return this.group;
    }

    @Override
    public Long getWorkingSize() {
        return this.workingSize;
    }

    @Override
    public void setWorkingSize(Long size) {
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    @Override
    public boolean isFailed() {
        return this.isFailed;
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public ICommonProgressMonitor.ProgressMonitorType getProgressMonitorType() {
        return this.progressMonitorType;
    }

    @Override
    public boolean isPause() {
        return this.isPause;
    }

    @Override
    public void setPause(boolean b) {
        this.isPause = b;
    }
}

