/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.provider.maintab;

import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TreeItem;
import org.tizen.manager.pkg.Component;
import org.tizen.packagemanager.ui.page.CommonTreeView;
import org.tizen.packagemanager.ui.page.custom.CustomTableIconButton;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;

public class InstallColumnLabelProvider
extends OwnerDrawLabelProvider {
    private WizardUIResourceHandler uiRsrcHandler = WizardUIResourceHandler.getInstance();
    private CommonTreeView parentView;
    private Color treeSelRowColor;
    private Color treeBackColor;
    private int columnWidth;

    public InstallColumnLabelProvider(CommonTreeView parent, int columnWidth) {
        this.parentView = parent;
        this.columnWidth = columnWidth;
        this.treeBackColor = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE);
        this.treeSelRowColor = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_PURE_SKY_BLUE);
    }

    @Override
    protected void measure(Event arg0, Object arg1) {
    }

    @Override
    public void update(ViewerCell cell) {
        Component component = (Component)cell.getElement();
        TreeItem treeItem = (TreeItem)cell.getViewerRow().getItem();
        CustomTableIconButton uninstallButton = this.parentView.getUninstallButton(treeItem);
        CustomTableIconButton installButton = this.parentView.getInstallButton(treeItem);
        if (!component.hasChildren()) {
            if (component.getInstallState() == Component.InstallState.INSTALL) {
                installButton.setDisabled(false);
                installButton.setHidden(false);
                uninstallButton.setDisabled(true);
                uninstallButton.setHidden(true);
            } else if (component.getInstallState() == Component.InstallState.INSTALLING || component.getInstallState() == Component.InstallState.UPDATING || component.getInstallState() == Component.InstallState.UNINSTALLING) {
                installButton.setHidden(false);
                uninstallButton.setHidden(false);
                installButton.setDisabled(true);
                uninstallButton.setDisabled(true);
            } else if (component.getInstallState() == Component.InstallState.UPDATE || component.getInstallState() == Component.InstallState.UNINSTALL) {
                installButton.setHidden(true);
                installButton.setDisabled(true);
                uninstallButton.setHidden(false);
                uninstallButton.setDisabled(false);
            } else {
                installButton.setHidden(true);
                installButton.setDisabled(true);
                uninstallButton.setHidden(true);
                uninstallButton.setDisabled(true);
            }
        } else if (component.hasInstallingLeafDecendents() || component.hasUninstallingLeafDecendents() || component.getInstallState() == Component.InstallState.INSTALLING || component.getInstallState() == Component.InstallState.UNINSTALLING || component.getInstallState() == Component.InstallState.UPDATING) {
            installButton.setHidden(false);
            uninstallButton.setHidden(false);
            installButton.setDisabled(true);
            uninstallButton.setDisabled(true);
        } else if (!component.isVirtual() && component.getInstallState() == Component.InstallState.INSTALL || component.hasInstallableLeafDecendents()) {
            installButton.setHidden(false);
            installButton.setDisabled(false);
            uninstallButton.setHidden(true);
            uninstallButton.setDisabled(true);
        } else if (!component.isVirtual() && (component.getInstallState() == Component.InstallState.UNINSTALL || component.getInstallState() == Component.InstallState.UPDATE) || component.hasUninstallableLeafDecendents()) {
            installButton.setHidden(true);
            installButton.setDisabled(true);
            uninstallButton.setHidden(false);
            uninstallButton.setDisabled(false);
        } else {
            installButton.setHidden(true);
            installButton.setDisabled(true);
            uninstallButton.setHidden(true);
            uninstallButton.setDisabled(true);
        }
        super.update(cell);
    }

    @Override
    protected void erase(Event event, Object element) {
        Color oldBackground = event.gc.getBackground();
        if ((event.detail & 2) != 0) {
            event.gc.setBackground(this.treeSelRowColor);
            event.detail &= 0xFFFFFFFD;
        } else {
            event.gc.setBackground(this.treeBackColor);
        }
        event.gc.fillRectangle(event.x, event.y, event.width, event.height);
        event.gc.setBackground(oldBackground);
        super.erase(event, element);
    }

    @Override
    protected void paint(Event event, Object element) {
        Component component = (Component)element;
        TreeItem treeItem = (TreeItem)event.item;
        CustomTableIconButton uninstallButton = this.parentView.getUninstallButton(treeItem);
        CustomTableIconButton installButton = this.parentView.getInstallButton(treeItem);
        Image image = null;
        if (!component.hasChildren()) {
            if (component.getInstallState() == Component.InstallState.INSTALL || component.getInstallState() == Component.InstallState.UNINSTALLING) {
                image = installButton.getImage();
            } else if (component.getInstallState() == Component.InstallState.UPDATE || component.getInstallState() == Component.InstallState.UNINSTALL || component.getInstallState() == Component.InstallState.UPDATING || component.getInstallState() == Component.InstallState.INSTALLING) {
                image = uninstallButton.getImage();
            }
        } else if (component.hasInstallingLeafDecendents()) {
            image = uninstallButton.getImage();
        } else if (component.hasUninstallingLeafDecendents()) {
            image = installButton.getImage();
        } else if (!component.isVirtual() && component.getInstallState() == Component.InstallState.INSTALL || component.hasInstallableLeafDecendents()) {
            image = installButton.getImage();
        } else if (!component.isVirtual() && component.getInstallState() == Component.InstallState.UNINSTALL || component.hasUninstallableLeafDecendents()) {
            image = uninstallButton.getImage();
        }
        if (image != null) {
            int imgOffsetY = (event.getBounds().height - image.getBounds().height) / 2;
            int imgOffsetX = (this.columnWidth - image.getBounds().width) / 2;
            event.gc.drawImage(image, event.x + imgOffsetX, event.y + imgOffsetY);
        }
    }
}

