/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.provider.maintab;

import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TreeItem;
import org.tizen.manager.pkg.Component;
import org.tizen.packagemanager.ui.page.CommonTreeView;
import org.tizen.packagemanager.ui.page.custom.CustomTableIconButton;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;

public class LicenseColumnLabelProvider
extends OwnerDrawLabelProvider {
    private WizardUIResourceHandler uiRsrcHandler = WizardUIResourceHandler.getInstance();
    private CommonTreeView parentView;
    private Color treeSelRowColor;
    private Color treeBackColor;
    private int columnWidth;

    public LicenseColumnLabelProvider(CommonTreeView parent, int columnWidth) {
        this.parentView = parent;
        this.treeSelRowColor = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_PURE_SKY_BLUE);
        this.treeBackColor = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE);
        this.columnWidth = columnWidth;
    }

    @Override
    public void update(ViewerCell cell) {
        Component component = (Component)cell.getElement();
        TreeItem treeItem = (TreeItem)cell.getViewerRow().getItem();
        CustomTableIconButton button = this.parentView.getLicenseButton(treeItem);
        if (component.hasLicense() && component.getInstallState() == Component.InstallState.INSTALL) {
            button.setHidden(false);
        } else {
            button.setHidden(true);
        }
        super.update(cell);
    }

    @Override
    protected void erase(Event event, Object element) {
        Color oldBackground = event.gc.getBackground();
        if ((event.detail & 2) != 0) {
            event.gc.setBackground(this.treeSelRowColor);
            event.detail &= 0xFFFFFFFD;
        } else {
            event.gc.setBackground(this.treeBackColor);
        }
        event.gc.fillRectangle(event.x, event.y, event.width, event.height);
        event.gc.setBackground(oldBackground);
        super.erase(event, element);
    }

    @Override
    protected void measure(Event arg0, Object arg1) {
    }

    @Override
    protected void paint(Event event, Object element) {
        TreeItem treeItem = (TreeItem)event.item;
        CustomTableIconButton button = this.parentView.getLicenseButton(treeItem);
        Image image = button.getImage();
        if (image != null) {
            int imgOffsetY = (event.getBounds().height - image.getBounds().height) / 2;
            int imgOffsetX = (this.columnWidth - image.getBounds().width) / 2;
            event.gc.drawImage(image, event.x + imgOffsetX - 2, event.y + imgOffsetY);
            event.gc.dispose();
        }
    }
}

