/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.uninstaller.ui.dialog;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;
import org.tizen.uninstaller.ui.dialog.IMButton;

public class CustomMessageBoxDialog
extends Dialog {
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int OK = 0;
    public static final int CANCEL = 1;
    private WizardUIResourceHandler uiResource;
    private String title;
    private String msg;
    private DialogType dlgType;
    private boolean onlyOk;

    public CustomMessageBoxDialog(Shell parentShell, WizardUIResourceHandler uiResource, String title, String msg, DialogType dlgType, boolean onlyOk) {
        super(parentShell);
        this.setShellStyle(67616);
        this.uiResource = uiResource;
        this.title = title;
        this.msg = msg;
        this.dlgType = dlgType;
        this.onlyOk = onlyOk;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setBackground(this.uiResource.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        container.setLayout(new FormLayout());
        this.createContent(container);
        this.createLine(container);
        this.createButton(container);
        return container;
    }

    private void createContent(Composite composite) {
        Composite contentArea = new Composite(composite, 0);
        contentArea.setBackground(this.uiResource.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        Rectangle contentAreaBounds = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MESSAGEBOX_DIALOG_CONTENT);
        FormData contentAreaFormData = new FormData();
        contentAreaFormData.left = new FormAttachment(composite, contentAreaBounds.x, 16384);
        contentAreaFormData.top = new FormAttachment(composite, contentAreaBounds.y, 16384);
        contentAreaFormData.width = contentAreaBounds.width;
        contentAreaFormData.height = contentAreaBounds.height;
        contentArea.setLayoutData(contentAreaFormData);
        contentArea.setBackgroundMode(1);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginLeft = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginBottom = 0;
        contentArea.setLayout(gridLayout);
        Image iconImage = null;
        if (this.dlgType == null) {
            iconImage = this.uiResource.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_INFO_ICON);
        } else if (this.dlgType == DialogType.INFO) {
            iconImage = this.uiResource.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_INFO_ICON);
        } else if (this.dlgType == DialogType.NOTIFY_OK) {
            iconImage = this.uiResource.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_INFO_ICON);
        } else if (this.dlgType == DialogType.NOTIFY_YES) {
            iconImage = this.uiResource.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_INFO_ICON);
        } else if (this.dlgType == DialogType.WARNING) {
            iconImage = this.uiResource.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_WARNING_ICON);
        } else if (this.dlgType == DialogType.ERROR) {
            iconImage = this.uiResource.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_WARNING_ICON);
        } else if (this.dlgType == DialogType.QESTION) {
            iconImage = this.uiResource.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_QEUSTION_ICON);
        }
        if (iconImage != null) {
            IMButton ibm = new IMButton(contentArea, 0x20000000);
            GridData iconGriddata = new GridData(131072, 0x1000000, true, true);
            iconGriddata.widthHint = iconImage.getBounds().width;
            iconGriddata.heightHint = iconImage.getBounds().height;
            ibm.setLayoutData(iconGriddata);
            ibm.setImage(iconImage);
        }
        Rectangle textBounds = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MESSAGEBOX_DIALOG_CONTENT_TEXT);
        StyledText textArea = new StyledText(contentArea, 66);
        textArea.setText(this.msg);
        GridData gridData = new GridData(16384, 0x1000000, true, true);
        gridData.widthHint = textBounds.width;
        textArea.setLayoutData(gridData);
        textArea.setFont(this.uiResource.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 1));
        textArea.setAlignment(16384);
        textArea.setEditable(false);
        textArea.setCaret(null);
        textArea.setMargins(textBounds.x, 0, 0, textBounds.y);
    }

    private void createLine(Composite composite) {
        Composite splitterContainer = new Composite(composite, 0x20000000);
        Rectangle lineBounds = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MESSAGEBOX_DIALOG_LINE);
        FormData splitterFormData = new FormData();
        splitterFormData.left = new FormAttachment(composite, lineBounds.x, 16384);
        splitterFormData.top = new FormAttachment(composite, lineBounds.y, 16384);
        splitterFormData.width = lineBounds.width;
        splitterFormData.height = lineBounds.height;
        splitterContainer.setLayoutData(splitterFormData);
        splitterContainer.setLayout(new FormLayout());
        splitterContainer.setBackground(this.uiResource.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_LINE_SPLITTER));
    }

    private void createButton(Composite composite) {
        String okString = null;
        String cancelString = null;
        if (this.dlgType == null) {
            okString = "OK";
        } else if (this.dlgType == DialogType.INFO) {
            okString = "OK";
        } else if (this.dlgType == DialogType.NOTIFY_OK) {
            okString = "OK";
        } else if (this.dlgType == DialogType.NOTIFY_YES) {
            okString = "Yes";
            cancelString = "No";
        } else if (this.dlgType == DialogType.WARNING) {
            okString = "Yes";
            cancelString = "No";
        } else if (this.dlgType == DialogType.ERROR) {
            okString = "OK";
        } else if (this.dlgType == DialogType.QESTION) {
            okString = "Yes";
            cancelString = "No";
        }
        if (this.onlyOk) {
            cancelString = null;
        }
        Font buttonFont = this.uiResource.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0);
        Button okButton = new Button(composite, 8);
        okButton.setText(okString);
        okButton.setFont(buttonFont);
        Rectangle okBounds = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MESSAGEBOX_DIALOG_OK_BUTTON);
        FormData okFormData = new FormData();
        okFormData.left = new FormAttachment(composite, okBounds.x, 16384);
        okFormData.top = new FormAttachment(composite, okBounds.y, 16384);
        okFormData.width = okBounds.width;
        okFormData.height = okBounds.height;
        okButton.setLayoutData(okFormData);
        okButton.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                CustomMessageBoxDialog.this.okPressed();
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent arg0) {
                CustomMessageBoxDialog.this.okPressed();
            }
        });
        if (cancelString != null) {
            Button cancelButton = new Button(composite, 8);
            cancelButton.setText(cancelString);
            cancelButton.setFont(buttonFont);
            Rectangle cancelBounds = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MESSAGEBOX_DIALOG_CANCEL_BUTTON);
            FormData cancelFormData = new FormData();
            cancelFormData.left = new FormAttachment(composite, cancelBounds.x, 16384);
            cancelFormData.top = new FormAttachment(composite, cancelBounds.y, 16384);
            cancelFormData.width = cancelBounds.width;
            cancelFormData.height = cancelBounds.height;
            cancelButton.setLayoutData(cancelFormData);
            cancelButton.addSelectionListener(new SelectionListener(){

                @Override
                public void widgetSelected(SelectionEvent arg0) {
                    CustomMessageBoxDialog.this.cancelPressed();
                }

                @Override
                public void widgetDefaultSelected(SelectionEvent arg0) {
                    CustomMessageBoxDialog.this.cancelPressed();
                }
            });
        }
    }

    @Override
    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
        Shell parentShell = null;
        try {
            parentShell = newShell.getParent().getShell();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Rectangle bounds = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MESSAGEBOX_DIALOG);
        if (parentShell != null) {
            Rectangle pBounds = parentShell.getBounds();
            newShell.setBounds(pBounds.x + pBounds.width / 2 - bounds.width / 2, pBounds.y + pBounds.height / 2 - bounds.height / 2, bounds.width, bounds.height);
        } else {
            newShell.setBounds(bounds);
        }
    }

    @Override
    protected Control createButtonBar(Composite parent) {
        return null;
    }

    public static enum DialogType {
        INFO,
        NOTIFY_OK,
        NOTIFY_YES,
        WARNING,
        ERROR,
        QESTION;

    }
}

