/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.library.sdkutils.util.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.tizen.library.sdkutils.util.Log;

public class PackageContentEditor {
    private static PackageContentEditor contentEditor = null;

    public static PackageContentEditor getInstance() {
        if (contentEditor == null) {
            contentEditor = new PackageContentEditor();
        }
        return contentEditor;
    }

    public static boolean replaceContent(String fileName, String packageName, String contentName, String content) {
        File file = new File(fileName);
        return PackageContentEditor.replaceContent(file, packageName, contentName, content);
    }

    public static boolean replaceContent(File file, String packageName, String contentName, String content) {
        boolean result = false;
        File rfile = file;
        File wfile = new File(file.toString() + ".bak");
        if (!rfile.exists()) {
            return result;
        }
        if (wfile.exists()) {
            try {
                wfile.delete();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
        try {
            wfile.createNewFile();
        }
        catch (IOException e1) {
            System.out.println("A file cannot be created: " + wfile.toString());
        }
        try (FileInputStream fis = new FileInputStream(rfile);
             InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
             BufferedReader br = new BufferedReader(isr);
             FileOutputStream fos = new FileOutputStream(wfile);
             OutputStreamWriter osr = new OutputStreamWriter(fos);
             BufferedWriter wr = new BufferedWriter(osr);){
            String readLine;
            while ((readLine = br.readLine()) != null) {
                if (readLine.matches("Package[\\s]*:[\\s]*" + packageName)) {
                    wr.write(readLine);
                    wr.newLine();
                    while ((readLine = br.readLine()) != null && !readLine.contains(contentName)) {
                        wr.write(readLine);
                        wr.newLine();
                    }
                    if (readLine != null) {
                        String writeLine = readLine;
                        int startChar = readLine.indexOf(":");
                        if (startChar == -1) {
                            break;
                        }
                        String str = readLine.substring(startChar + 2);
                        writeLine = writeLine.replace(str, content);
                        wr.write(writeLine);
                        wr.newLine();
                        result = true;
                        continue;
                    }
                }
                if (readLine == null) continue;
                wr.write(readLine);
                wr.newLine();
            }
        }
        catch (IOException ioe) {
            ioe.getStackTrace();
            result = false;
        }
        try {
            if (!rfile.delete()) {
                Log.error("Unable to delete file");
            }
            if (!wfile.renameTo(rfile)) {
                Log.error("Unable to rename file");
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getContent(String fileName, String packageName, String contentName) {
        File file = new File(fileName);
        return PackageContentEditor.getContent(file, packageName, contentName);
    }

    public static String getContent(File file, String packageName, String contentName) {
        String retString = "";
        File rfile = file;
        if (!rfile.exists()) {
            return retString;
        }
        try (FileInputStream fis = new FileInputStream(rfile);
             InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
             BufferedReader br = new BufferedReader(isr);){
            String readLine;
            while ((readLine = br.readLine()) != null) {
                if (!readLine.matches("Package[\\s]*:[\\s]*" + packageName)) continue;
                while ((readLine = br.readLine()) != null && !readLine.contains(contentName)) {
                }
                if (readLine == null) continue;
                int startChar = readLine.indexOf(":");
                if (startChar == -1) {
                } else {
                    retString = readLine.substring(startChar + 1);
                    retString = retString.trim();
                }
                break;
            }
        }
        catch (IOException ioe) {
            ioe.getStackTrace();
        }
        return retString;
    }
}

