/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PlatformUtil;

public class ShellParser {
    private StringBuilder outputMessage = new StringBuilder();
    private int exitCode = 0;
    private static final Logger logger = Log.getLogger(ShellParser.class);
    private ExecutorService shellParserExecutor = Executors.newFixedThreadPool(2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runParsing(final Process process, final String packageName) {
        if (process == null) {
            return;
        }
        Thread inputThread = new Thread(){

            @Override
            public void run() {
                ShellParser.this.parseStdOut(process.getInputStream(), packageName);
            }
        };
        Thread errorThread = new Thread(){

            @Override
            public void run() {
                ShellParser.this.parseStdErr(process.getErrorStream(), packageName);
            }
        };
        Future<?> submit = this.shellParserExecutor.submit(inputThread);
        Future<?> submit2 = this.shellParserExecutor.submit(errorThread);
        try {
            submit.get();
            submit2.get();
        }
        catch (InterruptedException e) {
            logger.throwing(e);
        }
        catch (ExecutionException e) {
            logger.throwing(e);
        }
        finally {
            while (!this.shellParserExecutor.isTerminated() || !this.shellParserExecutor.isShutdown()) {
                this.shellParserExecutor.shutdownNow();
                this.shellParserExecutor.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseStdOut(InputStream input, String packageName) {
        BufferedReader br = null;
        try {
            String line;
            InputStreamReader isr = new InputStreamReader(input, PlatformUtil.CURRENT_CHARSET);
            br = new BufferedReader(isr);
            if (packageName == null) {
                packageName = "system";
            }
            while ((line = br.readLine()) != null) {
                this.appendToOutMessages(line.trim() + "\n");
                logger.trace("\t[" + packageName + "] " + line);
            }
        }
        catch (IOException ioe) {
            logger.error("Shellparser fail to parse input stream.");
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    logger.error("ShellParser fail to close output stream.");
                }
            }
        }
    }

    private synchronized void appendToOutMessages(String msg) {
        this.outputMessage.append(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseStdErr(InputStream input, String packageName) {
        BufferedReader br = null;
        try {
            String line;
            InputStreamReader isr = new InputStreamReader(input, PlatformUtil.CURRENT_CHARSET);
            br = new BufferedReader(isr);
            if (packageName == null) {
                packageName = "system";
            }
            while ((line = br.readLine()) != null) {
                this.appendToOutMessages(line.trim() + "\n");
                logger.trace("\t[" + packageName + "] " + line);
            }
        }
        catch (IOException ioe) {
            logger.throwing(ioe);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    logger.error("ShellParser fail to close output stream.");
                }
            }
        }
    }

    public String getOutputMessage() {
        return this.outputMessage.toString();
    }

    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    public int getExitCode() {
        return this.exitCode;
    }
}

