/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.util;

import java.io.File;
import org.apache.logging.log4j.Logger;
import org.tizen.library.sdkutils.api.ISDKUtils;
import org.tizen.library.sdkutils.api.impl.SDKUtils;
import org.tizen.manager.core.ContentProvider;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PathUtil;

public class Tools {
    private static final Logger logger = Log.getLogger(Tools.class);

    public static boolean runTizenTools(ContentProvider contentProvider, ToolType toolType) {
        boolean success = false;
        String sdkInfoLocation = contentProvider.getSDKInfo().getInstalledPath() + File.separator + "sdk.info";
        String executionDir = PathUtil.getExecutableJarParentDir();
        boolean copyResult = PathUtil.fileCopy(sdkInfoLocation, executionDir + File.separator + "sdk.info");
        logger.trace("copy sdk.info to " + executionDir + " : result -> " + copyResult);
        if (copyResult) {
            ISDKUtils.SdkTool sdkTool = ISDKUtils.SdkTool.getSdkTool(toolType.toString());
            if (sdkTool != null) {
                SDKUtils sdkUtils = SDKUtils.getInstance();
                String toolPath = sdkUtils.getSDKToolPath(sdkTool);
                if (toolPath != null) {
                    logger.trace("execute SDK Tools: " + (Object)((Object)sdkTool) + ", path : " + toolPath);
                    ISDKUtils.ExecuteResult ret = sdkUtils.executeSDKTools(sdkTool);
                    if (ret == ISDKUtils.ExecuteResult.SUCCESS) {
                        logger.trace("execute SDK Tools: " + (Object)((Object)sdkTool) + " run success");
                        success = true;
                    } else if (ret == ISDKUtils.ExecuteResult.NOT_INSTALLED) {
                        logger.trace("execute SDK Tools: " + (Object)((Object)sdkTool) + " not installed");
                    } else {
                        logger.trace("execute SDK Tools: " + (Object)((Object)sdkTool) + " run fail");
                    }
                } else {
                    logger.trace("execute SDK Tools: " + (Object)((Object)sdkTool) + " path is NULL");
                }
            }
        } else {
            logger.trace("FAIL!!! copy sdk.info to " + executionDir + " : result -> " + copyResult);
        }
        return success;
    }

    public static enum ToolType {
        TIZEN_STUDIO("tizen-studio", "Tizen Studio"),
        EMULATOR_MANAGER("emulator-manager", "Emulator Manager"),
        DYNAMIC_ANALYZER("dynamic-analyzer", "Dynamic Analyzer"),
        CERTIFICATE_MANAGER("certificate-manager", "Certificate Manager"),
        DEVICE_MANAGER("device-manager", "Device Manager");

        private final String name;
        private final String dispName;

        private ToolType(String name, String dispName) {
            this.name = name;
            this.dispName = dispName;
        }

        public String toString() {
            return this.name;
        }

        public String getDisplayName() {
            return this.dispName;
        }

        public static ToolType getSdkTool(String name) {
            for (ToolType s : ToolType.values()) {
                if (!s.toString().equalsIgnoreCase(name)) continue;
                return s;
            }
            return null;
        }
    }
}

