/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.dialog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.tizen.manager.pkg.Component;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;

public class CustomComponentDisplayDialog
extends Dialog {
    public static final int YES = 0;
    public static final int NO = 1;
    private static final int DIALOG_WIDTH = 550;
    private static final int TOP_HEIGHT = 60;
    private static final int MID_HEIGHT = 239;
    private WizardUIResourceHandler uiRsrcHandler;
    private Composite bottomComposites;
    private Composite topComposites;
    private Composite mainComposites;
    private Composite middleComposites;
    private String message;
    private Map<String, Set<String>> displayMap = new HashMap<String, Set<String>>();

    public CustomComponentDisplayDialog(Shell parentShell, String message, ArrayList<Component> components) {
        super(parentShell);
        this.setShellStyle(67680);
        this.uiRsrcHandler = WizardUIResourceHandler.getInstance();
        CustomComponentDisplayDialog.setDefaultImage(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIIcon.ICON_MANAGER));
        this.message = message;
        for (Component component : components) {
            Set<Object> set;
            if (component.getRootComponent() == null || component.getRootComponent().equals(component)) continue;
            if (this.displayMap.containsKey(component.getRootComponent().getDisplayName())) {
                set = this.displayMap.get(component.getRootComponent().getDisplayName());
                set.add(component.getDisplayName());
                this.displayMap.remove(component.getRootComponent().getDisplayName());
                this.displayMap.put(component.getRootComponent().getDisplayName(), set);
                continue;
            }
            set = new HashSet<String>();
            set.add(component.getDisplayName());
            this.displayMap.put(component.getRootComponent().getDisplayName(), set);
        }
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        this.mainComposites = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginBottom = 0;
        gridLayout.verticalSpacing = 0;
        this.mainComposites.setLayout(gridLayout);
        this.mainComposites.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        GridData gd = new GridData();
        gd.widthHint = 550;
        gd.heightHint = 361;
        this.mainComposites.setLayoutData(gd);
        this.createTopComposites(this.mainComposites);
        this.createMiddleComposites(this.mainComposites);
        Label middleStroke = new Label(this.mainComposites, 0);
        GridData strokeGD = new GridData();
        strokeGD.widthHint = 550;
        strokeGD.heightHint = 1;
        middleStroke.setLayoutData(strokeGD);
        middleStroke.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_DARK_GRAY_AA));
        this.createBottomComposites(this.mainComposites);
        return this.mainComposites;
    }

    private void createTopComposites(Composite parent) {
        this.topComposites = new Composite(parent, 0);
        GridData gd = new GridData();
        gd.widthHint = 550;
        gd.heightHint = 60;
        this.topComposites.setLayoutData(gd);
        this.topComposites.setBackgroundMode(1);
        this.topComposites.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        this.topComposites.setLayout(gridLayout);
        Label title = new Label(this.topComposites, 64);
        title.setText(this.message);
        title.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        title.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_33));
        GridData titleGD = new GridData();
        titleGD.widthHint = 450;
        titleGD.verticalIndent = 17;
        titleGD.horizontalIndent = 20;
        title.setLayoutData(titleGD);
    }

    private void createMiddleComposites(Composite parent) {
        boolean needRepack = false;
        if (this.middleComposites != null) {
            this.middleComposites.dispose();
            needRepack = true;
        }
        this.middleComposites = new Composite(parent, 0);
        GridData gd = new GridData();
        gd.widthHint = 550;
        gd.heightHint = 239;
        this.middleComposites.setLayoutData(gd);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        this.middleComposites.setLayout(gridLayout);
        this.middleComposites.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        this.createComponentListContents(this.middleComposites);
        if (needRepack) {
            parent.layout();
        }
    }

    private void createBottomComposites(Composite parent) {
        this.bottomComposites = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, true);
        gd.verticalAlignment = 0x1000000;
        gd.horizontalAlignment = 131072;
        this.bottomComposites.setLayoutData(gd);
        this.bottomComposites.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        GridLayout buttonLayout = new GridLayout(2, true);
        buttonLayout.marginRight = 20;
        this.bottomComposites.setLayout(buttonLayout);
        Button btnAccept = new Button(this.bottomComposites, 8);
        gd = new GridData();
        gd.widthHint = 90;
        gd.heightHint = 25;
        btnAccept.setLayoutData(gd);
        btnAccept.setText("Yes");
        btnAccept.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_MIDDLE));
        btnAccept.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                CustomComponentDisplayDialog.this.okPressed();
            }
        });
        Button btnNo = new Button(this.bottomComposites, 8);
        gd = new GridData();
        gd.widthHint = 90;
        gd.heightHint = 25;
        btnNo.setLayoutData(gd);
        btnNo.setText("No");
        btnNo.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_MIDDLE));
        btnNo.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                CustomComponentDisplayDialog.this.cancelPressed();
            }
        });
    }

    private void createComponentListContents(Composite parent) {
        Composite outter = new Composite(parent, 2048);
        GridData gd = new GridData();
        gd.widthHint = 510;
        gd.heightHint = 199;
        gd.horizontalIndent = 20;
        gd.verticalIndent = 20;
        outter.setLayoutData(gd);
        outter.setLayout(new FillLayout());
        outter.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        ScrolledComposite scrolledComposite = new ScrolledComposite(outter, 512);
        gd = new GridData(4, 4, true, true);
        scrolledComposite.setLayoutData(gd);
        scrolledComposite.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        Composite container = new Composite(scrolledComposite, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginTop = 0;
        gl.marginBottom = 0;
        gl.marginLeft = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        container.setLayout(gl);
        container.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        gd = new GridData(4, 4, true, true);
        container.setLayoutData(gd);
        parent.setRedraw(false);
        Set<String> keySet = this.displayMap.keySet();
        ArrayList<String> list = new ArrayList<String>();
        for (String string : keySet) {
            list.add(string);
        }
        Collections.sort(list);
        int keyCount = 0;
        for (String key : list) {
            Composite titleOuter = new Composite(container, 0);
            gd = new GridData();
            gd.horizontalSpan = 0;
            gd.verticalIndent = 0;
            gd.grabExcessHorizontalSpace = true;
            gd.widthHint = 510;
            if (keyCount == 0) {
                gd.verticalIndent = 0;
                ++keyCount;
            } else {
                gd.verticalIndent = 7;
            }
            GridLayout gridLayout = new GridLayout(1, false);
            gridLayout.horizontalSpacing = 0;
            gridLayout.verticalSpacing = 0;
            gridLayout.marginLeft = 0;
            gridLayout.marginWidth = 0;
            titleOuter.setLayoutData(gd);
            titleOuter.setLayout(gridLayout);
            titleOuter.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
            Label titleText = new Label(titleOuter, 16384);
            titleText.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 1));
            titleText.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_58));
            titleText.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
            titleText.setText(key);
            GC gc = new GC(titleText);
            Point textExtent = gc.textExtent(key);
            gc.dispose();
            gd = new GridData();
            gd.heightHint = textExtent.y;
            gd.horizontalIndent = 25;
            gd.verticalIndent = 12 - textExtent.y / 2;
            gd.verticalAlignment = 0x1000000;
            titleText.setLayoutData(gd);
            Label dummy = new Label(titleOuter, 0);
            gd = new GridData();
            gd.heightHint = 12 - textExtent.y / 2 - 1;
            dummy.setLayoutData(gd);
            dummy.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
            Set<String> set = this.displayMap.get(key);
            int count = 0;
            for (String displayName : set) {
                Label componentName = new Label(container, 0);
                gd = new GridData();
                if (count == 0) {
                    gd.verticalIndent = 6;
                    ++count;
                } else {
                    gd.verticalIndent = 14;
                }
                gd.widthHint = 460;
                gd.horizontalIndent = 25;
                gc = new GC(titleText);
                textExtent = gc.textExtent(displayName);
                gc.dispose();
                gd.heightHint = textExtent.y;
                componentName.setLayoutData(gd);
                componentName.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
                componentName.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_DARK_GRAY_77));
                componentName.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
                componentName.setText("- " + displayName);
            }
        }
        scrolledComposite.setFocus();
        scrolledComposite.setContent(container);
        container.setSize(container.computeSize(-1, -1));
        scrolledComposite.setMinSize(container.computeSize(-1, -1));
        parent.setRedraw(true);
    }

    @Override
    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Package Manager");
    }

    @Override
    protected Control createButtonBar(Composite parent) {
        return null;
    }
}

