/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.page.monitor;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.Logger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.tizen.manager.core.ContentProvider;
import org.tizen.manager.core.ICommonProgressMonitor;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.pkg.Component;
import org.tizen.manager.svc.sdkutils.PackageInfoJSON;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.packagemanager.ui.dialog.NotifierDialog;
import org.tizen.packagemanager.ui.page.PackageManagerMainWindow;
import org.tizen.packagemanager.ui.page.ProgressTabView;
import org.tizen.packagemanager.ui.page.ViewController;

public class TotalProgressMonitor {
    private ProgressTabView parentView;
    private ArrayList<ICommonProgressMonitor> workingMonitors;
    private ArrayList<ICommonProgressMonitor> doneMonitors;
    private int currentPercent = 0;
    private double totalPercent = 0.0;
    private double totalSize = 0.0;
    private double startTime = 0.0;
    private Thread remainTimeThread = null;
    private static final int SEC = 1;
    private static final int MIN = 60;
    private static final int HOUR = 3600;
    private static final int TIME_DELAY = 500;
    private double remainTime = 0.0;
    private ContentProvider contentProvider;
    private ViewController viewController;
    private static final Logger logger = Log.getLogger(TotalProgressMonitor.class);

    public TotalProgressMonitor(ContentProvider contentProvider, ViewController viewController, ProgressTabView parentView) {
        this.contentProvider = contentProvider;
        this.viewController = viewController;
        this.parentView = parentView;
        this.workingMonitors = new ArrayList();
        this.doneMonitors = new ArrayList();
    }

    public void refreshTotalSize() {
        this.totalSize = 0.0;
        for (ICommonProgressMonitor monitor : this.workingMonitors) {
            this.totalSize += (double)monitor.getWorkingSize().longValue();
        }
    }

    public void begin(double startTime) {
        if (this.startTime == 0.0) {
            this.startTime = startTime;
        }
    }

    public void setRemainingTime() {
        if (this.remainTimeThread == null) {
            this.remainTimeThread = new Thread(){

                @Override
                public void run() {
                    while (!TotalProgressMonitor.this.isAllMonitorsDone()) {
                        if (Display.getDefault() != null && !Display.getDefault().isDisposed()) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    TotalProgressMonitor.this.updateRemainingTime();
                                }
                            });
                        }
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    TotalProgressMonitor.this.remainTimeThread = null;
                }
            };
            this.remainTimeThread.start();
        }
    }

    private synchronized void updateRemainingTime() {
        double remain = 100.0 - this.totalPercent;
        double past = (double)System.currentTimeMillis() - this.startTime;
        double tickAvg = this.totalPercent / (past / 1000.0);
        double calcTime = remain / tickAvg;
        this.remainTime = calcTime - this.remainTime >= 10.0 ? (this.remainTime += 10.0) : (calcTime - this.remainTime >= 2.0 ? (this.remainTime += 1.0) : (calcTime - this.remainTime <= -10.0 ? (this.remainTime -= 10.0) : (calcTime - this.remainTime <= -2.0 ? (this.remainTime -= 2.0) : calcTime)));
        this.parentView.setRemainTimeText(this.getRemainTimeString());
    }

    public synchronized void updateTotalWorked() {
        this.totalPercent = 0.0;
        for (ICommonProgressMonitor monitor : this.workingMonitors) {
            double ratePercent = (double)monitor.getWorkingSize().longValue() / this.totalSize * (double)monitor.getWorked();
            this.totalPercent += ratePercent;
        }
        if (this.isAllMonitorsDone()) {
            Shell shell;
            PackageManagerMainWindow win;
            NotifierDialog notiDlg = new NotifierDialog(this.viewController, this.parentView.getShell());
            String msg = "";
            HashMap<ICommonProgressMonitor.ProgressMonitorType, ArrayList<Component>> failMap = this.getFailedMapFromAllMonitors();
            if (failMap != null && !failMap.isEmpty()) {
                HashMap<ICommonProgressMonitor.ProgressMonitorType, ArrayList<Component>> map = failMap;
                for (Map.Entry entry : map.entrySet()) {
                    if (entry == null) continue;
                    ICommonProgressMonitor.ProgressMonitorType type = (ICommonProgressMonitor.ProgressMonitorType)((Object)entry.getKey());
                    ArrayList failList = (ArrayList)entry.getValue();
                    if (type == null || type == ICommonProgressMonitor.ProgressMonitorType.NONE || failList == null || failList.size() <= 0) continue;
                    if (this.contentProvider.getInstController().isAutomaticInstallation()) {
                        ErrorController.setExitCode(ErrorController.ExitCode.INSTALLATION_FAILED);
                        continue;
                    }
                    msg = "The installation/update has been failed,\nClick here to check the installation/update status.";
                    notiDlg.notify("Package Manager", msg, NotifierDialog.NotiType.FAIL);
                }
            } else {
                ArrayList<ICommonProgressMonitor.ProgressMonitorType> cancelTypeList = this.getCancelProgressTypeList();
                if (cancelTypeList != null && !cancelTypeList.isEmpty()) {
                    if (this.contentProvider.getInstController().isAutomaticInstallation()) {
                        ErrorController.setExitCode(ErrorController.ExitCode.CANCEL);
                    } else {
                        for (int i = 0; i < cancelTypeList.size(); ++i) {
                            String cancelMsg = cancelTypeList.get(i).getMessageIng();
                            if (cancelMsg.equals("Updating")) {
                                cancelMsg = "update";
                            }
                            if (cancelMsg.equals("Installing")) {
                                cancelMsg = "installation";
                            }
                            if (cancelMsg.equals("Removing")) {
                                cancelMsg = "removal";
                            }
                            msg = String.format("The %s has been canceled,%nClick here to check the %s status.", cancelMsg, cancelMsg);
                            notiDlg.notify("Package Manager", msg, NotifierDialog.NotiType.CANCEL);
                        }
                    }
                } else {
                    ArrayList<ICommonProgressMonitor.ProgressMonitorType> successTypeList = this.getSuccessProgressTypeList();
                    if (successTypeList != null && !successTypeList.isEmpty()) {
                        if (this.contentProvider.getInstController().isAutomaticInstallation()) {
                            ErrorController.setExitCode(ErrorController.ExitCode.NORMAL);
                        } else {
                            for (int i = 0; i < successTypeList.size(); ++i) {
                                String successMsg = successTypeList.get(i).getMessageIng();
                                if (successMsg.equals("Updating")) {
                                    successMsg = "update";
                                }
                                if (successMsg.equals("Installing")) {
                                    successMsg = "installation";
                                }
                                if (successMsg.equals("Removing")) {
                                    successMsg = "removal";
                                }
                                msg = String.format("The %s has been completed successfully.", successMsg);
                                notiDlg.notify("Package Manager", msg, NotifierDialog.NotiType.SUCCESS);
                            }
                        }
                    }
                }
            }
            this.totalWorked(100);
            this.refresh();
            if (PlatformUtil.isWindows()) {
                this.RegistryEntry();
            }
            this.contentProvider.getInstController().getDownloadMgr().clearMap();
            if (!this.contentProvider.getPkgMgr().getInstalledPackages().isEmpty() && !this.contentProvider.getPkgMgr().getRepoPackages().isEmpty()) {
                PackageInfoJSON.savePackageInfoToFile(this.contentProvider.getSDKInfo(), this.contentProvider.getPkgMgr());
            }
            if (this.contentProvider.getInstController().isAutomaticInstallation() && (win = PackageManagerMainWindow.getPackageManagerWindow()) != null && (shell = win.getShell()) != null) {
                shell.setVisible(false);
            }
        } else {
            this.totalWorked((int)this.totalPercent);
        }
    }

    private void RegistryEntry() {
        String uninstallKey = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\TizenStudio";
        String finalSdkLocation = this.contentProvider.getConfig().getTargetDir();
        try {
            Advapi32Util.registryCreateKey(WinReg.HKEY_CURRENT_USER, uninstallKey);
            Advapi32Util.registrySetStringValue(WinReg.HKEY_CURRENT_USER, uninstallKey, "DisplayName", "Tizen Studio");
            Advapi32Util.registrySetStringValue(WinReg.HKEY_CURRENT_USER, uninstallKey, "DisplayVersion", this.tsVersionReader());
            Advapi32Util.registrySetStringValue(WinReg.HKEY_CURRENT_USER, uninstallKey, "Publisher", "Samsung Electronics Co. Ltd.");
            Advapi32Util.registrySetStringValue(WinReg.HKEY_CURRENT_USER, uninstallKey, "InstallLocation", finalSdkLocation);
            Advapi32Util.registrySetStringValue(WinReg.HKEY_CURRENT_USER, uninstallKey, "UninstallString", finalSdkLocation + "\\package-manager\\uninstaller.exe");
            Advapi32Util.registrySetStringValue(WinReg.HKEY_CURRENT_USER, uninstallKey, "DisplayIcon", finalSdkLocation + "\\ide\\resources\\icons\\tizen_studio.ico");
            logger.trace("Registry entry successfully updated with SDK location: " + finalSdkLocation);
        }
        catch (Exception ex) {
            logger.error("Failed to update Tizen Studio in registry.");
        }
    }

    private String tsVersionReader() {
        String directoryPath = this.contentProvider.getConfig().getTargetDir() + "\\ide\\plugins";
        String latestPlugin = null;
        File directory = new File(directoryPath);
        if (directory.exists() && directory.isDirectory()) {
            File[] files = directory.listFiles();
            ArrayList<String> pluginFolders = new ArrayList<String>();
            if (files != null) {
                for (File file : files) {
                    if (!file.isDirectory() || !file.getName().startsWith("org.tizen.product.plugin")) continue;
                    pluginFolders.add(file.getName());
                }
                Collections.sort(pluginFolders, Collections.reverseOrder());
                latestPlugin = (String)pluginFolders.get(0);
            } else {
                logger.trace(directoryPath + " is empty or an error occurred.");
            }
        } else {
            logger.trace(directoryPath + " is not a directory or does not exist.");
        }
        String mAboutMappingsFile = directoryPath + "\\" + latestPlugin + "\\about.mappings";
        String mTsVersion = null;
        try (FileInputStream inputStream = new FileInputStream(mAboutMappingsFile);){
            Properties properties = new Properties();
            properties.load(inputStream);
            mTsVersion = properties.getProperty("1");
            if (mTsVersion != null) {
                logger.trace("Version{1}: " + mTsVersion);
            } else {
                logger.trace("key 1 not found in about.mappings");
            }
        }
        catch (IOException e) {
            logger.error("Error reading the about.mappings file: " + e.getMessage());
        }
        if (mTsVersion == null) {
            logger.trace("Retrieved TS version is null");
        } else {
            logger.trace("Retrieved TS version is: " + mTsVersion);
        }
        return mTsVersion;
    }

    private String getRemainTimeString() {
        String remainTimeStr = "";
        int remainTimeInt = (int)Math.ceil(this.remainTime);
        int hour = remainTimeInt / 3600;
        int min = (remainTimeInt - hour * 3600) / 60;
        int sec = (remainTimeInt - hour * 3600 - min * 60) / 1;
        remainTimeStr = String.format("%02d:%02d:%02d", hour, min, sec);
        return remainTimeStr;
    }

    public void totalWorked(int percent) {
        this.currentPercent = percent;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                TotalProgressMonitor.this.parentView.getMainWindow().getProgressBar().setProgress(TotalProgressMonitor.this.currentPercent);
            }
        });
    }

    public void addWorkingMonitor(ICommonProgressMonitor monitor) {
        this.workingMonitors.add(monitor);
    }

    public void addDoneMonitor(ICommonProgressMonitor monitor) {
        this.doneMonitors.add(monitor);
    }

    private boolean isAllMonitorsDone() {
        for (ICommonProgressMonitor monitor : this.workingMonitors) {
            if (monitor.isDone()) continue;
            return false;
        }
        return true;
    }

    private HashMap<ICommonProgressMonitor.ProgressMonitorType, ArrayList<Component>> getFailedMapFromAllMonitors() {
        HashMap<ICommonProgressMonitor.ProgressMonitorType, ArrayList<Component>> failMap = new HashMap<ICommonProgressMonitor.ProgressMonitorType, ArrayList<Component>>();
        for (ICommonProgressMonitor monitor : this.workingMonitors) {
            if (!monitor.isFailed()) continue;
            Component component = monitor.getComponent();
            ICommonProgressMonitor.ProgressMonitorType type = monitor.getProgressMonitorType();
            if (component == null || type == ICommonProgressMonitor.ProgressMonitorType.NONE) continue;
            ArrayList<Object> failList = null;
            failList = failMap.containsKey((Object)type) ? failMap.get((Object)type) : new ArrayList();
            failList.add(component);
            failMap.put(type, failList);
        }
        return failMap;
    }

    private ArrayList<ICommonProgressMonitor.ProgressMonitorType> getCancelProgressTypeList() {
        ArrayList<ICommonProgressMonitor.ProgressMonitorType> cancelTypeList = new ArrayList<ICommonProgressMonitor.ProgressMonitorType>();
        for (ICommonProgressMonitor monitor : this.workingMonitors) {
            if (!monitor.isCanceled() || cancelTypeList.contains((Object)monitor.getProgressMonitorType())) continue;
            cancelTypeList.add(monitor.getProgressMonitorType());
        }
        return cancelTypeList;
    }

    private ArrayList<ICommonProgressMonitor.ProgressMonitorType> getSuccessProgressTypeList() {
        ArrayList<ICommonProgressMonitor.ProgressMonitorType> successTypeList = new ArrayList<ICommonProgressMonitor.ProgressMonitorType>();
        for (ICommonProgressMonitor monitor : this.workingMonitors) {
            if (monitor.isCanceled() || monitor.isFailed() || successTypeList.contains((Object)monitor.getProgressMonitorType())) continue;
            successTypeList.add(monitor.getProgressMonitorType());
        }
        return successTypeList;
    }

    public synchronized void refresh() {
        this.workingMonitors.clear();
        this.totalSize = 0.0;
        this.startTime = 0.0;
        this.totalPercent = 0.0;
        this.remainTime = 0.0;
        this.parentView.setRemainTimeText("00:00:00");
    }

    public boolean isDone() {
        return this.isAllMonitorsDone();
    }
}

