#!/bin/bash -x

APPLICATIONS_DIR=
TARGET_DIR=
TARGET_APP_PATH=
INSTALLED_DIR_NAME=
APP_NAME=

parseParameter()
{
	while [ $# -gt 0 ]
	do
		case $1 in
			-t|--targetDir)
				shift
				APPLICATIONS_DIR="$1"
				;;
			-in|--installedDirName)
				shift
				INSTALLED_DIR_NAME="$1"
				;;
			-s|--installedAppDir)
				shift
				TARGET_APP_PATH="$1"
				;;
			-n|--name)
				shift
				APP_NAME="$1"
				;;
			*)
				exit 12
				;;
		esac
		shift
	done
}
parseParameter "$@"

# Check Application directory
if [ "$APPLICATIONS_DIR" = "" ]; then
	if [ -e "${HOME}/Applications" ]; then
		APPLICATIONS_DIR="${HOME}/Applications"
	else
		APPLICATIONS_DIR="/Applications"
	fi
fi

# Check group name
if [ "$INSTALLED_DIR_NAME" != "" ]; then
	TARGET_DIR="$APPLICATIONS_DIR/$INSTALLED_DIR_NAME"
else
	TARGET_DIR="$APPLICATIONS_DIR"
fi

if [ ! -e "${TARGET_DIR}" ]; then
	mkdir -p "${TARGET_DIR}"
fi

# Check alias name
if [ "$APP_NAME" = "" ]; then
	APP_NAME=`basename "$TARGET_APP_PATH"| cut -d '.' -f1`
fi

# If already exists, remove
if [ -e "$TARGET_DIR/$APP_NAME" ]; then
	rm -rf "$TARGET_DIR/$APP_NAME"
fi

for entry in ${TARGET_DIR}/*
do
	echo $entry
    # Redirect stderr to dev null to suppress OSA environment errors
    exec 6>&2 # Link file descriptor 6 with stderr so we can restore stderr later
    exec 2>/dev/null # stderr replaced by /dev/null
    path=$(osascript << EOF
tell application "Finder"
set theItem to (POSIX file "${entry}") as alias
if the kind of theItem is "alias" then
get the posix path of ((original item of theItem) as text)
end if
end tell
EOF
)
exec 2>&6 6>&-      # Restore stderr and close file descriptor #6.
echo "$path"
	if [ "$TARGET_APP_PATH" == "$path" ]; then
		rm -rf "${entry}"
	fi

done


osascript <<END
tell application "Finder"
    make new alias at POSIX file "$TARGET_DIR" to POSIX file "$TARGET_APP_PATH" with properties {name: "$APP_NAME"}
end tell

END
