/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.cli;

import java.util.ArrayList;
import org.tizen.manager.core.ICommonProgressMonitor;
import org.tizen.manager.exception.ProgressLog;
import org.tizen.manager.pkg.Component;
import org.tizen.manager.util.Log;

class CLIInstallUpdateProcessMonitor
implements ICommonProgressMonitor {
    private boolean isCanceled = false;
    private boolean isDone = false;
    private int currentWorked = 0;
    private Long workingSize = 0L;
    private Component component;
    private boolean isFirst = true;
    private int printCount = 0;
    private Exception err = null;
    private ICommonProgressMonitor.ProgressMonitorType progressMonitorType = ICommonProgressMonitor.ProgressMonitorType.NONE;
    private ArrayList<ICommonProgressMonitor> group;

    public CLIInstallUpdateProcessMonitor(Component component, ICommonProgressMonitor.ProgressMonitorType progressMonitorType) {
        Log.getLogger(CLIInstallUpdateProcessMonitor.class);
        this.group = new ArrayList();
        this.group.add(this);
        this.component = component;
        this.progressMonitorType = progressMonitorType;
    }

    @Override
    public void beginTask(String arg0, int totalWork) {
    }

    @Override
    public void done() {
        this.isDone = true;
        this.worked(100);
        System.out.println("]");
    }

    @Override
    public boolean isCanceled() {
        return this.isCanceled;
    }

    @Override
    public void setCanceled(boolean value) {
        this.isCanceled = value;
    }

    @Override
    public void worked(int work) {
        int currentCount;
        this.currentWorked = work;
        if (this.isFirst) {
            this.isFirst = false;
            System.out.println("[" + this.component.getPackageName() + "] \n0% [----------------------------------------] 100 %");
            System.out.print("   [");
        }
        if ((currentCount = this.currentWorked * 2 / 5) > this.printCount) {
            for (int i = 0; i < currentCount - this.printCount; ++i) {
                System.out.print("+");
            }
            this.printCount = currentCount;
        }
    }

    @Override
    public void init() {
    }

    @Override
    public void setError(Exception err) {
        this.err = err;
    }

    @Override
    public Exception getError() {
        return this.err;
    }

    @Override
    public void setCancelable(boolean b) {
    }

    @Override
    public int getWorked() {
        return this.currentWorked;
    }

    @Override
    public void setProgress(String msg) {
    }

    @Override
    public void setProgress(String msg, ProgressLog.LogType type) {
    }

    @Override
    public void setMonitorGroup(ArrayList<ICommonProgressMonitor> monitorGroup) {
        this.group = monitorGroup;
    }

    @Override
    public ArrayList<ICommonProgressMonitor> getMonitorGroup() {
        return this.group;
    }

    @Override
    public void setWorkingSize(Long size) {
        this.workingSize = size;
    }

    @Override
    public Long getWorkingSize() {
        return this.workingSize;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    @Override
    public boolean isCancelable() {
        return false;
    }

    @Override
    public boolean isFailed() {
        return false;
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public ICommonProgressMonitor.ProgressMonitorType getProgressMonitorType() {
        return this.progressMonitorType;
    }

    @Override
    public boolean isPause() {
        return false;
    }

    @Override
    public void setPause(boolean b) {
    }
}

