/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.Authenticator;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.tizen.manager.core.CompatController;
import org.tizen.manager.core.ContentProvider;
import org.tizen.manager.core.ExtRepositoryManager;
import org.tizen.manager.core.Performance;
import org.tizen.manager.core.SelfUpdater;
import org.tizen.manager.core.model.ExtensionInformation;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.mac.CocoaUtil;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PathUtil;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.manager.util.ProgramController;
import org.tizen.manager.util.Tools;
import org.tizen.packagemanager.ui.RemoteLogger;
import org.tizen.packagemanager.ui.UIMainOptions;
import org.tizen.packagemanager.ui.UIProxyAuthenticator;
import org.tizen.packagemanager.ui.exception.InsideTroubleShootingDialog;
import org.tizen.packagemanager.ui.page.PackageManagerMainWindow;
import org.tizen.packagemanager.ui.page.custom.CallableWithMonitor;
import org.tizen.packagemanager.ui.page.custom.CustomMessageDialog;
import org.tizen.packagemanager.ui.page.custom.CustomProgressDialog;
import org.tizen.packagemanager.ui.util.UIUtil;

public class UIMain {
    private static Logger logger = null;
    private static PackageManagerMainWindow window;
    private static Shell shell;
    private static ContentProvider contentProvider;
    private static boolean isInitialized;
    private static final String PRODUCT_NAME = "Package Manager";
    private static long startTime;
    private static long endTime;
    private static long usage;

    static void obtainLockFile() {
        boolean ret;
        RandomAccessFile randomAccessFile = null;
        String errorMessage = "";
        String PKGMGR_DIR = "package-manager" + File.separator + "temp";
        String DATA_DIR = contentProvider.getSDKInfo().getSdkDataPath();
        String TEMP_DIR = DATA_DIR + File.separator + PKGMGR_DIR;
        File file = new File(TEMP_DIR);
        if (!(file.exists() || (ret = file.mkdirs()) || file.exists())) {
            logger.error("Failed to create directory");
        }
        try {
            randomAccessFile = new RandomAccessFile(new File(TEMP_DIR + File.separator + ".pm-" + System.getProperty("user.name")) + ".lock", "rw");
        }
        catch (FileNotFoundException e) {
            errorMessage = "The Package Manager cannot be launched" + System.getProperty("line.separator") + e.getMessage();
        }
        if (randomAccessFile != null && errorMessage.isEmpty()) {
            try {
                FileLock lock = randomAccessFile.getChannel().tryLock();
                if (lock == null) {
                    errorMessage = "The Package Manager cannot be launched" + System.getProperty("line.separator") + "because it is already in use.";
                }
            }
            catch (IOException e) {
                errorMessage = "The Package Manager cannot be launched" + System.getProperty("line.separator") + e.getMessage();
            }
        }
        if (!errorMessage.isEmpty()) {
            CustomMessageDialog.showDlg(new Shell(Display.getDefault(), 16384), "Error", String.format("You cannot launch the Package Manager because the %s is still running.%nTo launch the Package Manager, close first another Package Manager and try it again.", ProgramController.PROG_NAME_MANAGER), CustomMessageDialog.DialogType.ERROR, true);
            System.exit(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        block163: {
            block161: {
                block160: {
                    block158: {
                        block159: {
                            block157: {
                                UIMain.startTime = System.currentTimeMillis() / 1000L;
                                Runtime.getRuntime().addShutdownHook(new Thread(){

                                    @Override
                                    public void run() {
                                    }
                                });
                                Performance.setIMStartTime();
                                Log.open();
                                Log.logTitle("Package Manager start");
                                Log.logInfo(PlatformUtil.getPlatformInfo());
                                Log.logInfo("Directory of running Installer : " + PathUtil.getCurrentDir());
                                UIMain.logger = Log.getLogger(UIMain.class);
                                UIMain.initializeDisplay();
                                exitCode = 0;
                                UIMain.contentProvider = new ContentProvider();
                                UIMain.logger.trace("Command line options => " + Arrays.toString(args));
                                UIMainOptions.loadCmdArgs(args);
                                if (UIMainOptions.noJavaVersionCheck || UIUtil.checkJavaRuntime(false)) break block157;
                                UIMain.endTime = System.currentTimeMillis() / 1000L;
                                UIMain.usage = UIMain.endTime - UIMain.startTime;
                                RemoteLogger.logUsage("Package Manager", UIMain.usage);
                                Performance.summarize();
                                UIMain.finalizeUIMain();
                                Log.logTitle("Package Manager was terminated!");
                                if (UIMainOptions.automaticInstallation) {
                                    errCode = ErrorController.getExitCode();
                                    Log.logInfo("auto exit: " + errCode.getValue());
                                    if (UIMainOptions.callerTool != null) {
                                        dlgShell = new Shell(Display.getDefault());
                                        toolRun = true;
                                        if (errCode == ErrorController.ExitCode.SELF_UPDATE) {
                                            toolRun = false;
                                        } else if (errCode == ErrorController.ExitCode.NETWORK_ERROR) {
                                            InsideTroubleShootingDialog.open(dlgShell, new UMException(ErrorController.ErrorCode.CANNOT_CONNECT_REPOSITORY));
                                        } else if (errCode == ErrorController.ExitCode.INSTALLATION_FAILED) {
                                            InsideTroubleShootingDialog.open(dlgShell, new UMException(ErrorController.ErrorCode.FAILED_TO_INSTALL_AUTO));
                                        } else {
                                            msg = String.format("The %s is launching in ", new Object[]{UIMainOptions.callerTool.getDisplayName()});
                                            CustomMessageDialog.showDlg(dlgShell, "Installation is complete.", msg, CustomMessageDialog.DialogType.INFO, true, true, 5);
                                        }
                                        if (toolRun) {
                                            Tools.runTizenTools(UIMain.contentProvider, UIMainOptions.callerTool);
                                        }
                                        if (dlgShell != null) {
                                            dlgShell.close();
                                        }
                                    }
                                    try {
                                        if (UIMain.shell != null) {
                                            UIMain.shell.close();
                                        }
                                        UIUtil.disposeDisplay();
                                    }
                                    catch (Exception dlgShell) {
                                        // empty catch block
                                    }
                                    System.exit(errCode.getValue());
                                } else {
                                    try {
                                        if (UIMain.shell != null) {
                                            UIMain.shell.close();
                                        }
                                        UIUtil.disposeDisplay();
                                    }
                                    catch (Exception errCode) {
                                        // empty catch block
                                    }
                                    Log.logInfo("exit: " + exitCode);
                                    System.exit(exitCode);
                                }
                                return;
                            }
                            if (PlatformUtil.isMacOS()) {
                                UIMain.logger.trace("Initializing MAC Application...");
                                UIMain.initializeAppForMacOS();
                            }
                            UIMain.contentProvider.getSDKInfo().init();
                            UIMain.contentProvider.getSDKInfo().save(true);
                            pmInstances = 0;
                            if (UIMainOptions.noDuplicateCheck) break block158;
                            UIMain.obtainLockFile();
                            controller = ProgramController.createProgramController(UIMain.contentProvider.getSDKInfo());
                            sdkProcessList = controller.getSDKProcessList();
                            instanceName = "";
                            for (Object progName : sdkProcessList) {
                                if (!progName.equals(ProgramController.PROG_NAME_MANAGER) && !progName.equals(ProgramController.PROG_NAME_MANAGER_CLI) && !progName.equals(ProgramController.PROG_NAME_UNINSTALLER)) continue;
                                ++pmInstances;
                                if (!progName.equals(ProgramController.PROG_NAME_MANAGER)) {
                                    instanceName = progName;
                                    continue;
                                }
                                if (!instanceName.equals("")) continue;
                                instanceName = progName;
                            }
                            if (pmInstances != 2) ** GOTO lbl155
                            showDlg = 0;
                            do {
                                if ((showDlg = CustomMessageDialog.showDlg(new Shell(Display.getDefault(), 16384), "Warning", String.format("You cannot launch the Package Manager because the %s is still running.%nTo launch the Package Manager, close first another Package Manager and try it again.", new Object[]{instanceName}), CustomMessageDialog.DialogType.WARNING, false)) != 64) continue;
                                pmInstances = 0;
                                sdkProcessList = controller.getSDKProcessList();
                                instanceName = "";
                                for (String progName : sdkProcessList) {
                                    if (!progName.equals(ProgramController.PROG_NAME_MANAGER) && !progName.equals(ProgramController.PROG_NAME_MANAGER_CLI) && !progName.equals(ProgramController.PROG_NAME_UNINSTALLER)) continue;
                                    ++pmInstances;
                                    if (!progName.equals(ProgramController.PROG_NAME_MANAGER)) {
                                        instanceName = progName;
                                        continue;
                                    }
                                    if (!instanceName.equals("")) continue;
                                    instanceName = progName;
                                }
                            } while (showDlg == 64 && pmInstances > 1);
                            if (showDlg == 64) break block159;
                            UIMain.endTime = System.currentTimeMillis() / 1000L;
                            UIMain.usage = UIMain.endTime - UIMain.startTime;
                            RemoteLogger.logUsage("Package Manager", UIMain.usage);
                            Performance.summarize();
                            UIMain.finalizeUIMain();
                            Log.logTitle("Package Manager was terminated!");
                            if (UIMainOptions.automaticInstallation) {
                                errCode = ErrorController.getExitCode();
                                Log.logInfo("auto exit: " + errCode.getValue());
                                if (UIMainOptions.callerTool != null) {
                                    dlgShell = new Shell(Display.getDefault());
                                    toolRun = true;
                                    if (errCode == ErrorController.ExitCode.SELF_UPDATE) {
                                        toolRun = false;
                                    } else if (errCode == ErrorController.ExitCode.NETWORK_ERROR) {
                                        InsideTroubleShootingDialog.open(dlgShell, new UMException(ErrorController.ErrorCode.CANNOT_CONNECT_REPOSITORY));
                                    } else if (errCode == ErrorController.ExitCode.INSTALLATION_FAILED) {
                                        InsideTroubleShootingDialog.open(dlgShell, new UMException(ErrorController.ErrorCode.FAILED_TO_INSTALL_AUTO));
                                    } else {
                                        msg = String.format("The %s is launching in ", new Object[]{UIMainOptions.callerTool.getDisplayName()});
                                        CustomMessageDialog.showDlg(dlgShell, "Installation is complete.", msg, CustomMessageDialog.DialogType.INFO, true, true, 5);
                                    }
                                    if (toolRun) {
                                        Tools.runTizenTools(UIMain.contentProvider, UIMainOptions.callerTool);
                                    }
                                    if (dlgShell != null) {
                                        dlgShell.close();
                                    }
                                }
                                try {
                                    if (UIMain.shell != null) {
                                        UIMain.shell.close();
                                    }
                                    UIUtil.disposeDisplay();
                                }
                                catch (Exception dlgShell) {
                                    // empty catch block
                                }
                                System.exit(errCode.getValue());
                            } else {
                                try {
                                    if (UIMain.shell != null) {
                                        UIMain.shell.close();
                                    }
                                    UIUtil.disposeDisplay();
                                }
                                catch (Exception errCode) {
                                    // empty catch block
                                }
                                Log.logInfo("exit: " + exitCode);
                                System.exit(exitCode);
                            }
                            return;
                        }
                        break block158;
lbl155:
                        // 1 sources

                        if (pmInstances <= 2) break block158;
                        UIMain.endTime = System.currentTimeMillis() / 1000L;
                        UIMain.usage = UIMain.endTime - UIMain.startTime;
                        RemoteLogger.logUsage("Package Manager", UIMain.usage);
                        Performance.summarize();
                        UIMain.finalizeUIMain();
                        Log.logTitle("Package Manager was terminated!");
                        if (UIMainOptions.automaticInstallation) {
                            errCode = ErrorController.getExitCode();
                            Log.logInfo("auto exit: " + errCode.getValue());
                            if (UIMainOptions.callerTool != null) {
                                dlgShell = new Shell(Display.getDefault());
                                toolRun = true;
                                if (errCode == ErrorController.ExitCode.SELF_UPDATE) {
                                    toolRun = false;
                                } else if (errCode == ErrorController.ExitCode.NETWORK_ERROR) {
                                    InsideTroubleShootingDialog.open(dlgShell, new UMException(ErrorController.ErrorCode.CANNOT_CONNECT_REPOSITORY));
                                } else if (errCode == ErrorController.ExitCode.INSTALLATION_FAILED) {
                                    InsideTroubleShootingDialog.open(dlgShell, new UMException(ErrorController.ErrorCode.FAILED_TO_INSTALL_AUTO));
                                } else {
                                    msg = String.format("The %s is launching in ", new Object[]{UIMainOptions.callerTool.getDisplayName()});
                                    CustomMessageDialog.showDlg(dlgShell, "Installation is complete.", msg, CustomMessageDialog.DialogType.INFO, true, true, 5);
                                }
                                if (toolRun) {
                                    Tools.runTizenTools(UIMain.contentProvider, UIMainOptions.callerTool);
                                }
                                if (dlgShell != null) {
                                    dlgShell.close();
                                }
                            }
                            try {
                                if (UIMain.shell != null) {
                                    UIMain.shell.close();
                                }
                                UIUtil.disposeDisplay();
                            }
                            catch (Exception dlgShell) {
                                // empty catch block
                            }
                            System.exit(errCode.getValue());
                        } else {
                            try {
                                if (UIMain.shell != null) {
                                    UIMain.shell.close();
                                }
                                UIUtil.disposeDisplay();
                            }
                            catch (Exception errCode) {
                                // empty catch block
                            }
                            Log.logInfo("exit: " + exitCode);
                            System.exit(exitCode);
                        }
                        return;
                    }
                    selfUpdateNeeded = UIMain.initialize(args);
                    UIMain.isInitialized = true;
                    if (!selfUpdateNeeded) break block160;
                    ErrorController.setExitCode(ErrorController.ExitCode.SELF_UPDATE);
                    UIMain.endTime = System.currentTimeMillis() / 1000L;
                    UIMain.usage = UIMain.endTime - UIMain.startTime;
                    RemoteLogger.logUsage("Package Manager", UIMain.usage);
                    Performance.summarize();
                    UIMain.finalizeUIMain();
                    Log.logTitle("Package Manager was terminated!");
                    if (UIMainOptions.automaticInstallation) {
                        errCode = ErrorController.getExitCode();
                        Log.logInfo("auto exit: " + errCode.getValue());
                        if (UIMainOptions.callerTool != null) {
                            dlgShell = new Shell(Display.getDefault());
                            toolRun = true;
                            if (errCode == ErrorController.ExitCode.SELF_UPDATE) {
                                toolRun = false;
                            } else if (errCode == ErrorController.ExitCode.NETWORK_ERROR) {
                                InsideTroubleShootingDialog.open(dlgShell, new UMException(ErrorController.ErrorCode.CANNOT_CONNECT_REPOSITORY));
                            } else if (errCode == ErrorController.ExitCode.INSTALLATION_FAILED) {
                                InsideTroubleShootingDialog.open(dlgShell, new UMException(ErrorController.ErrorCode.FAILED_TO_INSTALL_AUTO));
                            } else {
                                msg = String.format("The %s is launching in ", new Object[]{UIMainOptions.callerTool.getDisplayName()});
                                CustomMessageDialog.showDlg(dlgShell, "Installation is complete.", msg, CustomMessageDialog.DialogType.INFO, true, true, 5);
                            }
                            if (toolRun) {
                                Tools.runTizenTools(UIMain.contentProvider, UIMainOptions.callerTool);
                            }
                            if (dlgShell != null) {
                                dlgShell.close();
                            }
                        }
                        try {
                            if (UIMain.shell != null) {
                                UIMain.shell.close();
                            }
                            UIUtil.disposeDisplay();
                        }
                        catch (Exception dlgShell) {
                            // empty catch block
                        }
                        System.exit(errCode.getValue());
                    } else {
                        try {
                            if (UIMain.shell != null) {
                                UIMain.shell.close();
                            }
                            UIUtil.disposeDisplay();
                        }
                        catch (Exception errCode) {
                            // empty catch block
                        }
                        Log.logInfo("exit: " + exitCode);
                        System.exit(exitCode);
                    }
                    return;
                }
                RemoteLogger.logAccess("Package Manager");
                if (!UIUtil.compatUninstaller(UIMain.contentProvider)) break block161;
                UIMain.endTime = System.currentTimeMillis() / 1000L;
                UIMain.usage = UIMain.endTime - UIMain.startTime;
                RemoteLogger.logUsage("Package Manager", UIMain.usage);
                Performance.summarize();
                UIMain.finalizeUIMain();
                Log.logTitle("Package Manager was terminated!");
                if (UIMainOptions.automaticInstallation) {
                    errCode = ErrorController.getExitCode();
                    Log.logInfo("auto exit: " + errCode.getValue());
                    if (UIMainOptions.callerTool != null) {
                        dlgShell = new Shell(Display.getDefault());
                        toolRun = true;
                        if (errCode == ErrorController.ExitCode.SELF_UPDATE) {
                            toolRun = false;
                        } else if (errCode == ErrorController.ExitCode.NETWORK_ERROR) {
                            InsideTroubleShootingDialog.open(dlgShell, new UMException(ErrorController.ErrorCode.CANNOT_CONNECT_REPOSITORY));
                        } else if (errCode == ErrorController.ExitCode.INSTALLATION_FAILED) {
                            InsideTroubleShootingDialog.open(dlgShell, new UMException(ErrorController.ErrorCode.FAILED_TO_INSTALL_AUTO));
                        } else {
                            msg = String.format("The %s is launching in ", new Object[]{UIMainOptions.callerTool.getDisplayName()});
                            CustomMessageDialog.showDlg(dlgShell, "Installation is complete.", msg, CustomMessageDialog.DialogType.INFO, true, true, 5);
                        }
                        if (toolRun) {
                            Tools.runTizenTools(UIMain.contentProvider, UIMainOptions.callerTool);
                        }
                        if (dlgShell != null) {
                            dlgShell.close();
                        }
                    }
                    try {
                        if (UIMain.shell != null) {
                            UIMain.shell.close();
                        }
                        UIUtil.disposeDisplay();
                    }
                    catch (Exception dlgShell) {
                        // empty catch block
                    }
                    System.exit(errCode.getValue());
                } else {
                    try {
                        if (UIMain.shell != null) {
                            UIMain.shell.close();
                        }
                        UIUtil.disposeDisplay();
                    }
                    catch (Exception errCode) {
                        // empty catch block
                    }
                    Log.logInfo("exit: " + exitCode);
                    System.exit(exitCode);
                }
                return;
            }
            try {
                if (UIMainOptions.automaticInstallation) {
                    UIMain.contentProvider.getInstController().setAutomaticInstallation(UIMainOptions.automaticInstallation);
                    UIMain.contentProvider.getInstController().setAutomaticInstallationPackages(UIMainOptions.packages);
                }
                UIMain.window = new PackageManagerMainWindow(UIMain.contentProvider);
                UIMain.window.run();
                UIMain.shell = UIMain.window.getShell();
                if (!UIMain.shell.isDisposed()) {
                    UIMain.shell.pack();
                    UIMain.shell.open();
                }
                while (!UIMain.shell.isDisposed() && UIMain.shell.isVisible()) {
                    try {
                        if (UIMain.shell.getDisplay().readAndDispatch()) continue;
                        UIMain.shell.getDisplay().sleep();
                    }
                    catch (Throwable e) {
                        UIMain.logger.throwing(e);
                    }
                }
                UIMain.logger.info("after install manager window init");
            }
            catch (Throwable e) {
                block162: {
                    try {
                        UIMain.logger.throwing(e);
                        if (UIMainOptions.automaticInstallation) break block162;
                        if (e instanceof Exception) {
                            InsideTroubleShootingDialog.open(new Shell(Display.getDefault()), (Exception)e);
                        } else {
                            UIUtil.showErrorMessage(e.getMessage());
                        }
                        exitCode = 4;
                    }
                    catch (Throwable var11_43) {
                        UIMain.endTime = System.currentTimeMillis() / 1000L;
                        UIMain.usage = UIMain.endTime - UIMain.startTime;
                        RemoteLogger.logUsage("Package Manager", UIMain.usage);
                        Performance.summarize();
                        UIMain.finalizeUIMain();
                        Log.logTitle("Package Manager was terminated!");
                        if (UIMainOptions.automaticInstallation) {
                            errCode = ErrorController.getExitCode();
                            Log.logInfo("auto exit: " + errCode.getValue());
                            if (UIMainOptions.callerTool != null) {
                                dlgShell = new Shell(Display.getDefault());
                                toolRun = true;
                                if (errCode == ErrorController.ExitCode.SELF_UPDATE) {
                                    toolRun = false;
                                } else if (errCode == ErrorController.ExitCode.NETWORK_ERROR) {
                                    InsideTroubleShootingDialog.open(dlgShell, new UMException(ErrorController.ErrorCode.CANNOT_CONNECT_REPOSITORY));
                                } else if (errCode == ErrorController.ExitCode.INSTALLATION_FAILED) {
                                    InsideTroubleShootingDialog.open(dlgShell, new UMException(ErrorController.ErrorCode.FAILED_TO_INSTALL_AUTO));
                                } else {
                                    msg = String.format("The %s is launching in ", new Object[]{UIMainOptions.callerTool.getDisplayName()});
                                    CustomMessageDialog.showDlg(dlgShell, "Installation is complete.", msg, CustomMessageDialog.DialogType.INFO, true, true, 5);
                                }
                                if (toolRun) {
                                    Tools.runTizenTools(UIMain.contentProvider, UIMainOptions.callerTool);
                                }
                                if (dlgShell != null) {
                                    dlgShell.close();
                                }
                            }
                            try {
                                if (UIMain.shell != null) {
                                    UIMain.shell.close();
                                }
                                UIUtil.disposeDisplay();
                            }
                            catch (Exception var13_47) {
                                // empty catch block
                            }
                            System.exit(errCode.getValue());
                        } else {
                            try {
                                if (UIMain.shell != null) {
                                    UIMain.shell.close();
                                }
                                UIUtil.disposeDisplay();
                            }
                            catch (Exception var12_45) {
                                // empty catch block
                            }
                            Log.logInfo("exit: " + exitCode);
                            System.exit(exitCode);
                        }
                        throw var11_43;
                    }
                }
                UIMain.endTime = System.currentTimeMillis() / 1000L;
                UIMain.usage = UIMain.endTime - UIMain.startTime;
                RemoteLogger.logUsage("Package Manager", UIMain.usage);
                Performance.summarize();
                UIMain.finalizeUIMain();
                Log.logTitle("Package Manager was terminated!");
                if (UIMainOptions.automaticInstallation) {
                    errCode = ErrorController.getExitCode();
                    Log.logInfo("auto exit: " + errCode.getValue());
                    if (UIMainOptions.callerTool != null) {
                        dlgShell = new Shell(Display.getDefault());
                        toolRun = true;
                        if (errCode == ErrorController.ExitCode.SELF_UPDATE) {
                            toolRun = false;
                        } else if (errCode == ErrorController.ExitCode.NETWORK_ERROR) {
                            InsideTroubleShootingDialog.open(dlgShell, new UMException(ErrorController.ErrorCode.CANNOT_CONNECT_REPOSITORY));
                        } else if (errCode == ErrorController.ExitCode.INSTALLATION_FAILED) {
                            InsideTroubleShootingDialog.open(dlgShell, new UMException(ErrorController.ErrorCode.FAILED_TO_INSTALL_AUTO));
                        } else {
                            msg = String.format("The %s is launching in ", new Object[]{UIMainOptions.callerTool.getDisplayName()});
                            CustomMessageDialog.showDlg(dlgShell, "Installation is complete.", msg, CustomMessageDialog.DialogType.INFO, true, true, 5);
                        }
                        if (toolRun) {
                            Tools.runTizenTools(UIMain.contentProvider, UIMainOptions.callerTool);
                        }
                        if (dlgShell != null) {
                            dlgShell.close();
                        }
                    }
                    try {
                        if (UIMain.shell != null) {
                            UIMain.shell.close();
                        }
                        UIUtil.disposeDisplay();
                    }
                    catch (Exception var3_17) {
                        // empty catch block
                    }
                    System.exit(errCode.getValue());
                    break block163;
                }
                try {
                    if (UIMain.shell != null) {
                        UIMain.shell.close();
                    }
                    UIUtil.disposeDisplay();
                }
                catch (Exception var2_9) {
                    // empty catch block
                }
                Log.logInfo("exit: " + exitCode);
                System.exit(exitCode);
            }
            UIMain.endTime = System.currentTimeMillis() / 1000L;
            UIMain.usage = UIMain.endTime - UIMain.startTime;
            RemoteLogger.logUsage("Package Manager", UIMain.usage);
            Performance.summarize();
            UIMain.finalizeUIMain();
            Log.logTitle("Package Manager was terminated!");
            if (UIMainOptions.automaticInstallation) {
                errCode = ErrorController.getExitCode();
                Log.logInfo("auto exit: " + errCode.getValue());
                if (UIMainOptions.callerTool != null) {
                    dlgShell = new Shell(Display.getDefault());
                    toolRun = true;
                    if (errCode == ErrorController.ExitCode.SELF_UPDATE) {
                        toolRun = false;
                    } else if (errCode == ErrorController.ExitCode.NETWORK_ERROR) {
                        InsideTroubleShootingDialog.open(dlgShell, new UMException(ErrorController.ErrorCode.CANNOT_CONNECT_REPOSITORY));
                    } else if (errCode == ErrorController.ExitCode.INSTALLATION_FAILED) {
                        InsideTroubleShootingDialog.open(dlgShell, new UMException(ErrorController.ErrorCode.FAILED_TO_INSTALL_AUTO));
                    } else {
                        msg = String.format("The %s is launching in ", new Object[]{UIMainOptions.callerTool.getDisplayName()});
                        CustomMessageDialog.showDlg(dlgShell, "Installation is complete.", msg, CustomMessageDialog.DialogType.INFO, true, true, 5);
                    }
                    if (toolRun) {
                        Tools.runTizenTools(UIMain.contentProvider, UIMainOptions.callerTool);
                    }
                    if (dlgShell != null) {
                        dlgShell.close();
                    }
                }
                try {
                    if (UIMain.shell != null) {
                        UIMain.shell.close();
                    }
                    UIUtil.disposeDisplay();
                }
                catch (Exception dlgShell) {
                    // empty catch block
                }
                System.exit(errCode.getValue());
            } else {
                try {
                    if (UIMain.shell != null) {
                        UIMain.shell.close();
                    }
                    UIUtil.disposeDisplay();
                }
                catch (Exception errCode) {
                    // empty catch block
                }
                Log.logInfo("exit: " + exitCode);
                System.exit(exitCode);
            }
        }
    }

    private static void initializeDisplay() {
        Display display = new Display();
        display.close();
    }

    private static void initializeAppForMacOS() {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", PRODUCT_NAME);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                new CocoaUtil().hidePreferencesAndAboutMenuItems();
            }
        });
    }

    private static boolean initialize(final String[] args) throws UMException {
        logger.info("Start to initialize Package Manager...");
        boolean isSelfUpdateNeeded = false;
        try (Shell initShell = new Shell(Display.getDefault());){
            final CustomProgressDialog progressBar = new CustomProgressDialog(initShell, null);
            Authenticator.setDefault(new UIProxyAuthenticator(initShell, "Proxy Authentication is required."));
            isSelfUpdateNeeded = progressBar.run(new CallableWithMonitor<Boolean>(){

                @Override
                public Boolean call(IProgressMonitor monitor) throws Exception {
                    boolean isSelfUpdateNeeded = false;
                    try {
                        monitor.beginTask("Initializing...", -1);
                        logger.trace("Cleaning up temporay files and diretories...");
                        monitor.subTask("Cleaning up temporary files...");
                        PathUtil.cleanUpTempFilesAndDirectory(contentProvider.getSDKInfo());
                        logger.trace("Initializing core controller...");
                        UIMain.initializeCoreControllers(progressBar);
                        logger.trace("Initializing core controller done...");
                        monitor.subTask("Making Package Manager configurations...");
                        logger.trace("\tSetting compatibility, If it is needeed.");
                        CompatController compatController = new CompatController(contentProvider);
                        if (compatController.needCompatibility()) {
                            compatController.compatamize();
                        }
                        compatController.applyPatches();
                        logger.trace("Checking self-update...");
                        monitor.subTask("Checking self-update...");
                        isSelfUpdateNeeded = UIMain.checkSelfUpdate(args);
                    }
                    catch (UMException e) {
                        throw new UMException(ErrorController.ErrorCode.INITIALIZING_FAILED, (Throwable)e);
                    }
                    finally {
                        monitor.done();
                    }
                    return isSelfUpdateNeeded;
                }
            });
        }
        logger.info("Finished initializing Package Manager.");
        return isSelfUpdateNeeded;
    }

    public static void initializeCoreControllers(IProgressMonitor monitor) throws UMException {
        monitor.subTask("Loading configuration...");
        logger.trace("\tInitializing configuration file.");
        contentProvider.getConfig().init();
        monitor.subTask("Connecting to package server...");
        logger.trace("\tInitializing repository manager.");
        try {
            contentProvider.getRepoMgr().init();
        }
        catch (UMException e) {
            logger.throwing(e);
        }
        monitor.subTask("Loading alternative repositories...");
        logger.trace("\tInitializing alternative manager.");
        contentProvider.getAlterMgr().init(true);
        monitor.subTask("Loading extension repositories...");
        logger.trace("\tInitializing extension repository manager.");
        contentProvider.getExtRepoMgr().init(true);
        monitor.subTask("Removing unused extension caches...");
        logger.trace("\tRemoving unused extension caches.");
        UIMain.cleanUpExtensionCaches(contentProvider.getExtRepoMgr());
        monitor.subTask("Loading package information...");
        logger.trace("\tInitializing package manager.");
        contentProvider.getPkgMgr().init(true);
        logger.trace("\tInitializing component manager.");
        contentProvider.getCompMgr().init();
        logger.trace("\tInitializing install controller.");
        contentProvider.getInstController().init();
    }

    private static void cleanUpExtensionCaches(ExtRepositoryManager extRepoMgr) {
        ArrayList<ExtensionInformation> currentExtensions = extRepoMgr.getCurrentExtensions();
        ArrayList<String> extIds = new ArrayList<String>();
        for (ExtensionInformation extInfo : currentExtensions) {
            if (!extInfo.getRepotype().equalsIgnoreCase("file")) continue;
            extIds.add(extInfo.getId());
        }
        String cachePath = extRepoMgr.getExtCacheDirBySDK();
        File cacheDir = new File(cachePath);
        String[] list = cacheDir.list();
        if (cacheDir.exists() && list != null) {
            for (String id : list) {
                if (extIds.contains(id)) continue;
                extRepoMgr.removeFromCache(id);
            }
        }
    }

    private static boolean checkSelfUpdate(String[] args) {
        SelfUpdater selfUpdater = new SelfUpdater(contentProvider);
        if (selfUpdater.canManagerUpdate()) {
            try {
                selfUpdater.updateManager(args);
                return true;
            }
            catch (Throwable e) {
                logger.throwing(e);
                return false;
            }
        }
        return false;
    }

    private static void finalizeUIMain() {
        if (isInitialized) {
            if (!contentProvider.getExtRepoMgr().getCurrentExtensions().isEmpty() && new File(PathUtil.getFromInstalledPath(contentProvider.getSDKInfo(), ".info")).exists()) {
                contentProvider.getExtRepoMgr().writeToFile();
            }
            PathUtil.cleanUpTempDownloadDirectory(contentProvider.getSDKInfo());
            contentProvider.getInstController().threadForceShutdown();
            contentProvider.getCompMgr().saveFilteredProfile();
        }
        Performance.setIMEndTime();
        Performance.printToLogFile();
    }

    static {
        shell = null;
        contentProvider = null;
        isInitialized = false;
    }
}

