/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.util;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class IMCircularGraph2
extends Composite {
    public static final int TYPE_PERCENT = 0;
    public static final int TYPE_CUSTOM = 1;
    public static final int TYPE_ROTATE = 21;
    private Canvas canvas;
    private Font valueFont = this.getShell().getDisplay().getSystemFont();
    private Font measureFont = this.getShell().getDisplay().getSystemFont();
    private long max = 100L;
    private long value = 0L;
    public Color COLOR_LIGHT_BLUE = new Color(null, new RGB(131, 196, 218));
    public Color COLOR_WHITE = new Color(null, new RGB(255, 255, 255));
    private Color graphColor = this.COLOR_LIGHT_BLUE;
    private Color centerColor = this.COLOR_WHITE;
    private String measure;
    private int type = 0;
    private Image centerImage;
    private Image progressRotate;
    private Image backgorundImage;
    private int centerSize;
    private PaintListener paintListener = new PaintListener(){

        @Override
        public void paintControl(PaintEvent e) {
            Rectangle rect = IMCircularGraph2.this.canvas.getBounds();
            int x = rect.x;
            int y = rect.y;
            int width = rect.width;
            int height = rect.height;
            e.gc.setAntialias(1);
            e.gc.drawImage(IMCircularGraph2.this.backgorundImage, x, y);
            if (IMCircularGraph2.this.type == 21) {
                Transform prevTransform = new Transform(e.display);
                e.gc.getTransform(prevTransform);
                Transform transform = new Transform(IMCircularGraph2.this.canvas.getDisplay());
                transform.translate(x + width / 2, y + height / 2);
                transform.rotate(IMCircularGraph2.this.value);
                transform.translate(-x - width / 2, -y - height / 2);
                e.gc.setTransform(transform);
                e.gc.drawImage(IMCircularGraph2.this.progressRotate, x, y);
                e.gc.setTransform(prevTransform);
                prevTransform.dispose();
                transform.dispose();
            }
            e.gc.setBackground(IMCircularGraph2.this.centerColor);
            e.gc.fillOval(x + width / 2 - IMCircularGraph2.this.centerSize / 2, y + height / 2 - IMCircularGraph2.this.centerSize / 2, IMCircularGraph2.this.centerSize, IMCircularGraph2.this.centerSize);
            if (IMCircularGraph2.this.type == 0) {
                this.drawCenterPercent(e, rect, height);
            } else {
                this.drawCenterImage(e, width);
            }
        }

        private void drawCenterImage(PaintEvent e, int width) {
            e.gc.drawImage(IMCircularGraph2.this.centerImage, width / 2 - ((IMCircularGraph2)IMCircularGraph2.this).centerImage.getBounds().width / 2, width / 2 - ((IMCircularGraph2)IMCircularGraph2.this).centerImage.getBounds().height / 2);
        }

        private void drawCenterPercent(PaintEvent e, Rectangle rect, int height) {
            String centerText = IMCircularGraph2.this.getCenterText();
            e.gc.setFont(IMCircularGraph2.this.valueFont);
            Point textSize = e.gc.textExtent(centerText, 8);
            e.gc.setFont(IMCircularGraph2.this.measureFont);
            Point measureSize = e.gc.textExtent(IMCircularGraph2.this.measure, 8);
            int posX = rect.width / 2 - (textSize.x + measureSize.x) / 2;
            e.gc.setFont(IMCircularGraph2.this.valueFont);
            e.gc.setForeground(IMCircularGraph2.this.graphColor);
            e.gc.drawText(centerText, posX, height / 2 - textSize.y / 2, true);
            e.gc.setFont(IMCircularGraph2.this.measureFont);
            e.gc.setForeground(IMCircularGraph2.this.graphColor);
            e.gc.drawText(IMCircularGraph2.this.measure, posX + textSize.x, height / 2 - textSize.y / 2 + measureSize.y / 2, true);
        }
    };

    public IMCircularGraph2(Composite parent, int style, int type, Rectangle point, int centerSize) {
        super(parent, style);
        this.setLayout(new FormLayout());
        this.type = type;
        this.measure = type == 0 ? "%" : "";
        this.centerSize = centerSize;
        this.canvas = new Canvas(this, 0x20000000);
        this.canvas.addPaintListener(this.paintListener);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.height = point.height;
        data.width = point.width;
        this.canvas.setLayoutData(data);
    }

    public void setMax(long max) {
        this.max = max;
        this.canvas.redraw();
    }

    public void update(long max, long value) {
        this.max = max;
        this.value = value;
        this.canvas.redraw();
        this.canvas.update();
    }

    public void update(long value) {
        this.value = value;
        this.canvas.redraw();
    }

    public void setValueFont(Font font) {
        this.valueFont = font;
    }

    public void setMeasureFont(Font font) {
        this.measureFont = font;
    }

    private String getCenterText() {
        String str = null;
        if (this.type == 0) {
            int percent = (int)((float)this.value / (float)this.max * 100.0f);
            str = Integer.toString(percent);
        } else if (this.value >= 1024L) {
            double dValue = (double)this.value / 1024.0;
            if (dValue >= 1048576.0) {
                dValue = dValue / 1024.0 * 1024.0;
                this.setMeasure("GB");
            } else if (dValue >= 1024.0) {
                dValue /= 1024.0;
                this.setMeasure("MB");
            } else {
                this.setMeasure("KB");
            }
            str = IMCircularGraph2.toDoubleFormat1(Double.toString(dValue));
        } else {
            str = Long.toString(this.value);
        }
        return str;
    }

    public void setMeasure(String m) {
        this.measure = m;
    }

    public void setGraphColor(Color color) {
        this.graphColor = color;
    }

    public void setCenterColor(Color color) {
        this.centerColor = color;
    }

    public void setCanvasColor(Color color) {
        this.canvas.setBackground(color);
    }

    public void setCenterImage(Image image) {
        this.centerImage = image;
    }

    public void setProgressImage(Image image) {
        this.progressRotate = image;
    }

    @Override
    public void setBackgroundImage(Image image) {
        this.backgorundImage = image;
    }

    public static String toDoubleFormat1(String value) {
        if (null == value || value.isEmpty()) {
            return null;
        }
        try {
            double data = Double.parseDouble(value);
            return String.format("%.1f", data);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return value;
        }
    }
}

