#!/bin/bash -x

SHORTCUT_DIR_PATH="${HOME}/.local/share"
GROUP_SHORTCUT_DIR_PATH="${SHORTCUT_DIR_PATH}/desktop-directories"
GROUP_SHORTCUT_FILE_PATH="${GROUP_SHORTCUT_DIR_PATH}/tizen-sdk-menu.directory"
GROUP_SHORTCUT_ICON_FILE_PATH="${INSTALLED_PATH}/package-manager/tizen-sdk-menu.png"
GROUP_SHORTCUT_NAME="Tizen SDK"
GROUP_SHORTCUT_COMMENT="Tizen SDK"
GROUP_SHORTCUT_VERSION=1.0
APP_SHORTCUT_DIR_PATH="${SHORTCUT_DIR_PATH}/applications"

SHORTCUT_FILE_PATH=
EXEC_FILE_PATH=
ICON_PATH=

NAME=
COMMENT=

parseParameter()
{
	while [ $# -gt 0 ]
	do
		case $1 in
			-f|--filepath)
				shift
				SHORTCUT_FILE_PATH="$1"
				;;
			-e|--executefilepath)
				shift
				EXEC_FILE_PATH="$1"
				;;
			-i|--iconpath)
				shift
				ICON_PATH="$1"
				;;
			-n|--name)
				shift
				NAME="$1"
				;;
			-c|--comment)
				shift
				COMMENT="$1"
				;;
			*)
				exit 12
				;;
		esac
		shift
	done
}

##exist unconditionally
checkParameter()
{	
	if [ ! -e "${EXEC_FILE_PATH}" ]; then
		exit 13
	fi
	
	if [ ! -e "${ICON_PATH}" ]; then
		exit 13
	fi
}

makeShortcut()
{
	checkParameter
	
	## check if short file already exists
	if [ -e "${SHORTCUT_FILE_PATH}" ]; then
		rm -rf "${SHORTCUT_FILE_PATH}"
	fi

	## if no application short directory, create it
	if [ ! -e "${APP_SHORTCUT_DIR_PATH}" ]; then
		mkdir -p "${APP_SHORTCUT_DIR_PATH}"
	fi

	## Create .desktop file 
	cat >> "${SHORTCUT_FILE_PATH}" << END
[Desktop Entry]
Encoding=UTF-8
Version=1.0
Type=Application
Terminal=false
Comment=${COMMENT} 
Name=${NAME}
Categories=${GROUP_SHORTCUT_NAME}
StartupNotify=true
NoDisplay=false
Icon=${ICON_PATH}
Exec="${EXEC_FILE_PATH}"
END

	## Check
	if [ ! -e "${GROUP_SHORTCUT_FILE_PATH}" ]; then
		make_group_shortcut_file
	fi

	if [ "`which xdg-desktop-menu 2>/dev/null`" ] ; then
	    echo "Checking xdg-desktop-menu... OK"
            ## Register .desktop file
	    xdg-desktop-menu install "${GROUP_SHORTCUT_FILE_PATH}" "${SHORTCUT_FILE_PATH}"
	else
	    echo "Checking xdg-desktop-menu... IS NOT INSTALLED"
	    exit 0
	fi
}


make_group_shortcut_file()
{
	## create 'desktop-directories' directory
	mkdir -p ${GROUP_SHORTCUT_DIR_PATH}
	
	## create 'Tizen SDK' menu
	cat >> ${GROUP_SHORTCUT_FILE_PATH} << END
[Desktop Entry]	
Type=Directory
Version=${GROUP_SHORTCUT_VERSION}
Name=${GROUP_SHORTCUT_NAME}
Comment=${GROUP_SHORTCUT_COMMENT}
Icon=${GROUP_SHORTCUT_ICON_FILE_PATH}
END
} 


removeOldShortcut() 
{
array=( ${HOME}/.local/share/applications/tizen* )
target=${EXEC_FILE_PATH}
compare="Exec="
compareTarget=$compare$target
compareTarget2=$compare\"$target\"
for i in "${array[@]}"
do
#	echo "i am the king" $i
	while read -r line
	do
	    name=$line
	    if [ "$compareTarget" == "$name" ]; then
	     	rm -rf $i
		break
	    fi	

	    if [ "$compareTarget2" == "$name" ]; then
	     	rm -rf $i		
		break
	    fi	
	done < "$i"
#	echo "End of file " $i
done

}





parseParameter "$@"
removeOldShortcut
makeShortcut
