/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.profiler.codecoverage;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariableManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.tizen.common.TizenProjectType;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.nativecommon.IXMLStore;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.profiler.codecoverage.CommandManager;
import org.tizen.profiler.codecoverage.ui.AnnotateSource;
import org.tizen.profiler.codecoverage.ui.ViewInitializer;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.TimeoutException;

public class CoverageUtil {
    private static boolean isPrePostbuildStep = false;
    private static String SDK_TOOLS_FILEPATH = String.valueOf(InstallPathConfig.getSDKPath()) + File.separator + "tools" + File.separator;
    private static boolean isOSWindows = System.getProperty("os.name").startsWith("Windows");
    private static Process processGcovr;

    /*
     * Exception decompiling
     */
    public static String[] runCommandReturningResult(String var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String expandEnvVariables(String string, IProject iProject) {
        string = string.replaceAll("\\{", "\\(").replaceAll("\\}", "\\)");
        IConfiguration iConfiguration = ManagedBuildManager.getBuildInfo((IResource)iProject).getDefaultConfiguration();
        if (string.indexOf("$(") >= 0) {
            IEnvironmentVariable[] iEnvironmentVariableArray;
            ICConfigurationDescription iCConfigurationDescription = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)iConfiguration);
            IEnvironmentVariableManager iEnvironmentVariableManager = CCorePlugin.getDefault().getBuildEnvironmentManager();
            IEnvironmentVariable[] iEnvironmentVariableArray2 = iEnvironmentVariableArray = iEnvironmentVariableManager.getVariables(iCConfigurationDescription, true);
            int n = iEnvironmentVariableArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEnvironmentVariable iEnvironmentVariable = iEnvironmentVariableArray2[n2];
                string = string.replace(String.format("$(%s)", iEnvironmentVariable.getName()), iEnvironmentVariable.getValue());
                ++n2;
            }
        }
        return isOSWindows && !isPrePostbuildStep ? string.replace("\\", "/") : string;
    }

    private static void GenerateCovReport(File file, IProject iProject) {
        String string = String.valueOf(SDK_TOOLS_FILEPATH) + "ninja";
        String string2 = CoverageUtil.expandEnvVariables("${PATH}", iProject);
        ProcessBuilder processBuilder = new ProcessBuilder(string, "cov_report_only");
        Map<String, String> map = processBuilder.environment();
        map.put("PATH", String.valueOf(string2) + File.pathSeparator + map.get("PATH"));
        processBuilder.directory(file);
        File file2 = new File(file + File.separator + ".covLog");
        processBuilder.redirectErrorStream(true);
        processBuilder.redirectOutput(ProcessBuilder.Redirect.appendTo(file2));
        try {
            Process process = processBuilder.start();
            process.waitFor();
            process.destroy();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private static void GenerateCovReportGovr(File file, IProject iProject, IProject iProject2) {
        block15: {
            String string = iProject.getLocation().toOSString();
            String string2 = iProject2.getLocation().toOSString();
            String string3 = String.valueOf(string2) + File.separator + "src";
            String string4 = String.valueOf(string) + File.separator + "Debug" + File.separator + "src" + File.separator + "For_Coverage";
            String string5 = String.valueOf(string) + File.separator + "Coverage_Report" + File.separator + "coverage.html";
            String string6 = String.valueOf(SDK_TOOLS_FILEPATH) + "gcovr" + File.separator;
            String string7 = CoverageUtil.expandEnvVariables("${SBI_COMPILER_PATH}", iProject);
            File file2 = new File(string7);
            File file3 = file2.getParentFile();
            String string8 = file3.getName();
            int n = string8.lastIndexOf("-gcc-");
            if (n == -1) {
                throw new RuntimeException("Toolchain directory not found in: " + string8);
            }
            String string9 = string8.substring(0, n);
            String string10 = String.valueOf(string9) + "-gcov";
            String string11 = String.valueOf(string7) + File.separator + File.separator + string10;
            String string12 = File.separator == "\\" ? String.valueOf(string6) + "gcovr -r \"" + string3 + "\" " + "--gcov-executable \"" + string11 + "\" " + "--object-directory \"" + string4 + "\" " + "--html-details -o \"" + string5 + "\"" : String.valueOf(string6) + "gcovr -r " + string3 + " --gcov-executable " + string11 + " --object-directory " + string4 + " --html-details -o " + string5;
            BufferedReader bufferedReader = null;
            try {
                try {
                    String string13;
                    String[] stringArray = string12.split(" ");
                    ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
                    processBuilder.redirectErrorStream(true);
                    Process process = processBuilder.start();
                    bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    while ((string13 = bufferedReader.readLine()) != null) {
                        System.out.println(string13);
                    }
                    int n2 = process.waitFor();
                    if (n2 != 0) {
                        System.out.println("error : " + n2);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (bufferedReader == null) break block15;
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                }
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
    }

    private static void LaunchCovReportOnBrowser(IProject iProject) {
        String string = iProject.getLocation().toOSString();
        String string2 = String.valueOf(string) + File.separator + "Coverage_Report" + File.separator + "index.html";
        File file = new File(string2);
        if (!file.exists()) {
            System.out.println("Coverage report file not found: " + string2);
            return;
        }
        try {
            String[] stringArray;
            Object object;
            if (Desktop.isDesktopSupported()) {
                object = Desktop.getDesktop();
                if (((Desktop)object).isSupported(Desktop.Action.BROWSE)) {
                    ((Desktop)object).browse(file.toURI());
                    return;
                }
                if (((Desktop)object).isSupported(Desktop.Action.OPEN)) {
                    ((Desktop)object).open(file);
                    return;
                }
            }
            if (((String)(object = System.getProperty("os.name").toLowerCase())).contains("win")) {
                stringArray = new String[]{"rundll32", "url.dll,FileProtocolHandler", file.getAbsolutePath()};
            } else if (((String)object).contains("mac")) {
                stringArray = new String[]{"open", file.getAbsolutePath()};
            } else if (((String)object).contains("nix") || ((String)object).contains("nux")) {
                stringArray = new String[]{"xdg-open", file.getAbsolutePath()};
            } else {
                throw new UnsupportedOperationException("Unsupported OS: " + (String)object);
            }
            new ProcessBuilder(stringArray).start();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static boolean GenerateCovData(String string, IProject iProject) {
        String string2;
        File file = new File(String.valueOf(string) + "default.profraw");
        if (!file.exists()) {
            return false;
        }
        file = new File(String.valueOf(string) + "coverage.profdata");
        if (file.exists()) {
            file.delete();
        }
        if ((string2 = CoverageUtil.expandEnvVariables("${SBI_COMPILER_PATH}", iProject)).contains("gcc")) {
            return false;
        }
        String string3 = String.valueOf(string2) + File.separator + "llvm-profdata";
        ProcessBuilder processBuilder = new ProcessBuilder(string3, "merge", "-o", String.valueOf(string) + "coverage.profdata", String.valueOf(string) + "default.profraw");
        File file2 = new File(String.valueOf(string) + File.separator + ".covLog");
        processBuilder.redirectErrorStream(true);
        processBuilder.redirectOutput(ProcessBuilder.Redirect.appendTo(file2));
        try {
            Process process = processBuilder.start();
            process.waitFor();
            process.destroy();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return true;
    }

    private static boolean CheckGcdaFetched(String string2) {
        File file2 = new File(string2);
        File[] fileArray = file2.listFiles((file, string) -> string.endsWith(".gcda"));
        return fileArray != null && fileArray.length != 0;
    }

    public static String FindVersion(IDevice iDevice) {
        String string = null;
        try {
            string = iDevice.getPlatformInfo().getPlatformVersion();
        }
        catch (TimeoutException timeoutException) {
            timeoutException.printStackTrace();
        }
        catch (SdbCommandRejectedException sdbCommandRejectedException) {
            sdbCommandRejectedException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }

    public static boolean IsGreaterThanEqual(String string, String string2) {
        String[] stringArray = string.split("\\.");
        String[] stringArray2 = string2.split("\\.");
        if (Integer.parseInt(stringArray2[0]) > Integer.parseInt(stringArray[0])) {
            return true;
        }
        if (Integer.parseInt(stringArray2[0]) == Integer.parseInt(stringArray[0]) && Integer.parseInt(stringArray2[1]) > Integer.parseInt(stringArray[1])) {
            return true;
        }
        return stringArray.length == 3 && stringArray2.length == 3 && Integer.parseInt(stringArray2[0]) == Integer.parseInt(stringArray[0]) && Integer.parseInt(stringArray2[1]) == Integer.parseInt(stringArray[1]) && Integer.parseInt(stringArray2[2]) > Integer.parseInt(stringArray[2]);
    }

    private static void GenerateCoverageInfo(IDevice iDevice, String string) {
        if (iDevice == null) {
            return;
        }
        String string2 = null;
        string2 = CoverageUtil.FindVersion(iDevice);
        if (string2 == null) {
            return;
        }
        if (!CoverageUtil.IsGreaterThanEqual(string2, "3.0")) {
            CommandManager.runCommand("root on");
            boolean bl = CommandManager.pull("/opt/usr/home/owner/share/tmp/sdk_tools/default.profraw", string);
            if (!bl) {
                string = "";
            }
        } else {
            CommandManager.runCommand("root on");
            String string3 = "su -c \"cp /tmp/default.profraw /home/developer\"";
            try {
                iDevice.executeShellCommand(string3, false);
                Thread.sleep(500L);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            boolean bl = CommandManager.pull("/home/developer/default.profraw", string);
            if (!bl) {
                string = "";
            }
        }
    }

    private static void FetchGcdaFiles(IDevice iDevice, String string, String string2) {
        if (iDevice == null) {
            return;
        }
        String string3 = null;
        string3 = CoverageUtil.FindVersion(iDevice);
        if (string3 == null) {
            return;
        }
        String string4 = "/opt/usr/home/owner/share/tmp/sdk_tools/tmp/";
        if (!CoverageUtil.IsGreaterThanEqual(string3, "3.0")) {
            CommandManager.runCommand("root on");
            String[] stringArray = CoverageUtil.runCommandReturningResult("find " + string4 + string2 + " -name '*.gcda'");
            boolean bl = true;
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string5 = stringArray2[n2];
                if (!CommandManager.pull(string5, string)) {
                    bl = false;
                }
                ++n2;
            }
            if (!bl) {
                string = "";
            }
        }
    }

    public static void CopyCoverageInfo(String string, String string2) {
        File file = new File(String.valueOf(string) + File.separator + "coverage.profdata");
        File file2 = new File(String.valueOf(string2) + File.separator + "coverage.profdata");
        try {
            FileUtils.copyFile((File)file, (File)file2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void copyGcdaGcnoFiles(String string, String string2, boolean bl) {
        File[] fileArray;
        File file2;
        File file3 = new File(string);
        File file4 = new File(string2, "For_Coverage");
        if (!file4.exists()) {
            file4.mkdirs();
        }
        if (bl) {
            file2 = new File(string2);
            fileArray = file2.listFiles(file -> file.getName().endsWith(".o"));
        } else {
            fileArray = file3.listFiles(file -> file.isFile() && !file.getName().startsWith("."));
            file3 = new File(string2);
        }
        if (fileArray == null) {
            System.err.println("Error: No valid files found in source directory: " + (bl ? file4 : file3));
            return;
        }
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            file2 = fileArray2[n2];
            String string3 = file2.getName();
            String string4 = bl ? "." + string3.replace(".o", "") : ((n3 = string3.lastIndexOf(46)) != -1 ? string3.substring(0, n3) : string3);
            String string5 = String.valueOf(string4) + ".gcda";
            String string6 = String.valueOf(string4) + ".gcno";
            CoverageUtil.copyFileIfExists(new File(file3, string5), new File(file4, string5));
            CoverageUtil.copyFileIfExists(new File(file3, string6), new File(file4, string6));
            ++n2;
        }
    }

    private static void copyFileIfExists(File file, File file2) {
        if (file.exists()) {
            try {
                FileUtils.copyFile((File)file, (File)file2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static void generateAppLevelCoverageReport(String string, String[] stringArray, String string2) throws IOException {
        Object object;
        String[] stringArray2;
        String[] stringArray3;
        String[] stringArray4;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        stringBuilder.append("<table class=\"coverage\">\n").append("<tr>\n<th></th><th scope=\"col\">Exec</th><th scope=\"col\">Total</th><th scope=\"col\">Coverage</th>\n</tr>\n");
        stringBuilder2.append("<table class=\"file-list\">\n").append("<col/>\n<colgroup span=\"3\"/>\n<colgroup span=\"2\"/>\n<colgroup span=\"2\"/>\n<tr>\n").append("<th scope=\"col\">Project Name</th>\n").append("<th scope=\"colgroup\" colspan=\"3\">Lines</th>\n").append("<th scope=\"colgroup\" colspan=\"2\">Functions</th>\n").append("<th scope=\"colgroup\" colspan=\"2\">Branches</th>\n</tr>\n");
        int n7 = 0;
        while (n7 < stringArray.length) {
            String string3 = stringArray[n7];
            stringArray4 = String.valueOf(string) + File.separator + string3 + File.separator + "Coverage_Report" + File.separator + "coverage.html";
            stringArray3 = new String(Files.readAllBytes(Paths.get((String)stringArray4, new String[0])), "UTF-8");
            stringArray2 = CoverageUtil.extractCoverageRow((String)stringArray3, "Lines");
            object = CoverageUtil.extractCoverageRow((String)stringArray3, "Functions");
            String[] stringArray5 = CoverageUtil.extractCoverageRow((String)stringArray3, "Branches");
            n += Integer.parseInt(stringArray2[0]);
            n2 += Integer.parseInt(stringArray2[1]);
            n3 += Integer.parseInt(object[0]);
            n4 += Integer.parseInt(object[1]);
            n5 += Integer.parseInt(stringArray5[0]);
            n6 += Integer.parseInt(stringArray5[1]);
            stringBuilder2.append("<tr>\n<th scope=\"row\"><a href=\"").append(stringArray4.replace("\\", "/")).append("\">").append(string3).append("</a></th>\n").append("<td><meter class=\"").append(CoverageUtil.getCoverageMeter(stringArray2[2])).append("\" min=\"0\" max=\"100\" value=\"").append(stringArray2[2].replace("%", "")).append("\" title=\"").append(stringArray2[2]).append("\"></meter></td>\n").append("<td class=\"CoverValue line-coverage ").append(CoverageUtil.getCoverageMeter(stringArray2[2])).append("\">").append(stringArray2[2]).append("</td>\n").append("<td class=\"CoverValue line-coverage ").append(CoverageUtil.getCoverageMeter(stringArray2[2])).append("\">").append(stringArray2[0]).append(" / ").append(stringArray2[1]).append("</td>\n").append("<td class=\"CoverValue function-coverage ").append(CoverageUtil.getCoverageMeter(object[2])).append("\">").append(object[2]).append("</td>\n").append("<td class=\"CoverValue function-coverage ").append(CoverageUtil.getCoverageMeter(object[2])).append("\">").append(object[0]).append(" / ").append(object[1]).append("</td>\n").append("<td class=\"CoverValue branch-coverage ").append(CoverageUtil.getCoverageMeter(stringArray5[2])).append("\">").append(stringArray5[2]).append("</td>\n").append("<td class=\"CoverValue branch-coverage ").append(CoverageUtil.getCoverageMeter(stringArray5[2])).append("\">").append(stringArray5[0]).append(" / ").append(stringArray5[1]).append("</td>\n").append("</tr>\n");
            ++n7;
        }
        double d = (double)n / (double)n2 * 100.0;
        stringArray4 = new String[]{String.valueOf(n), String.valueOf(n2), String.format("%.0f%%", d)};
        d = (double)n3 / (double)n4 * 100.0;
        stringArray3 = new String[]{String.valueOf(n3), String.valueOf(n4), String.format("%.0f%%", d)};
        d = (double)n5 / (double)n6 * 100.0;
        stringArray2 = new String[]{String.valueOf(n5), String.valueOf(n6), String.format("%.0f%%", d)};
        stringBuilder.append("<tr>\n").append("<th scope=\"row\">Lines:</th>\n").append("<td>").append(stringArray4[0]).append("</td><td>").append(stringArray4[1]).append("</td><td class = \"").append(CoverageUtil.getCoverageMeter(stringArray4[2])).append("\">").append(stringArray4[2]).append("</td>\n").append("</tr>\n").append("<tr>\n").append("<th scope=\"row\">Functions:</th>\n").append("<td>").append(stringArray3[0]).append("</td><td>").append(stringArray3[1]).append("</td><td class = \"").append(CoverageUtil.getCoverageMeter(stringArray3[2])).append("\">").append(stringArray3[2]).append("</td>\n").append("</tr>\n").append("<tr>\n").append("<th scope=\"row\">Branches:</th>\n").append("<td>").append(stringArray2[0]).append("</td><td>").append(stringArray2[1]).append("</td><td class = \"").append(CoverageUtil.getCoverageMeter(stringArray2[2])).append("\">").append(stringArray2[2]).append("</td>\n").append("</tr>\n");
        stringBuilder.append("</table>\n");
        stringBuilder2.append("</table>\n");
        object = new StringBuilder();
        ((StringBuilder)object).append("<!DOCTYPE html>\n").append("<html class=\"theme-green\">\n<head>\n").append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/>\n").append("<title>GCC Code Coverage Report</title>\n").append("<meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\"/>\n").append("<link rel=\"stylesheet\" href=\"coverage.css\"/>\n").append("</head>\n<body>\n<header>\n<h1>App Level Code Coverage Report</h1>\n<hr/>\n</header>\n").append("<div>\n<table class=\"legend\">\n").append("<tr>\n<th scope=\"row\">Coverage:</th>\n<td class=\"legend\">\n").append("<span class=\"coverage-low\">low: &ge; 0%</span>\n").append("<span class=\"coverage-medium\">medium: &ge; 75.0%</span>\n").append("<span class=\"coverage-high\">high: &ge; 90.0%</span>\n").append("</td>\n</tr>\n</table>\n</div>\n").append("<div>\n").append((CharSequence)stringBuilder).append("</div>\n<hr/>\n").append("<main>\n").append((CharSequence)stringBuilder2).append("</main>\n").append("</body>\n</html>");
        Files.write(Paths.get(string2, new String[0]), ((StringBuilder)object).toString().getBytes("UTF-8"), new OpenOption[0]);
    }

    public static String[] extractCoverageRow(String string, String string2) {
        Pattern pattern = Pattern.compile("<th\\s+scope=\"row\">" + string2 + ":</th>\\s*<td>(\\d+)</td>\\s*<td>(\\d+)</td>\\s*<td[^>]*>([\\d.]+%)</td>", 34);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return new String[]{matcher.group(1), matcher.group(2), matcher.group(3)};
        }
        return new String[]{"0", "0", "0"};
    }

    public static String getCoverageMeter(String string) {
        double d = Double.parseDouble(string.replace("%", ""));
        if (d < 75.0) {
            return "coverage-low";
        }
        if (d >= 75.0 && d < 90.0) {
            return "coverage-medium";
        }
        return "coverage-high";
    }

    public static void annotateAllProjects(IProject iProject, IDevice iDevice) {
        String string = iProject.getLocation().toOSString();
        AnnotateSource annotateSource = new AnnotateSource();
        annotateSource.populate(string);
    }

    public static void getAllReferencedProjects(Set<IProject> set, IProject iProject) throws CoreException {
        IProject[] iProjectArray = iProject.getReferencedProjects();
        int n = 0;
        while (n < iProjectArray.length) {
            if (!set.contains(iProjectArray[n]) && iProjectArray[n].exists() && iProjectArray[n].isOpen()) {
                set.add(iProjectArray[n]);
                CoverageUtil.getAllReferencedProjects(set, iProjectArray[n]);
            }
            ++n;
        }
    }

    public static void ClearReport(IProject iProject) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList("Coverage_Report", "Debug" + File.separator + "src" + File.separator + "For_Coverage"));
        arrayList.forEach(string -> {
            String string2 = String.valueOf(iProject.getLocation().toOSString()) + File.separator + string;
            File file = new File(string2);
            try {
                if (file.exists()) {
                    FileUtils.deleteDirectory((File)file);
                }
                file.mkdirs();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        });
    }

    public static void ClearReports(ArrayList<IProject> arrayList) {
        arrayList.parallelStream().forEach(iProject -> CoverageUtil.ClearReport(iProject));
    }

    public static void generateCoverageReports(IDevice iDevice, IProject iProject) throws CoreException {
        HashSet<IProject> hashSet = new HashSet<IProject>();
        CoverageUtil.getAllReferencedProjects(hashSet, iProject);
        ArrayList<IProject> arrayList = new ArrayList<IProject>(hashSet);
        CoverageUtil.ClearReport(iProject);
        CoverageUtil.ClearReports(arrayList);
        String string = iProject.getLocation().toOSString();
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        String string2 = iManagedBuildInfo.getConfigurationName();
        String string3 = String.valueOf(string) + File.separator + string2 + File.separator;
        File file = new File(string3);
        CoverageUtil.GenerateCoverageInfo(iDevice, string3);
        if (!CoverageUtil.GenerateCovData(string3, iProject)) {
            throw new CoreException((IStatus)new Status(4, "", "Coverage Data not generated. Check the toolchain selected or if coverage is enabled."));
        }
        CoverageUtil.GenerateCovReport(file, iProject);
        arrayList.parallelStream().forEach(iProject2 -> {
            String string3 = String.valueOf(iProject2.getLocation().toOSString()) + File.separator + string2 + File.separator;
            File file = new File(string3);
            CoverageUtil.CopyCoverageInfo(string3, string3);
            CoverageUtil.GenerateCovReport(file, iProject);
        });
        ViewInitializer viewInitializer = new ViewInitializer(iProject);
        viewInitializer.init(String.valueOf(string) + File.separator + "Coverage_Report" + File.separator + "report.txt", arrayList);
    }

    public static void generateCoverageReportsGCC(IDevice iDevice, IProject iProject) throws CoreException {
        HashSet<IProject> hashSet = new HashSet<IProject>();
        CoverageUtil.getAllReferencedProjects(hashSet, iProject);
        ArrayList<IProject> arrayList = new ArrayList<IProject>(hashSet);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        CoverageUtil.ClearReport(iProject);
        CoverageUtil.ClearReports(arrayList);
        IXMLStore iXMLStore = ProjectUtil.getXmlStore((IProject)iProject);
        iXMLStore.setProject(iProject);
        iXMLStore.loadXml();
        TizenProjectType tizenProjectType = ProjectUtil.getTizenProjectType((IProject)iProject);
        String string = tizenProjectType.getAppIdForLaunch(iXMLStore.getXMLDataId());
        String string2 = iProject.getLocation().toOSString();
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        String string3 = iManagedBuildInfo.getConfigurationName();
        String string4 = String.valueOf(string2) + File.separator + string3 + File.separator + "src" + File.separator;
        String string5 = String.valueOf(string2) + File.separator + "src";
        File file = new File(string4);
        arrayList2.add(iProject.getName());
        CoverageUtil.FetchGcdaFiles(iDevice, string4, string);
        CoverageUtil.copyGcdaGcnoFiles(string5, string4, false);
        if (!CoverageUtil.CheckGcdaFetched(string4)) {
            throw new CoreException((IStatus)new Status(4, "", "gcda Data not generated. Check the toolchain selected or if coverage is enabled."));
        }
        CoverageUtil.GenerateCovReportGovr(file, iProject, iProject);
        arrayList.parallelStream().forEach(iProject2 -> {
            String string3 = String.valueOf(iProject2.getLocation().toOSString()) + File.separator + string3 + File.separator + "src" + File.separator;
            File file = new File(string3);
            arrayList2.add(iProject2.getName());
            CoverageUtil.copyGcdaGcnoFiles(string4, string3, true);
            CoverageUtil.GenerateCovReportGovr(file, iProject2, iProject);
        });
        String string6 = new File(string2).getParent();
        String[] stringArray = arrayList2.toArray(new String[0]);
        String string7 = String.valueOf(string2) + File.separator + "Coverage_Report" + File.separator + "index.html";
        try {
            CoverageUtil.generateAppLevelCoverageReport(string6, stringArray, string7);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        CoverageUtil.LaunchCovReportOnBrowser(iProject);
    }

    public static void cleanCov(File file, IProject iProject) {
        String string = String.valueOf(SDK_TOOLS_FILEPATH) + "ninja";
        ProcessBuilder processBuilder = new ProcessBuilder(string, "clean_cov");
        String string2 = CoverageUtil.expandEnvVariables("${PATH}", iProject);
        Map<String, String> map = processBuilder.environment();
        map.put("PATH", String.valueOf(string2) + File.pathSeparator + map.get("PATH"));
        processBuilder.directory(file);
        File file2 = new File(file + File.separator + ".covLog");
        processBuilder.redirectErrorStream(true);
        processBuilder.redirectOutput(ProcessBuilder.Redirect.appendTo(file2));
        try {
            Process process = processBuilder.start();
            process.waitFor();
            process.destroy();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public static boolean isUnitTestProject(IProject iProject) {
        String[] stringArray = null;
        try {
            stringArray = iProject.getDescription().getNatureIds();
        }
        catch (CoreException coreException) {
            return false;
        }
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                if ("org.tizen.tizentest.nature".equals(string)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

