/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.profiler.codecoverage.ui;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.tizen.profiler.codecoverage.ui.ProjectInfo;

public class TotalReportGenerator {
    private static TotalReportGenerator instance = new TotalReportGenerator();

    public static TotalReportGenerator getInstance() {
        return instance;
    }

    public void generateTotalReport(IProject iProject, ArrayList<ProjectInfo> arrayList, int n, int n2, float f) throws IOException {
        String string = String.valueOf(iProject.getLocation().toOSString()) + File.separator + "Coverage_Report" + File.separator + "total_report.txt";
        String string2 = System.getProperty("line.separator");
        File file = new File(string);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.write(String.format("%-40s       Lines      Miss       Start     Cover" + string2, "Project Name"));
        bufferedWriter.write("------------------------------------------------------------------------------------" + string2);
        for (ProjectInfo projectInfo : arrayList) {
            bufferedWriter.write(String.valueOf(string2) + String.format("%-40s : %10d%10d%10d%10.2f%%", projectInfo.getProjName(), projectInfo.getLineCount(), projectInfo.getMissCount(), 0, Float.valueOf(projectInfo.getPercent())));
        }
        bufferedWriter.write(String.valueOf(string2) + "------------------------------------------------------------------------------------" + string2);
        bufferedWriter.write(String.valueOf(string2) + String.format("%-40s : %10d%10d%10d%10.2f%%", "TOTAL", n, n2, 0, Float.valueOf(f)));
        bufferedWriter.close();
    }
}

