/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.asan.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.linuxtools.asan.ui.ErrorFileInfo;
import org.eclipse.linuxtools.asan.ui.ErrorFunctionInfo;
import org.eclipse.linuxtools.asan.ui.ErrorMain;
import org.eclipse.linuxtools.asan.ui.ErrorRoot;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeViewerDoubleClickListener
implements IDoubleClickListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void doubleClick(DoubleClickEvent doubleClickEvent) {
        ErrorFileInfo errorFileInfo;
        TreeViewer treeViewer = (TreeViewer)doubleClickEvent.getViewer();
        IStructuredSelection iStructuredSelection = (IStructuredSelection)doubleClickEvent.getSelection();
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof ErrorMain) {
            treeViewer.setExpandedState(object, !treeViewer.getExpandedState(object));
        } else if (object instanceof ErrorRoot) {
            ErrorFileInfo errorFileInfo2 = ((ErrorRoot)iStructuredSelection.getFirstElement()).getMainFile();
            if (errorFileInfo2 != null && errorFileInfo2.getFile().exists()) {
                this.openEditor(errorFileInfo2);
            }
        } else if (object instanceof ErrorFunctionInfo) {
            treeViewer.setExpandedState(object, !treeViewer.getExpandedState(object));
        } else if (object instanceof ErrorFileInfo && (errorFileInfo = (ErrorFileInfo)iStructuredSelection.getFirstElement()).getFile().exists()) {
            this.openEditor(errorFileInfo);
        }
    }

    public void openEditor(ErrorFileInfo errorFileInfo) {
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        String string = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(errorFileInfo.getFile().getName()).getId();
        try {
            IEditorPart iEditorPart = iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput((IFile)errorFileInfo.getFile()), string);
            IEditorInput iEditorInput = iEditorPart.getEditorInput();
            ITextEditor iTextEditor = (ITextEditor)iEditorPart;
            IDocumentProvider iDocumentProvider = iTextEditor.getDocumentProvider();
            iDocumentProvider.connect((Object)iEditorInput);
            IDocument iDocument = iDocumentProvider.getDocument((Object)iEditorInput);
            IRegion iRegion = iDocument.getLineInformation(errorFileInfo.getLineNumber() - 1);
            iTextEditor.selectAndReveal(iRegion.getOffset(), iRegion.getLength());
        }
        catch (Exception exception) {
            this.logger.warn(String.format("Failed to open the file(%s)", errorFileInfo.getFile()), (Throwable)exception);
        }
    }
}

