/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.profiler.codecoverage.ui;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.OSChecker;
import org.tizen.common.util.ProjectUtil;
import org.tizen.profiler.codecoverage.CoverageUtil;
import org.tizen.profiler.codecoverage.ui.ProjectInfo;
import org.tizen.profiler.codecoverage.ui.TestProjectUtil;

public class HtmlReportGenerator {
    private static HtmlReportGenerator instance = new HtmlReportGenerator();

    private HtmlReportGenerator() {
    }

    public static HtmlReportGenerator getInstance() {
        return instance;
    }

    public void generateHtml(IProject iProject) {
        TestProjectUtil testProjectUtil = TestProjectUtil.getTestProjectUtilInstance();
        IProject iProject2 = testProjectUtil.getCovProj(iProject);
        if (iProject2 == null) {
            return;
        }
        this.generateHtmlReport(iProject, iProject2);
    }

    private static void generateHtmlCovFile(File file, List<String> list) {
        ProcessBuilder processBuilder = new ProcessBuilder(list);
        processBuilder.directory(file);
        File file2 = new File(file + File.separator + ".HtmlCovLog");
        if (file2.exists()) {
            file2.delete();
        }
        try {
            file2.createNewFile();
            processBuilder.redirectErrorStream(true);
            processBuilder.redirectOutput(ProcessBuilder.Redirect.appendTo(file2));
            Process process = processBuilder.start();
            process.waitFor();
            process.destroy();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public void generateHtmlReport(IProject iProject, IProject iProject2) {
        String string;
        File file;
        String string2 = iProject.getLocation().toString().replace('\\', '/');
        String string3 = iProject2.getLocation().toString().replace('\\', '/');
        ArrayList<String> arrayList = new ArrayList<String>();
        TestProjectUtil testProjectUtil = TestProjectUtil.getTestProjectUtilInstance();
        IProject iProject3 = testProjectUtil.getReferencedUniTestProj(iProject, arrayList);
        TizenProjectDescription tizenProjectDescription = ProjectUtil.getTizenProjectDescription((IProject)iProject);
        String string4 = tizenProjectDescription.getVersion();
        if (string4 == null) {
            return;
        }
        String string5 = iProject3 != null ? iProject3.getLocation().toString().replace('\\', '/') : string3;
        String string6 = CoverageUtil.expandEnvVariables("${SBI_COMPILER_PATH}", iProject);
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject2);
        String string7 = iManagedBuildInfo.getConfigurationName();
        String string8 = String.valueOf(string2) + "/" + string7;
        String string9 = iManagedBuildInfo.getBuildArtifactExtension();
        String string10 = String.valueOf(string3) + "/" + string7 + "/" + iManagedBuildInfo.getOutputPrefix(string9) + iManagedBuildInfo.getBuildArtifactName();
        if (!string9.isEmpty()) {
            string10 = String.valueOf(string10) + "." + string9;
        }
        if (!(file = new File(string = OSChecker.isWindows() ? String.valueOf(string6) + "/llvm-cov.exe" : String.valueOf(string6) + "/llvm-cov")).exists()) {
            return;
        }
        File file2 = new File(string10);
        if (!file2.exists()) {
            return;
        }
        String string11 = string10;
        String string12 = String.format(String.valueOf(string5) + "/Coverage_Report/Html_Report/%s", iProject.getName());
        File file3 = new File(string8);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (OSChecker.isWindows()) {
            arrayList2.add(string);
            arrayList2.add("show");
            arrayList2.add(string11);
            arrayList2.add("-filename-equivalence");
            arrayList2.add("-format=html");
            arrayList2.add("-instr-profile=coverage.profdata");
            arrayList2.add("../");
            arrayList2.add("-output-dir=" + string12);
        } else {
            arrayList2.add("/bin/sh");
            arrayList2.add("-c");
            String[] stringArray = new String[8];
            int n = 0;
            stringArray[n++] = string;
            stringArray[n++] = "show";
            stringArray[n++] = string11;
            stringArray[n++] = "-filename-equivalence";
            stringArray[n++] = "-format=html";
            stringArray[n++] = "-instr-profile=coverage.profdata";
            stringArray[n++] = "../";
            stringArray[n++] = "-output-dir=" + string12;
            StringBuilder stringBuilder = new StringBuilder();
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string13 = stringArray2[n3];
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(string13);
                ++n3;
            }
            arrayList2.add(stringBuilder.toString());
        }
        HtmlReportGenerator.generateHtmlCovFile(file3, arrayList2);
    }

    public void generateHtmlReport(ArrayList<IProject> arrayList, ArrayList<ProjectInfo> arrayList2, int n, int n2, float f) {
        arrayList.parallelStream().forEach(iProject -> this.generateHtml((IProject)iProject));
        String string = String.valueOf(arrayList.get(0).getLocation().toOSString()) + File.separator + "Coverage_Report" + File.separator + "Html_Report";
        String string2 = System.getProperty("line.separator");
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        file = new File(String.valueOf(string) + File.separator + "index.html");
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write(String.format("<html>" + string2 + "<head><h1> <center>Coverage Report</center></h1></head>" + string2 + "<body><pre style=\"wod-wrap:break-word; white-space:pre-wrap;font-size:14px\">" + string2, new Object[0]));
            bufferedWriter.write(String.format("%-40s       Lines      Miss       Start     Cover" + string2, "Project Name"));
            bufferedWriter.write("------------------------------------------------------------------------------------" + string2);
            for (ProjectInfo projectInfo : arrayList2) {
                String string3 = projectInfo.getProjName();
                bufferedWriter.write(String.valueOf(string2) + String.format("<a href =\"%s/index.html\" style=\"text-decoration: none\">%-40s</a> : %10d%10d%10d%10.2f%%", string3, string3, projectInfo.getLineCount(), projectInfo.getMissCount(), 0, Float.valueOf(projectInfo.getPercent())));
            }
            bufferedWriter.write(String.valueOf(string2) + "------------------------------------------------------------------------------------" + string2);
            bufferedWriter.write(String.valueOf(string2) + String.format("%-40s : %10d%10d%10d%10.2f%%", "TOTAL", n, n2, 0, Float.valueOf(f)));
            bufferedWriter.write("</pre></body>" + string2 + "</html>");
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

