/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.profiler.codecoverage.ui;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.OSChecker;
import org.tizen.common.util.ProjectUtil;
import org.tizen.profiler.codecoverage.CoverageUtil;
import org.tizen.profiler.codecoverage.ui.AnnotateSource;
import org.tizen.profiler.codecoverage.ui.TestProjectUtil;

public class SourceClickHandler {
    private static SourceClickHandler instance = new SourceClickHandler();
    private boolean annotated = false;

    private SourceClickHandler() {
    }

    public static SourceClickHandler getSourceClickHandler() {
        return instance;
    }

    public void setAnnotated(boolean bl) {
        this.annotated = bl;
    }

    public void handleFileOpen(ITextEditor iTextEditor, boolean bl) {
        if (this.annotated || !bl) {
            return;
        }
        IEditorInput iEditorInput = iTextEditor.getEditorInput();
        IFile iFile = (IFile)iEditorInput.getAdapter(IFile.class);
        if (iFile == null) {
            return;
        }
        this.handleFileOpen(iFile);
    }

    public void handleFileOpen(IFile iFile) {
        String string = iFile.getFileExtension();
        if (!(string.equalsIgnoreCase("c") || string.equalsIgnoreCase("cc") || string.equalsIgnoreCase("cpp") || string.equalsIgnoreCase("cxx") || string.equalsIgnoreCase("h") || string.equalsIgnoreCase("hpp") || string.equalsIgnoreCase("hxx") || string.equalsIgnoreCase("hh"))) {
            return;
        }
        IProject iProject = iFile.getProject();
        TestProjectUtil testProjectUtil = TestProjectUtil.getTestProjectUtilInstance();
        IProject iProject2 = testProjectUtil.getCovProj(iProject);
        if (iProject2 == null) {
            return;
        }
        this.annotateSourceFile(iProject, iProject2, iFile);
    }

    private static void generateCovFile(File file, List<String> list) {
        ProcessBuilder processBuilder = new ProcessBuilder(list);
        processBuilder.directory(file);
        File file2 = new File(file + File.separator + ".AnnotationLog");
        if (file2.exists()) {
            file2.delete();
        }
        try {
            file2.createNewFile();
            processBuilder.redirectErrorStream(true);
            processBuilder.redirectOutput(ProcessBuilder.Redirect.appendTo(file2));
            Process process = processBuilder.start();
            process.waitFor();
            process.destroy();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public void annotateSourceFile(IProject iProject, IProject iProject2, final IFile iFile) {
        TizenProjectDescription tizenProjectDescription;
        String string;
        final String string2 = iProject.getLocation().toString().replace('\\', '/');
        String string3 = iProject2.getLocation().toString().replace('\\', '/');
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        String string4 = CoverageUtil.expandEnvVariables("${SBI_COMPILER_PATH}", iProject);
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject2);
        String string5 = iManagedBuildInfo.getConfigurationName();
        final String string6 = String.valueOf(string2) + "/" + string5;
        String string7 = iManagedBuildInfo.getBuildArtifactExtension();
        String string8 = String.valueOf(string3) + "/" + string5 + "/" + iManagedBuildInfo.getOutputPrefix(string7) + iManagedBuildInfo.getBuildArtifactName();
        if (!string7.isEmpty()) {
            string8 = String.valueOf(string8) + "." + string7;
        }
        if ((string = (tizenProjectDescription = ProjectUtil.getTizenProjectDescription((IProject)iProject)).getVersion()) == null) {
            return;
        }
        final String string9 = OSChecker.isWindows() ? String.valueOf(string4) + "/llvm-cov.exe" : String.valueOf(string4) + "/llvm-cov";
        File file = new File(string9);
        if (!file.exists()) {
            MessageDialog.openInformation((Shell)shell, (String)"Info", (String)"llvm-cov not found. Please check the selected toolchain.");
            return;
        }
        File file2 = new File(string8);
        if (!file2.exists()) {
            MessageDialog.openInformation((Shell)shell, (String)"Info", (String)("Annotation Failed: " + string8 + " not found  "));
            return;
        }
        final String string10 = string8;
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell);
        try {
            progressMonitorDialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    Object object;
                    iProgressMonitor.setTaskName("Annotating Source");
                    iProgressMonitor.beginTask("Annotating Source Please Wait...", -1);
                    String string = iFile.getLocation().toString();
                    String string22 = String.valueOf(string) + ".cov";
                    string22 = string22.replace('\\', '/');
                    string22 = string22.replace(string2, String.valueOf(string2) + "/Coverage_Report");
                    string = string.replace(string2, "../");
                    File file = new File(string22);
                    if (!file.exists()) {
                        object = new File(string6);
                        ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.add(string9);
                        arrayList.add("show");
                        arrayList.add(string10);
                        arrayList.add("-filename-equivalence");
                        arrayList.add("-instr-profile=coverage.profdata");
                        arrayList.add(string);
                        arrayList.add("-outfile=" + string22);
                        SourceClickHandler.generateCovFile((File)object, arrayList);
                    }
                    object = new AnnotateSource();
                    try {
                        try {
                            ((AnnotateSource)object).annotateUsingFile(file);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            iProgressMonitor.done();
                        }
                    }
                    finally {
                        iProgressMonitor.done();
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {
            exception.printStackTrace();
        }
    }
}

