/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ssilib;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.core.gputil.MacroUtil;
import org.tizen.core.gputil.MarkupUtil;

public class SSIMacro {
    protected final Logger logger = LoggerFactory.getLogger(SSIMacro.class);
    private Map<String, String> globalMacros = new HashMap<String, String>();
    private Map<String, String> macros = new HashMap<String, String>();
    private Map<String, String> variables = new HashMap<String, String>();
    private String script;
    private MacroUtil.Runner macroRunner = new MacroRunner(this);
    private Runner runner = null;

    public String processValue(String src) {
        String src2;
        if (src != null && !src.isEmpty() && (src = (src2 = this.runner != null ? MacroUtil.processMacro((String)src, (MacroUtil.Runner)this.macroRunner) : MacroUtil.processMacro((String)src, this.macros))) != null && !src.isEmpty()) {
            src = this.getScript() == null ? MarkupUtil.processDefaultMarkupSSI((String)src) : MarkupUtil.processDefaultMarkup2((String)src, (MarkupUtil.Runner[])new MarkupUtil.Runner[]{MarkupUtil.getJavaScriptMarkupRunner((String)this.getScript())});
        }
        return src;
    }

    public void setMacros(Map<String, String> macros) {
        this.macros = macros;
    }

    public Map<String, String> getMacros() {
        return this.macros;
    }

    public void setGlobalMacros(Map<String, String> macros) {
        this.globalMacros = macros;
    }

    public Map<String, String> getGlobalMacros() {
        return this.globalMacros;
    }

    public void setVariables(Map<String, String> variables) {
        this.variables = variables;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public void addScript(String script) {
        this.script = this.script == null ? script : this.script + "\r\n" + script;
    }

    public String getScript() {
        return this.script;
    }

    public void setMacroRunner(Runner runner) {
        this.runner = runner;
    }

    public Runner getMacroRunner() {
        return this.runner;
    }

    public void addMacro(String name, String value) {
        this.macros.put(name, value);
    }

    public void removeMacro(String name) {
        this.macros.remove(name);
    }

    public void addVariable(String name, String value) {
        this.variables.put(name, value);
    }

    public void removeVariable(String name) {
        this.variables.remove(name);
    }

    public String getValue(String name) {
        String value = this.macros.get(name);
        if (value == null) {
            value = this.variables.get(name);
        }
        return value;
    }

    public static class MacroRunner
    implements MacroUtil.Runner {
        private SSIMacro proc;

        public MacroRunner(SSIMacro proc) {
            this.proc = proc;
        }

        public String run(String macro) {
            String value = null;
            if (this.proc.getMacros() != null) {
                value = this.proc.getMacros().get(macro);
            }
            if (value == null && this.proc.getGlobalMacros() != null) {
                value = this.proc.getGlobalMacros().get(macro);
            }
            if (value == null && this.proc.getVariables() != null && this.proc.getMacroRunner() != null && (value = this.proc.getVariables().get(macro)) != null) {
                value = this.proc.getMacroRunner().getVariable(value);
            }
            return value;
        }
    }

    public static interface Runner {
        public String getVariable(String var1);
    }
}

