/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ssilib;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.core.gputil.VersionUtil;
import org.tizen.core.gputil.XMLUtil;
import org.tizen.ssilib.SSIData;
import org.tizen.ssilib.SSIFileSet;
import org.tizen.ssilib.SSIMacro;
import org.tizen.ssilib.SSIProc;
import org.tizen.ssilib.SSIStructure;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SSIParser {
    protected final Logger logger = LoggerFactory.getLogger(SSIParser.class);

    public static SSIScript analisysPackageScript(File sbiBuildConfFile, SSIData data, String requireVersion) {
        String value;
        Element elem;
        String name;
        Node inputNode;
        int i;
        String version;
        Document sbiDoc = XMLUtil.readXML((File)sbiBuildConfFile);
        if (sbiDoc == null) {
            return null;
        }
        if (!(requireVersion == null || requireVersion.isEmpty() || (version = XMLUtil.getDOMValue((Document)sbiDoc, (String)"/ssi/@version")) != null && VersionUtil.compareVersion((String)version, (String)requireVersion) >= 0)) {
            return null;
        }
        SSIScript ssi = new SSIScript();
        NodeList inputNodes = XMLUtil.getDOMNodes((Document)sbiDoc, (String)"/ssi/macros/input");
        for (i = 0; i < inputNodes.getLength(); ++i) {
            inputNode = inputNodes.item(i);
            if (!(inputNode instanceof Element) || (name = (elem = (Element)inputNode).getAttribute("name")) == null) continue;
            value = null;
            String method = elem.getAttribute("method");
            if (method.equals("xpath")) continue;
            if (method.equals("sysvar")) {
                String source = elem.getAttribute("source");
                String value0 = elem.getAttribute("value");
                if (source.equals("OS")) {
                    if (value0.equals("dir.separator")) {
                        value = File.separator;
                    } else if (value0.equals("path.separator")) {
                        value = File.pathSeparator;
                    }
                } else if (source.equals("SDK")) {
                    if (value0.equals("ssi.path")) {
                        value = (String)data.getProperty(value0);
                    } else if (value0.equals("build.options")) {
                        value = (String)data.getProperty(value0);
                    } else if (value0.equals("project.path")) {
                        value = (String)data.getProperty(value0);
                    } else if (value0.equals("project.output.path")) {
                        value = (String)data.getProperty(value0);
                    } else if (value0.equals("build.config")) {
                        value = (String)data.getProperty(value0);
                    } else if (value0.equals("build.arch")) {
                        value = (String)data.getProperty(value0);
                    } else if (value0.equals("app.id")) {
                        value = (String)data.getProperty(value0);
                    } else if (value0.equals("app.type")) {
                        value = (String)data.getProperty(value0);
                    }
                }
                if (value == null) continue;
                ssi.ssiMacro.addMacro(name, value);
                continue;
            }
            if (!method.equals("user") || (value = elem.getAttribute("value")) == null) continue;
            ssi.ssiMacro.addMacro(name, value);
        }
        inputNodes = XMLUtil.getDOMNodes((Document)sbiDoc, (String)"/ssi/variables/input");
        for (i = 0; i < inputNodes.getLength(); ++i) {
            inputNode = inputNodes.item(i);
            if (inputNode == null || !(inputNode instanceof Element) || (name = (elem = (Element)inputNode).getAttribute("name")) == null || name.isEmpty() || (value = elem.getAttribute("value")) == null || value.isEmpty()) continue;
            ssi.ssiMacro.addVariable(name, value);
        }
        NodeList filesetNodes = XMLUtil.getDOMNodes((Document)sbiDoc, (String)"/ssi/filesystem/fileset");
        for (int i2 = 0; i2 < filesetNodes.getLength(); ++i2) {
            Node fileset = filesetNodes.item(i2);
            if (fileset == null || !(fileset instanceof Element)) continue;
            SSIFileSet fs = new SSIFileSet();
            fs.setName(((Element)fileset).getAttribute("name"));
            NodeList fileentrys = XMLUtil.getDOMNodes((Element)((Element)fileset), (String)"fileentry");
            for (int j = 0; j < fileentrys.getLength(); ++j) {
                String type;
                Node fileentryNode = fileentrys.item(j);
                if (fileentryNode == null || !(fileentryNode instanceof Element) || (type = ((Element)fileentryNode).getAttribute("type")) == null || type.isEmpty()) continue;
                String src = ((Element)fileentryNode).getAttribute("src");
                String des = ((Element)fileentryNode).getAttribute("des");
                String attr = ((Element)fileentryNode).getAttribute("attr");
                SSIFileSet.FileEntry fileentry = fs.addFileEntry(type.split(","), src, des, attr.split(","));
                NodeList filters = XMLUtil.getDOMNodes((Element)((Element)fileentryNode), (String)"filter");
                for (int k = 0; k < filters.getLength(); ++k) {
                    String exclude;
                    Node filterNode = filters.item(k);
                    if (!(filterNode instanceof Element)) continue;
                    String[] elem2 = (String[])filterNode;
                    String include = elem2.getAttribute("include");
                    if (include != null && !include.isEmpty()) {
                        String[] includes = include.split(";");
                        fileentry.addIncludeFilter(includes);
                    }
                    if ((exclude = elem2.getAttribute("exclude")) == null || exclude.isEmpty()) continue;
                    String[] excludes = exclude.split(";");
                    fileentry.addExcludeFilter(excludes);
                }
            }
            ssi.filesets.put(fs.getName(), fs);
        }
        NodeList structNodes = XMLUtil.getDOMNodes((Document)sbiDoc, (String)"/ssi/action/structure");
        for (int i3 = 0; i3 < structNodes.getLength(); ++i3) {
            Node struct = structNodes.item(i3);
            if (struct == null || !(struct instanceof Element)) continue;
            SSIStructure structure = new SSIStructure();
            structure.setName(((Element)struct).getAttribute("name"));
            structure.setFileFormat(((Element)struct).getAttribute("format"));
            NodeList procList = XMLUtil.getDOMNodes((Element)((Element)struct), (String)"proc");
            for (int j = 0; j < procList.getLength(); ++j) {
                String[] filesetRules;
                String[] targetRules;
                Node procNode = procList.item(j);
                if (procNode == null || !(procNode instanceof Element)) continue;
                Element elem3 = (Element)procNode;
                SSIProc proc = new SSIProc();
                String type = elem3.getAttribute("type");
                proc.setType(type);
                String target = elem3.getAttribute("target");
                for (String rule : targetRules = target.split(",")) {
                    if (rule.isEmpty()) continue;
                    proc.addTargetRule(rule);
                }
                String fileset = elem3.getAttribute("fileset");
                for (String rule : filesetRules = fileset.split(",")) {
                    if (rule.isEmpty()) continue;
                    proc.addFileSetRule(rule);
                }
                String src = elem3.getAttribute("src");
                proc.setSrc(src);
                String des = elem3.getAttribute("des");
                if (des != null && !des.isEmpty()) {
                    proc.setDes(des.split(","));
                }
                String script = elem3.getAttribute("transscript");
                proc.setTransScript(script);
                String echo = elem3.getAttribute("echo");
                proc.setEcho(echo);
                String require = elem3.getAttribute("require");
                proc.setRequire(require);
                String text = elem3.getTextContent();
                proc.setContent(text.trim());
                structure.addProc(proc);
            }
            ssi.structs.put(structure.getName(), structure);
        }
        return ssi;
    }

    public static SSIScript analisysPackageScript(File sbiBuildConfFile, SSIData data) {
        return SSIParser.analisysPackageScript(sbiBuildConfFile, data, null);
    }

    public static class SSIScript {
        public SSIMacro ssiMacro = new SSIMacro();
        public Map<String, SSIFileSet> filesets = new HashMap<String, SSIFileSet>();
        public Map<String, SSIStructure> structs = new HashMap<String, SSIStructure>();
        public Map<String, Document> doms = new HashMap<String, Document>();
    }
}

