/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.core.gputil;

import java.text.MessageFormat;

public class Assert {
    protected Assert() {
    }

    public static void fail(Object msg) {
        if (msg instanceof String) {
            throw new IllegalArgumentException((String)msg);
        }
        if (null != msg) {
            throw new IllegalArgumentException(msg.toString());
        }
    }

    public static void isTrue(boolean exp, String msg) {
        if (exp) {
            return;
        }
        Assert.fail(msg);
    }

    public static void isFalse(boolean exp, String msg) {
        if (!exp) {
            return;
        }
        Assert.fail(msg);
    }

    public static void isTrue(boolean exp) {
        Assert.isTrue(exp, "Expression must be true");
    }

    public static void isFalse(boolean exp) {
        Assert.isFalse(exp, "Expression must be false");
    }

    public static void isNull(Object obj, String msg) {
        Assert.isTrue(null == obj, msg);
    }

    public static void notNull(Object obj, String msg) {
        Assert.isFalse(null == obj, msg);
    }

    public static void isNull(Object obj) {
        Assert.isNull(obj, "Object must be null");
    }

    public static void notNull(Object obj) {
        Assert.notNull(obj, "Object must NOT be null");
    }

    public static void isInstanceOf(Class<?> type, Object obj, String msg) {
        Assert.notNull(type, "Type to check against must not be null");
        if (type.isInstance(obj)) {
            return;
        }
        Assert.fail(MessageFormat.format("{0}, Object of class [{1}] must be aan instance of {2}", msg, null == obj ? "null" : obj.getClass().getName(), type));
    }

    public static void isInstanceOf(Class<?> type, Object obj) {
        Assert.isInstanceOf(type, obj, "");
    }
}

