/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sbilib.model.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.tizen.sbilib.SBI;
import org.tizen.sbilib.constants.SBIConstants;
import org.tizen.sbilib.lib.Log;
import org.tizen.sbilib.lib.PathUtil;
import org.tizen.sbilib.lib.XmlParser;
import org.tizen.sbilib.model.plugin.Plugin;
import org.tizen.sbilib.model.plugin.Rootstrap;
import org.tizen.sbilib.model.plugin.Target;
import org.tizen.sbilib.model.plugin.Tool;
import org.tizen.sbilib.model.plugin.Toolchain;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class PluginManager {
    private static PluginManager pm = null;
    ArrayList<Rootstrap> rootstrapList = new ArrayList();
    ArrayList<Toolchain> toolchainList = new ArrayList();
    ArrayList<Target> targetList = new ArrayList();
    private Log log = SBI.log;

    private PluginManager() {
        this.init();
    }

    public void init() {
        this.clear();
        List<File> pluginFileList = this.getPluginFileList();
        this.loadPlugin(pluginFileList);
    }

    public void reInit() {
        this.init();
    }

    private void loadPlugin(List<File> pluginFileList) {
        this.log.info("Load plugin from file => " + pluginFileList);
        if (pluginFileList == null || pluginFileList.size() <= 0) {
            this.log.warn("Cannot load plugin file => " + pluginFileList);
            return;
        }
        for (File pluginFile : pluginFileList) {
            if (!"xml".equalsIgnoreCase(PathUtil.getExtension(pluginFile.getName()))) continue;
            Document dom = null;
            try {
                dom = XmlParser.parsing(pluginFile);
            }
            catch (ParserConfigurationException e) {
                this.log.exception(e);
                return;
            }
            catch (SAXException e) {
                this.log.exception(e);
                return;
            }
            catch (IOException e) {
                this.log.exception(e);
                return;
            }
            if (dom == null) {
                this.log.error("Cannot load plugin");
                continue;
            }
            Element extensionNode = (Element)dom.getElementsByTagName("extension").item(0);
            String value = extensionNode.getAttribute("point");
            if (value.equalsIgnoreCase("rootstrapDefinition")) {
                this.rootstrapList.add(new Rootstrap(dom, pluginFile));
                continue;
            }
            if (value.equalsIgnoreCase("toolchainDefinition")) {
                this.toolchainList.add(new Toolchain(dom, pluginFile));
                continue;
            }
            if (value.equalsIgnoreCase("targetDefinition")) {
                this.targetList.add(new Target(dom, pluginFile));
                continue;
            }
            this.log.warn("Unsupported plugin type. => " + value);
        }
    }

    public void savePlugin() {
        List<Plugin> pluginList = this.getPluginList();
        for (Plugin p : pluginList) {
            if (!p.isChanged()) continue;
            try {
                XmlParser.saveFile(p.getDocument(), p.getFile());
            }
            catch (TransformerFactoryConfigurationError e) {
                this.log.exception(e);
            }
            catch (TransformerException e) {
                this.log.exception(e);
            }
        }
    }

    private void clear() {
        if (this.rootstrapList.size() > 0) {
            this.rootstrapList.clear();
        }
        if (this.toolchainList.size() > 0) {
            this.toolchainList.clear();
        }
        if (this.targetList.size() > 0) {
            this.targetList.clear();
        }
    }

    private String getPluginPath() {
        return PathUtil.addPath(SBIConstants.SBI_PLUGIN_PATH);
    }

    public synchronized void addRootstrap(Rootstrap rootstrap) {
        String rId = null;
        for (Rootstrap r : this.rootstrapList) {
            rId = r.getId();
            if (rId == null || !rId.equals(rootstrap.getId())) continue;
            this.rootstrapList.remove(r);
            break;
        }
        this.rootstrapList.add(rootstrap);
    }

    public synchronized boolean removeRootstrap(Rootstrap rootstrap) {
        if (rootstrap == null) {
            this.log.warn("Rootstrap is null");
            return false;
        }
        if (!rootstrap.getFile().delete()) {
            this.log.error("Cannot remove the rootstrap file => " + rootstrap.getFile().getAbsolutePath());
            return false;
        }
        if (!this.rootstrapList.remove(rootstrap)) {
            this.log.warn("Target do not exist in rootstrap-list => " + rootstrap);
            this.log.warn("Rootstrap-list => " + this.rootstrapList);
            return false;
        }
        return true;
    }

    public synchronized boolean createTarget(String tId) {
        String rId = this.getRootstrapIdByTargetId(tId);
        String cId = this.getToolchainIdByTargetId(tId);
        return this.createTarget(rId, cId, tId);
    }

    public synchronized boolean createTarget(String rId, String cId, String tId) {
        this.log.info("Create target from rootstrap and toolchain");
        this.log.info("target id : " + tId);
        if (tId == null || tId.isEmpty()) {
            tId = this.makeTargetId(rId, cId);
        }
        if (!this.isAvailable(rId, cId, tId)) {
            this.log.error("Cannot create target");
            return false;
        }
        Document tDom = null;
        try {
            tDom = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            this.log.exception(e);
            return false;
        }
        Element extensionElement = tDom.createElement("extension");
        tDom.getDocumentElement();
        tDom.appendChild(extensionElement);
        extensionElement.setAttribute("point", "targetDefinition");
        Element targetElement = tDom.createElement("target");
        extensionElement.appendChild(targetElement);
        targetElement.setAttribute("id", tId);
        targetElement.setAttribute("name", tId);
        targetElement.setAttribute("rootstrapId", rId);
        targetElement.setAttribute("toolchainId", cId);
        String targetFilePath = PathUtil.addPath(SBIConstants.SBI_PLUGIN_PATH, tId + ".xml");
        File targetFile = new File(targetFilePath);
        try {
            this.log.info("New target save to " + targetFile);
            XmlParser.saveFile(tDom, targetFile);
        }
        catch (TransformerFactoryConfigurationError e) {
            this.log.exception(e);
            return false;
        }
        catch (TransformerException e) {
            this.log.exception(e);
            return false;
        }
        this.targetList.add(new Target(tDom, targetFile));
        return true;
    }

    public boolean isAvailableTargetId(String targetId) {
        if (!this.exist(this.targetList, targetId)) {
            this.log.warn(targetId + " do not exist");
            this.log.warn("Target list => " + this.targetList);
            return false;
        }
        return true;
    }

    public boolean isAvailableRootstrapId(String rootstrapId) {
        if (!this.exist(this.rootstrapList, rootstrapId)) {
            this.log.warn(rootstrapId + " do not exist");
            this.log.warn("Target list => " + this.rootstrapList);
            return false;
        }
        return true;
    }

    public boolean isAvailableToolchainId(String toolchainId) {
        if (!this.exist(this.toolchainList, toolchainId)) {
            this.log.warn(toolchainId + " do not exist");
            this.log.warn("Target list => " + this.toolchainList);
            return false;
        }
        return true;
    }

    private boolean isAvailable(String rId, String cId, String tId) {
        if (!this.exist(this.rootstrapList, rId)) {
            this.log.error("Cannot find rootstrap id => " + rId);
            this.log.error("rootstrap list => " + this.rootstrapList);
            return false;
        }
        if (!this.exist(this.toolchainList, cId)) {
            this.log.error("Cannot find toolchain id => " + cId);
            this.log.error("toolchain list => " + this.toolchainList);
            return false;
        }
        return this.isTargetIdAvailableToCreate(tId);
    }

    private boolean isTargetIdAvailableToCreate(String id) {
        if (this.exist(this.rootstrapList, id)) {
            this.log.error("ID is not available. => " + id);
            this.log.error("exist in rootstrap list => " + this.rootstrapList);
            return false;
        }
        if (this.exist(this.toolchainList, id)) {
            this.log.error("ID is not available. => " + id);
            this.log.error("exist in toolchain list => " + this.toolchainList);
            return false;
        }
        if (this.exist(this.targetList, id)) {
            this.log.error("ID is not available. => " + id);
            this.log.error("exist in target list => " + this.targetList);
            return false;
        }
        return true;
    }

    public synchronized boolean removeTarget(String tId) {
        if (tId == null || tId.isEmpty()) {
            this.log.warn("Target ID is empty => " + tId);
            return false;
        }
        Target t = this.getTarget(tId);
        return this.removeTarget(t);
    }

    public synchronized boolean removeTarget(Target target) {
        if (target == null) {
            this.log.warn("Target do not exist in target-list => " + target);
            this.log.warn("target-list => " + this.targetList);
            return false;
        }
        if (!target.getFile().delete()) {
            this.log.error("Cannot remove the target file => " + target.getFile().getAbsolutePath());
            return false;
        }
        if (!this.targetList.remove(target)) {
            this.log.warn("Target do not exist in target-list => " + target);
            this.log.warn("target-list => " + this.targetList);
            return false;
        }
        pm.reInit();
        return true;
    }

    public String makeTargetId(String rId, String cId) {
        return rId + "_" + cId;
    }

    public Properties getPluginInfo(String pId) {
        if (pId == null || pId.isEmpty()) {
            return null;
        }
        Plugin p = this.getPlugin(pId);
        if (p == null) {
            return null;
        }
        String point = p.getExtensionPoint();
        if (point == null) {
            this.log.warn("Cannot find plugin => " + pId);
            return null;
        }
        if (point.equalsIgnoreCase("rootstrapDefinition")) {
            return this.getRootstrapInfo((Rootstrap)p);
        }
        if (point.equalsIgnoreCase("toolchainDefinition")) {
            return this.getToolchainInfo((Toolchain)p);
        }
        if (point.equalsIgnoreCase("targetDefinition")) {
            return this.getTargetInfo((Target)p);
        }
        this.log.error("Cannot find plugin id => " + pId);
        return null;
    }

    public Properties getRootstrapInfo(String rId) {
        Rootstrap r = this.getRootstrap(rId);
        return this.getRootstrapInfo(r);
    }

    public Properties getToolchainInfo(String cId) {
        Toolchain t = this.getToolchain(cId);
        return this.getToolchainInfo(t);
    }

    public Properties getTargetInfo(String tId) {
        Target t = this.getTarget(tId);
        return this.getTargetInfo(t);
    }

    private Properties getRootstrapInfo(Rootstrap rs) {
        Properties props = new Properties();
        if (rs == null) {
            return props;
        }
        props.put("ID", rs.getId());
        props.put("NAME", rs.getName());
        props.put("ARCHITECTURE", rs.getArchitecture());
        props.put("VERSION", rs.getVersion());
        props.put("PATH", rs.getPath());
        props.putAll((Map<?, ?>)rs.getProperties());
        return props;
    }

    private Properties getToolchainInfo(Toolchain toolchain) {
        Properties props = new Properties();
        if (toolchain == null) {
            return props;
        }
        props.put("ID", toolchain.getId());
        props.put("NAME", toolchain.getName());
        props.put("ARCHITECTURE", toolchain.getArchitecture());
        props.put("VERSION", toolchain.getVersion());
        props.putAll((Map<?, ?>)toolchain.getProperties());
        return props;
    }

    private Properties getTargetInfo(Target target) {
        Properties props = new Properties();
        if (target == null) {
            return props;
        }
        props.put("ID", target.getId());
        props.put("NAME", target.getName());
        props.put("NAME", target.getName());
        props.putAll((Map<?, ?>)target.getProperties());
        return props;
    }

    public ArrayList<Rootstrap> getRootstrapList() {
        return this.rootstrapList;
    }

    public ArrayList<Toolchain> getToolchainList() {
        return this.toolchainList;
    }

    public ArrayList<Target> getTargetList() {
        return this.targetList;
    }

    public List<Plugin> getPluginList() {
        ArrayList<Plugin> pList = new ArrayList<Plugin>();
        pList.addAll(this.rootstrapList);
        pList.addAll(this.toolchainList);
        pList.addAll(this.targetList);
        return pList;
    }

    public Rootstrap getRootstrap(String rId) {
        return (Rootstrap)this.getPluginById(this.rootstrapList, rId);
    }

    public Rootstrap getRootstrapByTargetId(String targetId) {
        Target target = this.getTarget(targetId);
        if (target == null) {
            return null;
        }
        String rootstrapId = target.getRootstrapId();
        return this.getRootstrap(rootstrapId);
    }

    public Toolchain getToolchain(String cId) {
        return (Toolchain)this.getPluginById(this.toolchainList, cId);
    }

    public Target getTarget(String tId) {
        return (Target)this.getPluginById(this.targetList, tId);
    }

    public Plugin getPlugin(String pId) {
        return this.getPluginById(pId);
    }

    public Toolchain getToolchainByTargetId(String targetId) {
        if (targetId == null || targetId.isEmpty()) {
            return null;
        }
        Target t = this.getTarget(targetId);
        if (t == null) {
            return null;
        }
        Toolchain tChain = this.getToolchain(t.getToolchainId());
        return tChain;
    }

    public Tool getToolByTargetId(String targetId, String toolName) {
        if (targetId == null || targetId.isEmpty()) {
            this.log.warn("target id is empty.");
            return null;
        }
        if (toolName == null || toolName.isEmpty()) {
            this.log.warn("tool name is empty.");
            return null;
        }
        Target t = this.getTarget(targetId);
        if (t == null) {
            this.log.warn("Cannot find target => " + t);
            return null;
        }
        String toolchainId = t.getToolchainId();
        Toolchain tc = this.getToolchain(toolchainId);
        if (tc == null) {
            this.log.warn("Cannot find toolchain => " + toolchainId);
            return null;
        }
        Tool tool = tc.getTool(toolName);
        return tool;
    }

    public String getRootstrapIdByTargetId(String targetId) {
        int index = targetId.lastIndexOf("_");
        if (index < 0) {
            return "";
        }
        return targetId.substring(0, index);
    }

    public String getToolchainIdByTargetId(String targetId) {
        int index = targetId.lastIndexOf("_");
        if (index < 0) {
            return "";
        }
        return targetId.substring(index + 1, targetId.length());
    }

    private Plugin getPluginById(String pId) {
        if (pId == null || pId.isEmpty()) {
            return null;
        }
        return this.getPluginById(this.getPluginList(), pId);
    }

    private Plugin getPluginById(List<? extends Plugin> pList, String pId) {
        if (pList == null) {
            return this.getPluginById(pId);
        }
        if (pId == null || pId.isEmpty()) {
            return null;
        }
        for (Plugin plugin : pList) {
            String id = plugin.getId();
            if (id == null || !plugin.getId().equals(pId)) continue;
            return plugin;
        }
        this.log.warn("Cannot find plugin => " + pId);
        return null;
    }

    private boolean exist(List<? extends Plugin> pList, String pId) {
        Plugin p = this.getPluginById(pList, pId);
        return p != null;
    }

    public boolean isEmpty() {
        return this.rootstrapList.isEmpty() && this.toolchainList.isEmpty() && this.targetList.isEmpty();
    }

    private List<File> getPluginFileList() {
        String pluginPath = this.getPluginPath();
        File pluginDirFile = new File(pluginPath);
        if (!pluginDirFile.exists()) {
            return Collections.emptyList();
        }
        return Arrays.asList(pluginDirFile.listFiles());
    }

    public static synchronized PluginManager getInstance() {
        if (pm == null) {
            pm = new PluginManager();
        }
        return pm;
    }
}

