/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sbilib.model.plugin;

import java.io.File;
import java.util.List;
import java.util.Properties;
import org.tizen.sbilib.model.plugin.Plugin;
import org.tizen.sbilib.model.plugin.Tool;
import org.tizen.sbilib.model.plugin.ToolchainAction;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Toolchain
extends Plugin {
    public Toolchain(Document dom, File file) {
        super(dom, file);
    }

    @Override
    public String getId() {
        return this.getData("toolchain", "id", 0);
    }

    @Override
    public String getName() {
        return this.getData("toolchain", "name", 0);
    }

    public String getVersion() {
        return this.getData("toolchain", "version", 0);
    }

    public String getArchitecture() {
        return this.getData("toolchain", "architecture", 0);
    }

    public String getToolchainPath() {
        return this.getData("toolchain", "path", 0);
    }

    public String getToolchainType() {
        return this.getData("toolchain", "toolchainType", 0);
    }

    public String getProjectType() {
        Properties props = this.getProperties();
        if (props == null || props.isEmpty()) {
            return null;
        }
        return props.getProperty("PROJECT_TYPE");
    }

    @Override
    public String getPropertyValue(String key) {
        Properties props = this.getProperties();
        if (props == null || props.isEmpty()) {
            return null;
        }
        return props.getProperty(key);
    }

    public Tool getCCompiler() {
        List<Tool> toolList = this.getTools();
        if (toolList == null || toolList.isEmpty()) {
            return null;
        }
        for (Tool t : toolList) {
            if (!t.getName().equalsIgnoreCase("c_compiler")) continue;
            return t;
        }
        return null;
    }

    public List<Tool> getToolList() {
        return this.getTools();
    }

    public Tool getCppCompiler() {
        List<Tool> toolList = this.getTools();
        if (toolList == null || toolList.isEmpty()) {
            return null;
        }
        for (Tool t : toolList) {
            if (!t.getName().equalsIgnoreCase("c_compiler")) continue;
            return t;
        }
        return null;
    }

    public Tool getArchiver() {
        return this.getTool("archiver");
    }

    public Tool getDebugger() {
        List<Tool> toolList = this.getTools();
        if (toolList == null || toolList.isEmpty()) {
            return null;
        }
        for (Tool t : toolList) {
            if (!t.getName().equalsIgnoreCase("debugger")) continue;
            return t;
        }
        return null;
    }

    public Tool getAssembler() {
        List<Tool> toolList = this.getTools();
        if (toolList == null || toolList.isEmpty()) {
            return null;
        }
        for (Tool t : toolList) {
            if (!t.getName().equalsIgnoreCase("assembler")) continue;
            return t;
        }
        return null;
    }

    public Tool getStrip() {
        List<Tool> toolList = this.getTools();
        if (toolList == null || toolList.isEmpty()) {
            return null;
        }
        for (Tool t : toolList) {
            if (!t.getName().equalsIgnoreCase("strip")) continue;
            return t;
        }
        return null;
    }

    public Tool getEdjeCC() {
        List<Tool> toolList = this.getTools();
        if (toolList == null || toolList.isEmpty()) {
            return null;
        }
        for (Tool t : toolList) {
            if (!t.getName().equalsIgnoreCase("edje_cc")) continue;
            return t;
        }
        return null;
    }

    public Tool getMake() {
        List<Tool> toolList = this.getTools();
        if (toolList == null || toolList.isEmpty()) {
            return null;
        }
        for (Tool t : toolList) {
            if (!t.getName().equalsIgnoreCase("make")) continue;
            return t;
        }
        return null;
    }

    public Tool getMsgfmt() {
        List<Tool> toolList = this.getTools();
        if (toolList == null || toolList.isEmpty()) {
            return null;
        }
        for (Tool t : toolList) {
            if (!t.getName().equalsIgnoreCase("msgfmt")) continue;
            return t;
        }
        return null;
    }

    public Tool getTpkPackager() {
        List<Tool> toolList = this.getTools();
        if (toolList == null || toolList.isEmpty()) {
            return null;
        }
        for (Tool t : toolList) {
            if (!t.getName().equalsIgnoreCase("tpk_packager")) continue;
            return t;
        }
        return null;
    }

    public Tool getNativeSigner() {
        List<Tool> toolList = this.getTools();
        if (toolList == null || toolList.isEmpty()) {
            return null;
        }
        for (Tool t : toolList) {
            if (!t.getName().equalsIgnoreCase("native_signer")) continue;
            return t;
        }
        return null;
    }

    public Tool getBinutils() {
        List<Tool> toolList = this.getTools();
        if (toolList == null || toolList.isEmpty()) {
            return null;
        }
        for (Tool t : toolList) {
            if (!t.getName().equalsIgnoreCase("binutils")) continue;
            return t;
        }
        return null;
    }

    public ToolchainAction getMakeAction() {
        return this.getActionByName("make");
    }

    public ToolchainAction getCleanAction() {
        return this.getActionByName("clean");
    }

    public ToolchainAction getBuildPackageAction() {
        return this.getActionByName("buildpackage");
    }

    public ToolchainAction getDebugAction() {
        return this.getActionByName("debug");
    }

    public ToolchainAction getKillAction() {
        return this.getActionByName("kill");
    }

    public ToolchainAction getActionByName(String actionName) {
        if (actionName == null || actionName.isEmpty()) {
            return null;
        }
        NodeList actionList = this.getElementsByTagName("action");
        if (actionList == null) {
            return null;
        }
        for (int i = 0; i < actionList.getLength(); ++i) {
            Element e = (Element)actionList.item(i);
            String nameValue = e.getAttribute("name");
            if (!actionName.equalsIgnoreCase(nameValue)) continue;
            return new ToolchainAction(actionName, e);
        }
        return null;
    }

    public boolean isDefault() {
        Properties props = this.getProperties();
        String value = props.getProperty("DEFAULT");
        if (value == null) {
            return false;
        }
        return value.equalsIgnoreCase(Boolean.TRUE.toString());
    }
}

