/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sbilib.for_cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.tizen.core.gputil.XMLUtil;
import org.tizen.sbilib.for_cli.RootstrapData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RootstrapManager {
    public static List<RootstrapData> getRootstrapDataList(String sbiHomePath) {
        File sbiHomeFile = new File(sbiHomePath, "plugins");
        File[] xmlFiles = sbiHomeFile.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".xml");
            }
        });
        String xpath = "/extension[@point='rootstrapDefinition']";
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath expr = xpathFactory.newXPath();
        if (xmlFiles != null) {
            ArrayList<RootstrapData> ids = new ArrayList<RootstrapData>();
            for (File xmlFile : xmlFiles) {
                try {
                    Document doc = XMLUtil.readXML((InputStream)new FileInputStream(xmlFile));
                    NodeList nodes = null;
                    Object nodeset = null;
                    try {
                        nodeset = expr.evaluate(xpath, doc, XPathConstants.NODESET);
                    }
                    catch (XPathExpressionException e) {
                        e.printStackTrace();
                        continue;
                    }
                    if (nodeset == null || !(nodeset instanceof NodeList)) continue;
                    nodes = (NodeList)nodeset;
                    int size = nodes.getLength();
                    for (int i = 0; i < size; ++i) {
                        Node node = nodes.item(i);
                        if (!(node instanceof Element)) continue;
                        NodeList rootStraps = ((Element)node).getElementsByTagName("rootstrap");
                        int rootstrapSize = rootStraps.getLength();
                        for (int j = 0; j < rootstrapSize; ++j) {
                            Element propElem;
                            int k;
                            Element element = (Element)rootStraps.item(j);
                            String id = element.getAttribute("id");
                            String name = element.getAttribute("name");
                            String version = element.getAttribute("version");
                            String architecture = element.getAttribute("architecture");
                            String path = element.getAttribute("path");
                            RootstrapData rootStrapData = new RootstrapData(id, name, version, architecture, path);
                            rootStrapData.addProperty("id", id);
                            rootStrapData.addProperty("name", name);
                            rootStrapData.addProperty("version", version);
                            rootStrapData.addProperty("architecture", architecture);
                            rootStrapData.addProperty("path", path);
                            NodeList childNodes = element.getElementsByTagName("property");
                            int elemSize = childNodes.getLength();
                            for (k = 0; k < elemSize; ++k) {
                                propElem = (Element)childNodes.item(k);
                                rootStrapData.addProperty(propElem.getAttribute("key"), propElem.getAttribute("value"));
                            }
                            childNodes = element.getElementsByTagName("toolchain");
                            elemSize = childNodes.getLength();
                            for (k = 0; k < elemSize; ++k) {
                                propElem = (Element)childNodes.item(k);
                                rootStrapData.addToolchain(propElem.getAttribute("name"), propElem.getAttribute("version"), Boolean.valueOf(propElem.getAttribute("default")));
                            }
                            childNodes = element.getElementsByTagName("tool");
                            elemSize = childNodes.getLength();
                            for (k = 0; k < elemSize; ++k) {
                                propElem = (Element)childNodes.item(k);
                                rootStrapData.addTool(propElem.getAttribute("name"), propElem.getAttribute("version"), propElem.getAttribute("path"));
                            }
                            ids.add(rootStrapData);
                        }
                    }
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                    return null;
                }
            }
            return ids;
        }
        return null;
    }

    public static RootstrapData getRootstrap(List<RootstrapData> rootstrapList, String rootstrapId) {
        if (rootstrapId == null) {
            return null;
        }
        for (RootstrapData rootstrap : rootstrapList) {
            if (!rootstrapId.equals(rootstrap.getId())) continue;
            return rootstrap;
        }
        return null;
    }

    public static RootstrapData getRootstrap(List<RootstrapData> rootstrapList, String platformName, String architecture) {
        if (platformName == null || architecture == null) {
            return null;
        }
        for (RootstrapData rootstrap : rootstrapList) {
            if (!platformName.equalsIgnoreCase(rootstrap.getPlatformName()) || !architecture.equalsIgnoreCase(rootstrap.getArchitecture())) continue;
            return rootstrap;
        }
        return null;
    }
}

