/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.library.sdkutils.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.tizen.library.sdkutils.util.PlatformUtil;
import org.tizen.library.sdkutils.util.SDKInfoUtil;
import org.tizen.library.sdkutils.util.WindowsRegistry;

public class PathUtil {
    public static final int BUF_SIZE = 65536;
    private static final String FILE_EXTENSION_SEPERATOR = ".";
    private static final String DIRECTORY_SEPERATOR = File.separator;

    private static String getLastNameFromLastSeperator(String path, String Seperator) {
        int lastIndex = path.lastIndexOf(Seperator);
        if (lastIndex < 0) {
            return path;
        }
        return path.substring(lastIndex + 1);
    }

    public static String getFileExtension(String path) {
        int lastIndex = path.lastIndexOf(FILE_EXTENSION_SEPERATOR);
        if (lastIndex < 0) {
            return "";
        }
        return path.substring(lastIndex);
    }

    public static String getFileName(String path) {
        return PathUtil.getLastNameFromLastSeperator(path, DIRECTORY_SEPERATOR);
    }

    public static String getPath(String ... path_components) {
        String path = "";
        for (int i = 0; i < path_components.length; ++i) {
            path = i == 0 ? path_components[0] : path + File.separator + path_components[i];
        }
        return path;
    }

    public static String getClassPath(Class<?> curClass) {
        String classPath = curClass.getProtectionDomain().getCodeSource().getLocation().getPath();
        try {
            classPath = URLDecoder.decode(classPath, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        File classFile = new File(classPath);
        String classDirectoryPath = classFile.getParent();
        return classDirectoryPath;
    }

    public static String getFromHome(String ... path_components) {
        return System.getProperty("user.home") + File.separator + PathUtil.getPath(path_components);
    }

    public static String getFromInstalledPath(String ... path_components) {
        String installPath = SDKInfoUtil.findSDKInstallPath(PathUtil.class);
        if (installPath == null || installPath.equals("")) {
            return "";
        }
        return installPath + File.separator + PathUtil.getPath(path_components);
    }

    public static String getCurrentDir() {
        return System.getProperty("user.dir");
    }

    public static String getFromCurrDir(String ... path_components) {
        return PathUtil.getPath(PathUtil.getCurrentDir(), PathUtil.getPath(path_components));
    }

    private static String getTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String getFromTempDir(String ... path_components) {
        return PathUtil.getPath(PathUtil.getTempDir() + File.separator + PathUtil.getPath(path_components));
    }

    public static String getFromAppData(String ... path_components) {
        return PathUtil.get(PathUtil.getLocalAppData() + File.separator + PathUtil.get(path_components));
    }

    private static String getLocalAppData() {
        if (PlatformUtil.isWindows()) {
            String path = System.getenv("LOCALAPPDATA");
            if (path == null) {
                path = WindowsRegistry.getRegistryValue("HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", "\"Local AppData\"");
            }
            return path;
        }
        return "";
    }

    public static String get(String ... path_components) {
        String path = "";
        for (int i = 0; i < path_components.length; ++i) {
            path = i == 0 ? path_components[0] : path + File.separator + path_components[i];
        }
        return path;
    }

    public static String getUpdateManagerConfigHome() {
        if (PlatformUtil.isLinux() || PlatformUtil.isMacOS()) {
            return PathUtil.getFromHome(".package-manager");
        }
        if (PlatformUtil.isWindows()) {
            return PathUtil.getFromAppData(".package-manager");
        }
        return PathUtil.getFromHome(".package-manager");
    }
}

